/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.member;

import java.util.Arrays;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsColumnPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.AnnotatedAsIdPred;
import org.netbeans.modules.javacore.jmiimpl.javamodel.BooleanLiteralImpl;

public class IdColumnHasNullableSetToFalse
extends AbstractRule {
    public IdColumnHasNullableSetToFalse() {
        super(null, Arrays.asList(new AnnotatedAsIdPred(), new AnnotatedAsColumnPred()));
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            AnnotableElement ae = (AnnotableElement)AnnotableElement.class.cast(subject);
            Annotation column = ProblemFindingUtils.findAnnotation(ae, "javax.persistence.Column");
            for (AttributeValue attr : column.getAttributeValues()) {
                if (!"nullable".equals(attr.getName())) continue;
                InitialValue value = attr.getValue();
                JEEVerificationAnnotationProvider.tmpDbg("nullable=" + value);
                try {
                    if (!((BooleanLiteralImpl)BooleanLiteralImpl.class.cast(value)).isValue()) continue;
                    return this.createProblem(ctx, (Element)value);
                }
                catch (ClassCastException cce) {
                }
            }
        }
        return null;
    }

    protected String getMessageKey() {
        return "MSG_IdColumnHasNullableSetToTrue";
    }

    public String getId() {
        return "IdColumnHasNullableSetToFalse";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) && super.isApplicable(subject, ctx);
    }
}

