/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding.soap;

import com.sun.xml.ws.encoding.EncoderDecoderBase;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.ws.encoding.soap.SerializationException;
import com.sun.xml.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.handler.HandlerContext;
import com.sun.xml.ws.handler.MessageContextUtil;
import com.sun.xml.ws.model.Parameter;
import com.sun.xml.ws.model.ParameterBinding;
import com.sun.xml.ws.model.RuntimeModel;
import com.sun.xml.ws.model.WrapperParameter;
import com.sun.xml.ws.model.soap.SOAPBinding;
import com.sun.xml.ws.server.RuntimeContext;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EncoderDecoder
extends EncoderDecoderBase {
    protected Object fillData(RuntimeContext context, Parameter param, Object obj, Object[] data, SOAPBinding binding, ParameterBinding paramBinding) {
        if (param.isWrapperStyle()) {
            Object resp = null;
            for (Parameter p : ((WrapperParameter)param).getWrapperChildren()) {
                QName name = p.getName();
                Object value = null;
                if (binding.isDocLit()) {
                    value = super.getWrapperChildValue(context, ((JAXBBridgeInfo)obj).getValue(), name.getNamespaceURI(), name.getLocalPart());
                } else if (binding.isRpcLit() && (value = this.getWrapperChildValue(context, obj, name.getNamespaceURI(), name.getLocalPart())) == null) {
                    value = this.setIfPrimitive(p.getTypeReference().type);
                }
                if (p.isResponse()) {
                    resp = value;
                    continue;
                }
                if (data[p.getIndex()] != null) {
                    Parameter.setHolderValue(data[p.getIndex()], value);
                    continue;
                }
                data[p.getIndex()] = p.createHolderValue(value);
            }
            return resp;
        }
        if (!paramBinding.isAttachment()) {
            if (paramBinding.isUnbound()) {
                obj = this.setIfPrimitive(param.getTypeReference().type);
            } else {
                Object object = obj = obj != null ? ((JAXBBridgeInfo)obj).getValue() : null;
            }
        }
        if (param.isResponse()) {
            if (paramBinding.isUnbound()) {
                return this.setIfPrimitive(param.getTypeReference().type);
            }
            return obj;
        }
        if (data[param.getIndex()] != null) {
            Parameter.setHolderValue(data[param.getIndex()], obj);
        } else {
            data[param.getIndex()] = param.createHolderValue(obj);
        }
        return null;
    }

    private Object setIfPrimitive(Type type) {
        Class cls;
        if (type instanceof Class && (cls = (Class)type).isPrimitive()) {
            if (cls.getName().equals(Boolean.TYPE.getName())) {
                return false;
            }
            return 0;
        }
        return null;
    }

    protected Object createPayload(RuntimeContext context, Parameter param, Object[] data, Object result, SOAPBinding binding, ParameterBinding paramBinding) {
        if (paramBinding.isAttachment()) {
            Object obj = null;
            obj = param.isResponse() ? result : param.getHolderValue(data[param.getIndex()]);
            return obj;
        }
        if (binding.isRpcLit() && paramBinding.isBody()) {
            return this.createRpcLitPayload(context, (WrapperParameter)param, data, result);
        }
        Object obj = this.createDocLitPayloadValue(context, param, data, result);
        RuntimeModel model = context.getModel();
        return new JAXBBridgeInfo(model.getBridge(param.getTypeReference()), obj);
    }

    @Override
    protected Object getWrapperChildValue(RuntimeContext context, Object obj, String nsURI, String localName) {
        RpcLitPayload payload = (RpcLitPayload)obj;
        JAXBBridgeInfo rpcParam = payload.getBridgeParameterByName(localName);
        if (rpcParam != null) {
            return rpcParam.getValue();
        }
        return null;
    }

    private Object createDocLitPayloadValue(RuntimeContext context, Parameter param, Object[] data, Object result) {
        if (param.isWrapperStyle()) {
            return this.createJAXBBeanPayload(context, (WrapperParameter)param, data, result);
        }
        return this.getBarePayload(param, data, result);
    }

    protected HeaderBlock getHeaderBlock(QName name, List<HeaderBlock> headers) {
        for (HeaderBlock header : headers) {
            if (!name.equals(header.getName())) continue;
            return header;
        }
        return null;
    }

    private Object getBarePayload(Parameter param, Object[] data, Object result) {
        Object obj = null;
        obj = param.isResponse() ? result : param.getHolderValue(data[param.getIndex()]);
        return obj;
    }

    private Object createJAXBBeanPayload(RuntimeContext context, WrapperParameter param, Object[] data, Object result) {
        Class bean = (Class)param.getTypeReference().type;
        try {
            Object obj = bean.newInstance();
            for (Parameter p : param.getWrapperChildren()) {
                Object value = p.isResponse() ? result : p.getHolderValue(data[p.getIndex()]);
                QName name = p.getName();
                this.setWrapperChildValue(context, obj, value, name.getNamespaceURI(), name.getLocalPart());
            }
            return obj;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private Object createRpcLitPayload(RuntimeContext context, WrapperParameter param, Object[] data, Object result) {
        RpcLitPayload payload = new RpcLitPayload(param.getName());
        for (Parameter p : param.getWrapperChildren()) {
            if (p.getBinding().isUnbound()) continue;
            Object value = null;
            value = p.isResponse() ? result : p.getHolderValue(data[p.getIndex()]);
            RuntimeModel model = context.getModel();
            JAXBBridgeInfo bi = new JAXBBridgeInfo(model.getBridge(p.getTypeReference()), value);
            payload.addParameter(bi);
        }
        return payload;
    }

    protected Object getAttachment(RuntimeContext rtContext, Map<String, AttachmentBlock> attachments, Parameter param, ParameterBinding paramBinding) {
        try {
            for (Map.Entry<String, AttachmentBlock> entry : attachments.entrySet()) {
                AttachmentBlock ab = entry.getValue();
                String part = ab.getWSDLPartName();
                if (part == null || !part.equals(param.getPartName()) && !part.equals("<" + param.getPartName())) continue;
                Class type = (Class)param.getTypeReference().type;
                if (DataHandler.class.isAssignableFrom(type)) {
                    return ab.asDataHandler();
                }
                if (byte[].class == type) {
                    return ab.asByteArray();
                }
                if (Source.class.isAssignableFrom(type)) {
                    return ab.asSource();
                }
                if (Image.class.isAssignableFrom(type)) {
                    return ab.asImage();
                }
                if (InputStream.class == type) {
                    return ab.asDataHandler().getInputStream();
                }
                if (!this.isXMLMimeType(paramBinding.getMimeType())) continue;
                JAXBBridgeInfo bi = (JAXBBridgeInfo)rtContext.getDecoderInfo(param.getName());
                ab.deserialize(rtContext.getBridgeContext(), bi);
                return bi.getValue();
            }
            return null;
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    protected void addAttachmentPart(RuntimeContext rtContext, InternalMessage im, Object obj, Parameter mimeParam) {
        MessageContext mc;
        String contentId;
        if (obj == null) {
            return;
        }
        RuntimeModel model = rtContext.getModel();
        String mimeType = mimeParam.getBinding().getMimeType();
        try {
            contentId = URLEncoder.encode(mimeParam.getPartName(), "UTF-8") + '=' + UUID.randomUUID() + "@jaxws.sun.com";
            contentId = "<" + contentId + ">";
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException(e);
        }
        AttachmentBlock ab = obj instanceof DataHandler ? AttachmentBlock.fromDataHandler(contentId, (DataHandler)obj) : (obj instanceof Source ? AttachmentBlock.fromDataHandler(contentId, new DataHandler(obj, mimeType)) : (obj instanceof byte[] ? AttachmentBlock.fromByteArray(contentId, (byte[])obj, mimeType) : (this.isXMLMimeType(mimeType) ? AttachmentBlock.fromJAXB(contentId, new JAXBBridgeInfo(model.getBridge(mimeParam.getTypeReference()), obj), rtContext, mimeType) : AttachmentBlock.fromDataHandler(contentId, new DataHandler(obj, mimeType)))));
        HandlerContext hc = rtContext.getHandlerContext();
        if (hc != null && (mc = hc.getMessageContext()) != null) {
            MessageContextUtil.addMessageAttachment(mc, ab.getId(), ab.asDataHandler());
        }
        im.addAttachment(ab);
    }

    protected void copyAttachmentProperty(Map<String, Object> ctxt, InternalMessage im) {
        if (ctxt == null) {
            return;
        }
        Map attMap = (Map)ctxt.get("javax.xml.ws.binding.attachments.outbound");
        if (attMap == null) {
            return;
        }
        for (Map.Entry att : attMap.entrySet()) {
            im.addAttachment(AttachmentBlock.fromDataHandler((String)att.getKey(), (DataHandler)att.getValue()));
        }
    }

    private boolean isXMLMimeType(String mimeType) {
        return mimeType.equals("text/xml") || mimeType.equals("application/xml");
    }
}

