/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.xml.ws.server.DocInfo;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.server.WSDLPatcher;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLPublisher {
    private List<RuntimeEndpointInfo> endpoints;
    private Localizer localizer;
    private LocalizableMessageFactory messageFactory;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");

    public WSDLPublisher(ServletContext context, List<RuntimeEndpointInfo> endpoints) {
        this.endpoints = endpoints;
        this.localizer = new Localizer();
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.ws.resources.wsservlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RuntimeEndpointInfo targetEndpoint, Map fixedUrlPatternEndpoints, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Iterator urlPatterns = fixedUrlPatternEndpoints.entrySet().iterator();
        String urlPattern = null;
        while (urlPatterns.hasNext()) {
            Map.Entry entry = urlPatterns.next();
            String testPattern = (String)entry.getKey();
            if (targetEndpoint != (RuntimeEndpointInfo)entry.getValue()) continue;
            urlPattern = testPattern;
            break;
        }
        if (urlPattern == null) {
            urlPattern = targetEndpoint.getUrlPattern();
            if (urlPattern.endsWith("/*")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 2);
            }
            fixedUrlPatternEndpoints.put(urlPattern, targetEndpoint);
        }
        StringBuffer addrBuf = new StringBuffer();
        addrBuf.append(request.getScheme());
        addrBuf.append("://");
        addrBuf.append(request.getServerName());
        addrBuf.append(":");
        addrBuf.append(request.getServerPort());
        addrBuf.append(request.getRequestURI());
        String actualAddress = addrBuf.toString();
        String baseAddress = actualAddress.substring(0, actualAddress.lastIndexOf(urlPattern));
        String inPath = targetEndpoint.getPath(request.getQueryString());
        if (inPath == null) {
            this.writeNotFoundErrorPage(response, "Invalid Request");
            return;
        }
        DocInfo in = targetEndpoint.getDocMetadata().get(inPath);
        if (in == null) {
            this.writeNotFoundErrorPage(response, "Invalid Request");
            return;
        }
        response.setContentType("text/xml");
        response.setStatus(200);
        ServletOutputStream outputStream = response.getOutputStream();
        WSDLPatcher patcher = new WSDLPatcher(in, baseAddress, targetEndpoint, this.endpoints);
        InputStream is = in.getDoc();
        try {
            patcher.patchDoc(is, (OutputStream)outputStream);
        }
        finally {
            is.close();
        }
    }

    protected void writeNotFoundErrorPage(HttpServletResponse response, String message) throws IOException {
        response.setStatus(404);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println(this.localizer.localize(this.messageFactory.getMessage("servlet.html.title", new Object[0])));
        out.println("</title></head>");
        out.println("<body>");
        out.println(this.localizer.localize(this.messageFactory.getMessage("servlet.html.notFound", message)));
        out.println("</body>");
        out.println("</html>");
    }
}

