/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.perftool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.netbeans.core.perftool.Parser;

final class Extractor {
    private Extractor() {
    }

    public static Parser.Field[] extractDateValues(String tag, File[] logs) throws IOException {
        Parser.Field[] fields = Extractor.extractFields(tag, logs);
        Arrays.sort(fields, new FieldDateComparator());
        return fields;
    }

    public static Parser.Field[] extractTimeValues(String tag, File[] logs) throws IOException {
        Parser.Field[] fields = Extractor.extractFields(tag, logs);
        Arrays.sort(fields, new FieldTimeComparator());
        return fields;
    }

    private static Parser.Field[] extractFields(String tag, File[] logs) throws IOException {
        ArrayList<Parser.Field> fields = new ArrayList<Parser.Field>(200);
        for (int i = 0; i < logs.length; ++i) {
            Parser.SessionInfo[] sessions = Parser.getData(logs[i]);
            for (int j = 0; j < sessions.length; ++j) {
                Parser.Field field = sessions[j].getField(tag);
                if (field == null) continue;
                fields.add(field);
            }
        }
        return fields.toArray(new Parser.Field[fields.size()]);
    }

    static final class FieldDateComparator
    implements Comparator {
        FieldDateComparator() {
        }

        public boolean equals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            Parser.Field flda = (Parser.Field)o1;
            Parser.Field fldb = (Parser.Field)o2;
            return flda.getSessionInfo().getDate().equals(fldb.getSessionInfo().getDate());
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Parser.Field flda = (Parser.Field)o1;
            Parser.Field fldb = (Parser.Field)o2;
            return flda.getSessionInfo().getDate().compareTo(fldb.getSessionInfo().getDate());
        }
    }

    static final class FieldTimeComparator
    implements Comparator {
        FieldTimeComparator() {
        }

        public boolean equals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            Parser.Field flda = (Parser.Field)o1;
            Parser.Field fldb = (Parser.Field)o2;
            return flda.getTime() == fldb.getTime();
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Parser.Field flda = (Parser.Field)o1;
            Parser.Field fldb = (Parser.Field)o2;
            if (flda.getTime() == fldb.getTime()) {
                return 0;
            }
            if (flda.getTime() > fldb.getTime()) {
                return 1;
            }
            return -1;
        }
    }
}

