/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.perftool;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.core.perftool.Util;

final class Parser {
    private static final String nline = System.getProperty("line.separator");
    private static final Pattern SESSION_START_PATTERN = Pattern.compile("^([\\-]+)" + nline + "^(>Log Session: .*)", 8);
    private static Pattern SESSION_END_PATTERN = Pattern.compile("^([\\-]+)" + nline, 8);
    private static Pattern ENTRY_PATTERN = Pattern.compile("^\\Q[IDE-Perf] \\E([^0-9]+)([0-9]+)\\.([0-9]+) s", 8);

    private Parser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionInfo[] getData(File f) throws IOException {
        Matcher m;
        StringBuffer iter;
        FileReader r = new FileReader(f);
        try {
            int read;
            StringBuffer b = new StringBuffer((int)f.length());
            char[] buf = new char[4096];
            while ((read = r.read(buf)) != -1) {
                b.append(buf, 0, read);
            }
            iter = b;
        }
        finally {
            ((Reader)r).close();
        }
        ArrayList<SessionInfo> sessions = new ArrayList<SessionInfo>(20);
        int idx = 0;
        while ((m = SESSION_START_PATTERN.matcher(iter.subSequence(idx, iter.length()))).find()) {
            int start = m.start();
            Parser.parseEntries(iter, idx, start, sessions);
            Matcher m2 = SESSION_END_PATTERN.matcher(iter.subSequence(m.end(), iter.length()));
            if (!m2.find()) continue;
            int end = m2.end();
            SessionInfo info = new SessionInfo(Parser.trimString(((Object)iter.subSequence(start, end)).toString()));
            sessions.add(info);
            idx = end;
        }
        return sessions.toArray(new SessionInfo[sessions.size()]);
    }

    private static void parseEntries(CharSequence iter, int startpos, int endpos, List sessions) throws IOException, PatternSyntaxException {
        Matcher m;
        int size = sessions.size();
        if (size == 0) {
            return;
        }
        SessionInfo session = (SessionInfo)sessions.get(size - 1);
        while (endpos > startpos && (m = ENTRY_PATTERN.matcher(iter.subSequence(startpos, iter.length()))).find()) {
            if (m.start() > endpos) {
                startpos = m.start();
                continue;
            }
            String entry = m.group();
            double timeVal = Parser.strings2Double(m.group(2), m.group(3));
            Field f = new Field(session, m.group(1), timeVal);
            session.addField(f);
            startpos = m.end();
        }
        if (session.size() == 0) {
            sessions.remove(size - 1);
        }
    }

    private static double strings2Double(String sx, String sy) {
        try {
            double ret = Double.parseDouble(sx);
            return ret += Double.parseDouble(sy) / Util.tenpower(sy.length());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    private static String trimString(String s) {
        char c;
        int idx = 0;
        int slen = s.length();
        if (slen == 0) {
            return s;
        }
        while (((c = s.charAt(idx++)) == '\n' || c == '\r') && idx < slen) {
        }
        --idx;
        if ((idx = (s = s.substring(idx)).length() - 1) < 0) {
            return s;
        }
        while (((c = s.charAt(idx--)) == '\n' || c == '\r') && idx >= 0) {
        }
        return s.substring(0, idx + 2);
    }

    public static class Field {
        private String name;
        private double time;
        private SessionInfo session;

        Field(SessionInfo session, String name, double time) {
            this.name = name;
            this.time = time;
            this.session = session;
        }

        public String getName() {
            return this.name;
        }

        public double getTime() {
            return this.time;
        }

        public SessionInfo getSessionInfo() {
            return this.session;
        }
    }

    public static class SessionInfo {
        private String desc;
        private Map fields;
        private int build;
        private Date date;

        SessionInfo(String desc) {
            this.desc = desc;
            this.fields = new HashMap(80);
            this.build = SessionInfo.getBuildNumber(desc);
            Locale loc = SessionInfo.getLocale(desc);
            this.date = SessionInfo.getDate(desc, loc);
        }

        public String getDescription() {
            return this.desc;
        }

        void addField(Field f) {
            this.fields.put(f.getName(), f);
        }

        public Field getField(String name) {
            return (Field)this.fields.get(name);
        }

        public int getBuildNumber() {
            return this.build;
        }

        public Date getDate() {
            return this.date;
        }

        int size() {
            return this.fields.size();
        }

        private static int getBuildNumber(String desc) {
            try {
                int idx = desc.indexOf("(Build ");
                int paren = desc.indexOf(41, idx);
                String build = desc.substring(idx + 7, paren);
                if (build.equals("@BUILD_NUMBER_SUBST@")) {
                    return -1;
                }
                return Integer.parseInt(build);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return -1;
            }
        }

        private static Locale getLocale(String desc) {
            int idx = desc.indexOf("System Locale");
            idx = desc.indexOf("= ", idx);
            String[] locale = new String[]{null, "", ""};
            int ptr = 0;
            StringBuffer sb = new StringBuffer(3);
            char c = desc.charAt(idx += 2);
            while (Character.isLetter(c)) {
                if (c == ':') {
                    locale[ptr++] = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                c = desc.charAt(++idx);
            }
            locale[ptr] = sb.toString();
            return new Locale(locale[0], locale[1], locale[2]);
        }

        private static Date getDate(String desc, Locale locale) {
            int idx = desc.indexOf(">Log Session: ");
            int end = desc.indexOf(62, idx + 14);
            String date = Parser.trimString(desc.substring(idx + 14, end));
            DateFormat df = DateFormat.getDateTimeInstance(0, 0, locale);
            Date dt = df.parse(date, new ParsePosition(0));
            return dt;
        }
    }
}

