/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.ImportClass;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.java.hints.DeclarationInfo;
import org.netbeans.modules.javacore.api.JavaModel;

public final class GeneratorUtils {
    public static final int GETTER = 1;
    public static final int SETTER = 2;
    private static final int OK = 0;
    private static final int AMBIGUOUS = 1;
    private static final int CLASHING = 2;

    private GeneratorUtils() {
    }

    public static String handleImport(Resource rsc, Type type, boolean testOnly) {
        boolean substituteTypeParams = true;
        if (type instanceof Array) {
            return GeneratorUtils.handleImport(rsc, ((Array)type).getType(), testOnly) + "[]";
        }
        if (type instanceof TypeParameter && substituteTypeParams) {
            return GeneratorUtils.handleImport(rsc, ((TypeParameter)type).getSuperClass(), testOnly);
        }
        if (type instanceof AnnotationType || type instanceof ParameterizedType && ((ParameterizedType)type).getDefinition() instanceof AnnotationType) {
            return "@" + GeneratorUtils.handleImport(rsc, (JavaClass)type, testOnly);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            JavaClass definition = p.getDefinition();
            List parameters = p.getParameters();
            StringBuffer result = new StringBuffer();
            result.append(GeneratorUtils.handleImport(rsc, definition, testOnly));
            if (parameters.size() > 0) {
                result.append('<');
                Iterator i = parameters.iterator();
                while (i.hasNext()) {
                    Type t = (Type)i.next();
                    result.append(GeneratorUtils.handleImport(rsc, t, testOnly));
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
                result.append('>');
            }
            return result.toString();
        }
        if (type instanceof JavaClass) {
            return GeneratorUtils.handleImport(rsc, (JavaClass)type, testOnly);
        }
        return type.getName();
    }

    private static String handleImport(Resource rsc, JavaClass clazz, boolean testOnly) {
        if (GeneratorUtils.autoImport(rsc, clazz, false, testOnly)) {
            return DeclarationInfo.getSimpleName((Type)clazz);
        }
        return clazz.getName();
    }

    private static int checkImport(JavaClass cls, Resource resource) {
        int status = 0;
        String simpleName = cls.getSimpleName();
        Iterator it = resource.getImports().iterator();
        block0: while (it.hasNext()) {
            Import imp = (Import)it.next();
            if (imp.isOnDemand()) {
                if (status != 0) continue;
                Iterator itt = imp.getImportedElements().iterator();
                while (itt.hasNext()) {
                    NamedElement el = (NamedElement)itt.next();
                    if (!(el instanceof JavaClass) || !simpleName.equals(((JavaClass)el).getSimpleName()) || el.equals(cls)) continue;
                    status = 1;
                    continue block0;
                }
                continue;
            }
            NamedElement el = imp.getImportedNamespace();
            if (!(el instanceof JavaClass) || !simpleName.equals(((JavaClass)el).getSimpleName()) || el.equals(cls) || el.getName().equals(cls.getName())) continue;
            return 2;
        }
        return status;
    }

    private static boolean isClassAlreadyImported(JavaClass cls, Resource resource, int status) {
        if (!cls.isInner()) {
            String pkgName = GeneratorUtils.getPackageName((ClassDefinition)cls);
            if (("java.lang".equals(pkgName) || resource.getPackageName().equals(pkgName)) && status == 0) {
                return true;
            }
            Iterator it = resource.getImports().iterator();
            while (it.hasNext()) {
                Import imp = (Import)it.next();
                if (imp.isOnDemand() && imp.getImportedElements().contains(cls) && status == 0) {
                    return true;
                }
                NamedElement el = imp.getImportedNamespace();
                if (!(el instanceof JavaClass) || !el.equals(cls) && !el.getName().equals(cls.getName()) || status != 0) continue;
                return true;
            }
        }
        Iterator it = resource.getImports().iterator();
        while (it.hasNext()) {
            Import imp = (Import)it.next();
            if (imp.isOnDemand() || !cls.equals(imp.getImportedNamespace())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean autoImport(Resource resource, JavaClass cls, boolean pasteFQN, boolean testOnly) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            if (resource != null) {
                int status = GeneratorUtils.checkImport(cls, resource);
                if (status == 2) {
                    boolean bl = false;
                    return bl;
                }
                if (!GeneratorUtils.isClassAlreadyImported(cls, resource, status) && !testOnly) {
                    GeneratorUtils.addImport((NamedElement)cls, resource);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
    }

    private static void addImport(NamedElement element, Resource resource) {
        String name = element.getName();
        ListIterator<Import> it = resource.getImports().listIterator();
        while (it.hasNext()) {
            Import imp = (Import)it.next();
            String impName = imp.getName();
            if (impName == null || name.compareTo(impName) >= 0) continue;
            it.previous();
            break;
        }
        ImportClass proxy = ((JavaModelPackage)resource.refOutermostPackage()).getImport();
        it.add(proxy.createImport(name, null, false, element instanceof JavaPackage));
    }

    private static String getPackageName(ClassDefinition jc) {
        String result;
        Resource res;
        if (jc instanceof UnresolvedClass) {
            String name = jc.getName();
            int index = name.lastIndexOf(46);
            return index < 0 ? "" : name.substring(0, index);
        }
        if (jc instanceof JavaClass && (res = jc.getResource()) != null && (result = res.getPackageName()) != null) {
            return result;
        }
        return "";
    }
}

