/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.openide.ErrorManager;

public class FormEvents {
    static final Event[] NO_EVENTS = new Event[0];
    private Map usedListeners = new HashMap();
    private Map usedMethods = new HashMap();
    private Map eventHandlers = new HashMap();
    private FormModel formModel;

    FormEvents(FormModel formModel) {
        this.formModel = formModel;
    }

    public boolean hasEventsInCEDL() {
        return !this.usedListeners.isEmpty();
    }

    public Class[] getCEDLTypes() {
        Collection infoValues = this.usedListeners.values();
        Class[] listenerTypes = new Class[infoValues.size()];
        int i = 0;
        Iterator it = infoValues.iterator();
        while (it.hasNext()) {
            listenerTypes[i++] = ((ListenerInfo)it.next()).listenerType;
        }
        return listenerTypes;
    }

    public Event[] getEventsForCEDLMethod(Method listenerMethod) {
        List eventList = (List)this.usedMethods.get(FormEvents.fullMethodName(listenerMethod));
        if (eventList == null) {
            return NO_EVENTS;
        }
        Event[] eventArray = new Event[eventList.size()];
        eventList.toArray(eventArray);
        return eventArray;
    }

    public Event[] getEventsForHandler(String handlerName) {
        List handlerEventList = (List)this.eventHandlers.get(handlerName);
        Event[] events = new Event[handlerEventList.size()];
        handlerEventList.toArray(events);
        return events;
    }

    public Method getOriginalListenerMethod(String handlerName) {
        List handlerEventList = (List)this.eventHandlers.get(handlerName);
        return handlerEventList != null ? ((Event)handlerEventList.get(0)).getListenerMethod() : null;
    }

    public String[] getAllEventHandlers() {
        Set nameSet = this.eventHandlers.keySet();
        String[] names = new String[nameSet.size()];
        nameSet.toArray(names);
        return names;
    }

    public void attachEvent(Event event, String handlerName, String handlerText) {
        boolean newHandler = false;
        if (handlerName == null && event.hasEventHandlers()) {
            handlerName = (String)event.getEventHandlerList().get(0);
            event = null;
        } else {
            ArrayList<Event> handlerEventList;
            if (handlerName != null) {
                handlerEventList = (ArrayList<Event>)this.eventHandlers.get(handlerName);
                if (handlerEventList != null) {
                    this.checkCompatibility(event, (Event)handlerEventList.get(0));
                }
            } else {
                handlerEventList = null;
                handlerName = this.findFreeHandlerName(event, event.getComponent());
            }
            if (handlerEventList == null) {
                handlerEventList = new ArrayList<Event>(3);
                this.eventHandlers.put(handlerName, handlerEventList);
                newHandler = true;
            }
            if (!event.isInCEDL()) {
                this.registerEventInCEDL(event);
            }
            if (event.addEventHandler(handlerName)) {
                handlerEventList.add(event);
            } else {
                event = null;
            }
        }
        this.formModel.fireEventHandlerAdded(event, handlerName, handlerText, newHandler);
    }

    public void detachEvent(Event event, String handlerName) {
        if (event.removeEventHandler(handlerName)) {
            if (!event.hasEventHandlers()) {
                this.unregisterEventFromCEDL(event);
            }
            this.detachEventHandler(event, handlerName);
        }
    }

    public void detachEvent(Event event) {
        this.unregisterEventFromCEDL(event);
        String[] handlerNames = event.getEventHandlers();
        for (int i = 0; i < handlerNames.length; ++i) {
            event.removeEventHandler(handlerNames[i]);
            this.detachEventHandler(event, handlerNames[i]);
        }
    }

    public void renameEventHandler(String oldHandlerName, String newHandlerName) {
        if (oldHandlerName == null || newHandlerName == null || oldHandlerName.equals(newHandlerName)) {
            return;
        }
        List handlerEventList = (List)this.eventHandlers.get(oldHandlerName);
        if (handlerEventList == null) {
            return;
        }
        if (this.eventHandlers.get(newHandlerName) == null) {
            for (int j = 0; j < handlerEventList.size(); ++j) {
                Event event = (Event)handlerEventList.get(j);
                event.renameEventHandler(oldHandlerName, newHandlerName);
            }
        } else {
            IllegalArgumentException iae = new IllegalArgumentException("Cannot rename handler");
            ErrorManager.getDefault().annotate((Throwable)iae, FormUtils.getBundleString("MSG_CannotRename"));
            throw iae;
        }
        this.eventHandlers.remove(oldHandlerName);
        this.eventHandlers.put(newHandlerName, handlerEventList);
        this.formModel.fireEventHandlerRenamed(oldHandlerName, newHandlerName);
    }

    public String findFreeHandlerName(Event event, RADComponent metacomp) {
        String componentName = metacomp == this.formModel.getTopRADComponent() ? "form" : metacomp.getName();
        String methodName = event.getListenerMethod().getName();
        return this.findFreeHandlerName(componentName + methodName.substring(0, 1).toUpperCase() + methodName.substring(1));
    }

    public String findFreeHandlerName(String baseName) {
        String name = baseName;
        int n = 0;
        while (this.eventHandlers.get(name) != null) {
            name = baseName + ++n;
        }
        return name;
    }

    static String getEventIdName(Method eventMethod) {
        StringBuffer buf = new StringBuffer(64);
        buf.append("$");
        buf.append(eventMethod.getDeclaringClass().getName());
        buf.append(".");
        buf.append(eventMethod.getName());
        buf.append("(");
        Class<?>[] parameterTypes = eventMethod.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            buf.append(parameterTypes[i].getName());
            if (i + 1 >= parameterTypes.length) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    private void registerEventInCEDL(Event event) {
        Class<?> listenerType = event.getEventSetDescriptor().getListenerType();
        if (!listenerType.isInterface()) {
            return;
        }
        Class<?>[] parameters = event.getListenerMethod().getParameterTypes();
        if (parameters.length == 0 || !EventObject.class.isAssignableFrom(parameters[0])) {
            return;
        }
        if (!this.addEventToMethod(event)) {
            return;
        }
        String listenerTypeName = listenerType.getName();
        ListenerInfo lInfo = (ListenerInfo)this.usedListeners.get(listenerTypeName);
        if (lInfo == null) {
            lInfo = new ListenerInfo(listenerType);
            this.usedListeners.put(listenerTypeName, lInfo);
        } else {
            lInfo.listenerType = listenerType;
        }
        ++lInfo.useCount;
        event.setInCEDL(true);
    }

    private void unregisterEventFromCEDL(Event event) {
        if (this.removeEventFromMethod(event)) {
            String listenerTypeName = event.getEventSetDescriptor().getListenerType().getName();
            ListenerInfo lInfo = (ListenerInfo)this.usedListeners.get(listenerTypeName);
            if (lInfo != null && --lInfo.useCount == 0) {
                this.usedListeners.remove(listenerTypeName);
            }
            event.setInCEDL(false);
        }
    }

    private boolean addEventToMethod(Event event) {
        String methodName = FormEvents.fullMethodName(event.getListenerMethod());
        ArrayList<Event> eventList = (ArrayList<Event>)this.usedMethods.get(methodName);
        if (eventList == null) {
            eventList = new ArrayList<Event>();
            eventList.add(event);
            this.usedMethods.put(methodName, eventList);
        } else {
            for (Event e : eventList) {
                if (e.getComponent() != event.getComponent()) continue;
                return false;
            }
            eventList.add(event);
        }
        return true;
    }

    private boolean removeEventFromMethod(Event event) {
        boolean removed;
        String methodName = FormEvents.fullMethodName(event.getListenerMethod());
        List eventList = (List)this.usedMethods.get(methodName);
        if (eventList != null) {
            removed = eventList.remove(event);
            if (eventList.size() == 0) {
                this.usedMethods.remove(methodName);
            }
        } else {
            removed = false;
        }
        return removed;
    }

    private void detachEventHandler(Event event, String handlerName) {
        List handlerEventList = (List)this.eventHandlers.get(handlerName);
        handlerEventList.remove(event);
        if (handlerEventList.size() == 0) {
            this.eventHandlers.remove(handlerName);
        }
        this.formModel.fireEventHandlerRemoved(event, handlerName, handlerEventList.size() == 0);
    }

    private void checkCompatibility(Event event1, Event event2) {
        boolean ok;
        Class<?>[] params2;
        Method m1 = event1.getListenerMethod();
        Method m2 = event2.getListenerMethod();
        Class<?>[] params1 = m1.getParameterTypes();
        if (params1.length == (params2 = m2.getParameterTypes()).length) {
            ok = true;
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i].getName().equals(params2[i].getName())) continue;
                ok = false;
                break;
            }
            if (ok) {
                ok = m1.getReturnType().equals(m2.getReturnType());
            }
        } else {
            ok = false;
        }
        if (!ok) {
            IllegalArgumentException iae = new IllegalArgumentException("Incompatible event");
            ErrorManager.getDefault().annotate((Throwable)iae, FormUtils.getBundleString("MSG_CannotAttach"));
            throw iae;
        }
    }

    private static String fullMethodName(Method m) {
        StringBuffer name = new StringBuffer();
        name.append(m.getName());
        name.append("(");
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            name.append(params[i].getName());
            if (i + 1 >= params.length) continue;
            name.append(", ");
        }
        name.append(")");
        return name.toString();
    }

    private static class ListenerInfo {
        Class listenerType;
        int useCount;

        ListenerInfo(Class listenerType) {
            this.listenerType = listenerType;
        }
    }
}

