/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.HashMap;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.ErrorManager;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

class FormLAF {
    private static Map lafDefaults;
    private static Map ideDefaults;
    private static int useIdeLaf;
    private static boolean lafBlockEntered;

    private FormLAF() {
    }

    static Object executeWithLookAndFeel(final Mutex.ExceptionAction act) throws Exception {
        try {
            if (FormLAF.checkUseIdeLaf()) {
                return Mutex.EVENT.readAccess(act);
            }
            return Mutex.EVENT.readAccess(new Mutex.ExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    UIDefaults uIDefaults = UIManager.getDefaults();
                    synchronized (uIDefaults) {
                        Object object;
                        block9: {
                            boolean restoreAfter = true;
                            try {
                                if (lafBlockEntered) {
                                    restoreAfter = false;
                                } else {
                                    lafBlockEntered = true;
                                    FormLAF.useDefaultLookAndFeel();
                                    restoreAfter = true;
                                }
                                object = act.run();
                                if (!restoreAfter) break block9;
                            }
                            catch (Throwable throwable) {
                                if (restoreAfter) {
                                    FormLAF.useIDELookAndFeel();
                                    lafBlockEntered = false;
                                }
                                throw throwable;
                            }
                            FormLAF.useIDELookAndFeel();
                            lafBlockEntered = false;
                        }
                        return object;
                    }
                }
            });
        }
        catch (MutexException ex) {
            throw ex.getException();
        }
    }

    static void executeWithLookAndFeel(final Runnable run) {
        Mutex.EVENT.readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                if (FormLAF.checkUseIdeLaf()) {
                    run.run();
                } else {
                    UIDefaults uIDefaults = UIManager.getDefaults();
                    synchronized (uIDefaults) {
                        boolean restoreAfter = true;
                        try {
                            if (lafBlockEntered) {
                                restoreAfter = false;
                            } else {
                                lafBlockEntered = true;
                                FormLAF.useDefaultLookAndFeel();
                                restoreAfter = true;
                            }
                            run.run();
                        }
                        finally {
                            if (restoreAfter) {
                                FormLAF.useIDELookAndFeel();
                                lafBlockEntered = false;
                            }
                        }
                    }
                }
                return null;
            }
        });
    }

    private static boolean checkUseIdeLaf() {
        if (useIdeLaf == -1) {
            useIdeLaf = System.getProperty("netbeans.form.use_idelaf") != null ? 1 : 0;
        }
        return useIdeLaf > 0;
    }

    private static void useDefaultLookAndFeel() {
        if (lafDefaults == null) {
            try {
                String lafName = UIManager.getLookAndFeel().getClass().getName();
                LookAndFeel defaultLookAndFeel = (LookAndFeel)Class.forName(lafName).newInstance();
                defaultLookAndFeel.initialize();
                lafDefaults = defaultLookAndFeel.getDefaults();
                Object[] keys = lafDefaults.keySet().toArray();
                for (int i = 0; i < keys.length; ++i) {
                    if (keys[i] instanceof String && ((String)keys[i]).indexOf("Icon") != -1) continue;
                    lafDefaults.get(keys[i]);
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return;
            }
            catch (LinkageError ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return;
            }
        }
        if (ideDefaults == null) {
            FormLAF.saveIDELookAndFeelDefaults();
        }
        UIManager.put("ClassLoader", null);
        FormLAF.copyMap(UIManager.getDefaults(), lafDefaults);
    }

    private static void useIDELookAndFeel() {
        if (ideDefaults != null) {
            FormLAF.copyMap(UIManager.getDefaults(), ideDefaults);
        }
    }

    private static void saveIDELookAndFeelDefaults() {
        if (FormLAF.checkUseIdeLaf()) {
            return;
        }
        if (ideDefaults != null) {
            return;
        }
        UIDefaults defaults = UIManager.getDefaults();
        UIDefaults lafDefaults = UIManager.getLookAndFeelDefaults();
        ideDefaults = new HashMap(defaults.size() + lafDefaults.size());
        FormLAF.copyMap(ideDefaults, lafDefaults);
        FormLAF.copyMap(ideDefaults, defaults);
    }

    private static void copyMap(Map dest, Map src) {
        dest.putAll(src);
    }

    static {
        useIdeLaf = -1;
    }
}

