/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormSettings;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADFormContainer;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.RADVisualFormContainer;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportDelegate;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.openide.awt.UndoRedo;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class FormModel {
    private String formName;
    private boolean readOnly = false;
    private Class formBaseClass;
    private RADComponent topRADComponent;
    private ArrayList otherComponents = new ArrayList(10);
    private ComponentContainer modelContainer;
    private LayoutModel layoutModel;
    private Map idToComponents = new HashMap();
    private UndoRedo.Manager undoRedoManager;
    private boolean undoRedoRecording = false;
    private CompoundEdit compoundEdit;
    private boolean autoEndCoumpoundEdit;
    private boolean undoCompoundEdit = false;
    private FormEvents formEvents;
    private ArrayList listeners;
    private EventBroker eventBroker;
    private MetaComponentCreator metaCreator;
    private CodeStructure codeStructure = new CodeStructure(false);
    private FormSettings settings = new FormSettings(this);
    private boolean freeDesignDefaultLayout = false;
    private static int traceCount = 0;
    private static final boolean TRACE = false;

    FormModel() {
    }

    public void setFormBaseClass(Class formClass) throws Exception {
        if (this.formBaseClass != null) {
            throw new IllegalStateException("Form type already initialized.");
        }
        RADComponent topComp = Component.class.isAssignableFrom(formClass) ? (FormUtils.isContainer(formClass) ? new RADVisualFormContainer() : new RADVisualComponent(){

            public String getName() {
                return FormUtils.getBundleString("CTL_FormTopContainerName");
            }

            public void setName(String value) {
            }
        }) : (Object.class != formClass ? new RADFormContainer() : null);
        if (topComp != null) {
            this.topRADComponent = topComp;
            topComp.initialize(this);
            topComp.initInstance(formClass);
            topComp.setInModel(true);
        }
        this.formBaseClass = formClass;
        this.layoutModel = new LayoutModel();
        this.layoutModel.setChangeRecording(false);
    }

    public Class getFormBaseClass() {
        return this.formBaseClass;
    }

    void setName(String name) {
        this.formName = name;
    }

    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public final String getName() {
        return this.formName;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean wasCorrected() {
        return this.layoutModel != null && this.layoutModel.wasCorrected();
    }

    public final RADComponent getTopRADComponent() {
        return this.topRADComponent;
    }

    public ComponentContainer getModelContainer() {
        if (this.modelContainer == null) {
            this.modelContainer = new ModelContainer();
        }
        return this.modelContainer;
    }

    public final LayoutModel getLayoutModel() {
        return this.layoutModel;
    }

    public final RADComponent getMetaComponent(String id) {
        return (RADComponent)this.idToComponents.get(id);
    }

    public RADComponent findRADComponent(String name) {
        for (RADComponent comp : this.idToComponents.values()) {
            if (!name.equals(comp.getName())) continue;
            return comp;
        }
        return null;
    }

    public List getMetaComponents() {
        return new ArrayList(this.idToComponents.values());
    }

    public RADVisualComponent[] getVisualComponents() {
        ArrayList<RADComponent> list = new ArrayList<RADComponent>();
        if (this.topRADComponent instanceof RADVisualComponent) {
            list.add(this.topRADComponent);
        }
        if (this.topRADComponent instanceof RADVisualContainer) {
            FormModel.collectVisualMetaComponents((RADVisualContainer)this.topRADComponent, list);
        }
        return list.toArray(new RADVisualComponent[list.size()]);
    }

    public RADComponent[] getOtherComponents(boolean recursively) {
        ArrayList<RADComponent> list;
        if (recursively) {
            list = new ArrayList<RADComponent>();
            for (RADComponent comp : this.otherComponents) {
                list.add(comp);
                if (!recursively || !(comp instanceof ComponentContainer)) continue;
                FormModel.collectMetaComponents((ComponentContainer)((Object)comp), list);
            }
        } else {
            list = this.otherComponents;
        }
        return list.toArray(new RADComponent[list.size()]);
    }

    public FormEvents getFormEvents() {
        if (this.formEvents == null) {
            this.formEvents = new FormEvents(this);
        }
        return this.formEvents;
    }

    private static void collectMetaComponents(ComponentContainer cont, List list) {
        RADComponent[] comps = cont.getSubBeans();
        for (int i = 0; i < comps.length; ++i) {
            RADComponent comp = comps[i];
            list.add(comp);
            if (!(comp instanceof ComponentContainer)) continue;
            FormModel.collectMetaComponents((ComponentContainer)((Object)comp), list);
        }
    }

    private static void collectVisualMetaComponents(RADVisualContainer cont, List list) {
        RADVisualComponent[] comps = cont.getSubComponents();
        for (int i = 0; i < comps.length; ++i) {
            RADVisualComponent comp = comps[i];
            list.add(comp);
            if (!(comp instanceof RADVisualContainer)) continue;
            FormModel.collectVisualMetaComponents((RADVisualContainer)comp, list);
        }
    }

    public MetaComponentCreator getComponentCreator() {
        if (this.metaCreator == null) {
            this.metaCreator = new MetaComponentCreator(this);
        }
        return this.metaCreator;
    }

    public void addComponent(RADComponent metacomp, ComponentContainer parentContainer, boolean newlyAdded) {
        if (newlyAdded || !metacomp.isInModel()) {
            FormModel.setInModelRecursively(metacomp, true);
            newlyAdded = true;
        }
        if (parentContainer != null) {
            parentContainer.add(metacomp);
        } else {
            metacomp.setParentComponent(null);
            this.otherComponents.add(metacomp);
        }
        FormModelEvent ev = this.fireComponentAdded(metacomp, newlyAdded);
    }

    public void addVisualComponent(RADVisualComponent metacomp, RADVisualContainer parentContainer, Object constraints, boolean newlyAdded) {
        LayoutSupportManager layoutSupport = parentContainer.getLayoutSupport();
        if (layoutSupport != null) {
            int index;
            RADVisualComponent[] compArray = new RADVisualComponent[]{metacomp};
            LayoutConstraints c = constraints instanceof LayoutConstraints ? (LayoutConstraints)constraints : null;
            LayoutConstraints[] constrArray = new LayoutConstraints[]{c};
            int n = index = constraints instanceof Integer ? (Integer)constraints : -1;
            if (newlyAdded || !metacomp.isInModel()) {
                FormModel.setInModelRecursively(metacomp, true);
                newlyAdded = true;
            }
            try {
                layoutSupport.acceptNewComponents(compArray, constrArray, index);
            }
            catch (RuntimeException ex) {
                if (newlyAdded) {
                    FormModel.setInModelRecursively(metacomp, false);
                }
                throw ex;
            }
            parentContainer.add(metacomp, index);
            layoutSupport.addComponents(compArray, constrArray, index);
            FormModelEvent ev = this.fireComponentAdded(metacomp, newlyAdded);
        } else {
            this.addComponent(metacomp, parentContainer, newlyAdded);
        }
    }

    public void setContainerLayoutImpl(RADVisualContainer metacont, LayoutSupportDelegate layoutDelegate, LayoutManager initInstance) throws Exception {
        LayoutSupportDelegate currentDel;
        LayoutSupportManager currentLS = metacont.getLayoutSupport();
        LayoutSupportDelegate layoutSupportDelegate = currentDel = currentLS != null ? currentLS.getLayoutDelegate() : null;
        if (currentLS == null) {
            metacont.setOldLayoutSupport(true);
        }
        metacont.setLayoutSupportDelegate(layoutDelegate, initInstance);
        this.fireContainerLayoutExchanged(metacont, currentDel, layoutDelegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainerLayout(RADVisualContainer metacont, LayoutSupportDelegate layoutDelegate, LayoutManager initInstance) throws Exception {
        LayoutSupportManager currentLS = metacont.getLayoutSupport();
        this.setContainerLayoutImpl(metacont, layoutDelegate, initInstance);
        if (currentLS == null) {
            Object layoutStartMark = this.layoutModel.getChangeMark();
            UndoableEdit ue = this.layoutModel.getUndoableEdit();
            boolean autoUndo = true;
            try {
                this.layoutModel.changeContainerToComponent(metacont.getId());
                autoUndo = false;
            }
            finally {
                if (layoutStartMark != null && !layoutStartMark.equals(this.layoutModel.getChangeMark())) {
                    this.addUndoableEdit(ue);
                }
                if (autoUndo) {
                    this.forceUndoOfCompoundEdit();
                }
            }
        }
    }

    void setNaturalContainerLayoutImpl(RADVisualContainer metacont) {
        LayoutSupportManager currentLS = metacont.getLayoutSupport();
        LayoutSupportDelegate currentDel = currentLS.getLayoutDelegate();
        metacont.setOldLayoutSupport(false);
        this.fireContainerLayoutExchanged(metacont, currentDel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNaturalContainerLayout(RADVisualContainer metacont) {
        LayoutSupportManager currentLS = metacont.getLayoutSupport();
        if (currentLS == null) {
            return;
        }
        this.setNaturalContainerLayoutImpl(metacont);
        Object layoutStartMark = this.layoutModel.getChangeMark();
        UndoableEdit ue = this.layoutModel.getUndoableEdit();
        boolean autoUndo = true;
        try {
            if (!this.layoutModel.changeComponentToContainer(metacont.getId())) {
                this.layoutModel.addRootComponent(new LayoutComponent(metacont.getId(), true));
            }
            autoUndo = false;
        }
        finally {
            if (layoutStartMark != null && !layoutStartMark.equals(this.layoutModel.getChangeMark())) {
                this.addUndoableEdit(ue);
            }
            if (autoUndo) {
                this.forceUndoOfCompoundEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeComponent(RADComponent metacomp, boolean fromModel) {
        Object layoutStartMark = null;
        UndoableEdit ue = null;
        boolean autoUndo = true;
        try {
            if (fromModel && this.layoutModel != null) {
                layoutStartMark = this.layoutModel.getChangeMark();
                ue = this.layoutModel.getUndoableEdit();
                this.layoutModel.removeComponent(metacomp.getId(), true);
                this.removeLayoutComponentsRecursively(metacomp);
            }
            autoUndo = false;
        }
        finally {
            this.removeComponentImpl(metacomp, fromModel);
            if (layoutStartMark != null && !layoutStartMark.equals(this.layoutModel.getChangeMark())) {
                this.addUndoableEdit(ue);
            }
            if (autoUndo) {
                this.forceUndoOfCompoundEdit();
            }
        }
    }

    void removeComponentImpl(RADComponent metacomp, boolean fromModel) {
        RADComponent parent;
        if (fromModel && this.formEvents != null) {
            this.removeEventHandlersRecursively(metacomp);
        }
        ComponentContainer parentContainer = (parent = metacomp.getParentComponent()) instanceof ComponentContainer ? (ComponentContainer)((Object)parent) : this.getModelContainer();
        int index = parentContainer.getIndexOf(metacomp);
        parentContainer.remove(metacomp);
        if (fromModel) {
            FormModel.setInModelRecursively(metacomp, false);
        }
        FormModelEvent ev = this.fireComponentRemoved(metacomp, parentContainer, index, fromModel);
    }

    private void removeLayoutComponentsRecursively(RADComponent metacomp) {
        LayoutComponent layoutComp;
        if (metacomp instanceof ComponentContainer) {
            RADComponent[] comps = ((ComponentContainer)((Object)metacomp)).getSubBeans();
            for (int i = 0; i < comps.length; ++i) {
                this.removeLayoutComponentsRecursively(comps[i]);
            }
        }
        LayoutComponent layoutComponent = layoutComp = this.layoutModel == null ? null : this.layoutModel.getLayoutComponent(metacomp.getId());
        if (layoutComp != null && layoutComp.getParent() == null) {
            this.layoutModel.removeComponent(layoutComp.getId(), true);
        }
    }

    void updateMapping(RADComponent metacomp, boolean register) {
        if (register) {
            this.idToComponents.put(metacomp.getId(), metacomp);
        } else {
            this.idToComponents.remove(metacomp.getId());
        }
    }

    private void removeEventHandlersRecursively(RADComponent comp) {
        int i;
        if (comp instanceof ComponentContainer) {
            RADComponent[] subcomps = ((ComponentContainer)((Object)comp)).getSubBeans();
            for (i = 0; i < subcomps.length; ++i) {
                this.removeEventHandlersRecursively(subcomps[i]);
            }
        }
        Event[] events = comp.getKnownEvents();
        for (i = 0; i < events.length; ++i) {
            if (!events[i].hasEventHandlers()) continue;
            this.getFormEvents().detachEvent(events[i]);
        }
    }

    static void setInModelRecursively(RADComponent metacomp, boolean inModel) {
        if (metacomp instanceof ComponentContainer) {
            RADComponent[] comps = ((ComponentContainer)((Object)metacomp)).getSubBeans();
            for (int i = 0; i < comps.length; ++i) {
                FormModel.setInModelRecursively(comps[i], inModel);
            }
        }
        metacomp.setInModel(inModel);
    }

    public void setUndoRedoRecording(boolean record) {
        FormModel.t("turning undo/redo recording " + (record ? "on" : "off"));
        this.undoRedoRecording = record;
    }

    public boolean isUndoRedoRecording() {
        return this.undoRedoRecording;
    }

    public boolean startCompoundEdit(boolean endAutomatically) {
        if (this.compoundEdit == null) {
            FormModel.t("starting compound edit");
            this.compoundEdit = new CompoundEdit();
            this.autoEndCoumpoundEdit = endAutomatically;
            return true;
        }
        return false;
    }

    public CompoundEdit endCompoundEdit(boolean commit) {
        if (this.compoundEdit != null) {
            FormModel.t("ending compound edit: " + commit);
            this.compoundEdit.end();
            this.autoEndCoumpoundEdit = false;
            if (commit && this.undoRedoRecording && this.compoundEdit.isSignificant()) {
                this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, this.compoundEdit));
            } else {
                this.undoCompoundEdit = false;
            }
            CompoundEdit edit = this.compoundEdit;
            this.compoundEdit = null;
            return edit;
        }
        return null;
    }

    public void forceUndoOfCompoundEdit() {
        if (this.compoundEdit != null) {
            this.undoCompoundEdit = true;
        }
    }

    public boolean isCompoundEditInProgress() {
        return this.compoundEdit != null && this.compoundEdit.isInProgress();
    }

    public void addUndoableEdit(UndoableEdit edit) {
        FormModel.t("adding undoable edit");
        if (this.isCompoundEditInProgress()) {
            this.compoundEdit.addEdit(edit);
        } else {
            this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent(this, edit));
        }
    }

    UndoRedo.Manager getUndoRedoManager() {
        return this.undoRedoManager;
    }

    public synchronized void addFormModelListener(FormModelListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public synchronized void removeFormModelListener(FormModelListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void fireFormLoaded() {
        FormModel.t("firing form loaded");
        this.eventBroker = new EventBroker();
        if (!this.readOnly && !Boolean.getBoolean("netbeans.form.no_undo")) {
            this.undoRedoManager = new UndoRedoManager();
            this.undoRedoManager.setLimit(50);
            this.setUndoRedoRecording(true);
            if (this.layoutModel != null) {
                this.layoutModel.setChangeRecording(true);
            }
        }
        this.sendEventLater(new FormModelEvent(this, 1));
    }

    public void fireFormToBeSaved() {
        FormModel.t("firing form to be saved");
        this.sendEventImmediately(new FormModelEvent(this, 2));
    }

    public void fireFormToBeClosed() {
        FormModel.t("firing form to be closed");
        if (this.undoRedoManager != null) {
            this.undoRedoManager.discardAllEdits();
        }
        this.sendEventImmediately(new FormModelEvent(this, 3));
    }

    public FormModelEvent fireContainerLayoutExchanged(RADVisualContainer metacont, LayoutSupportDelegate oldLayout, LayoutSupportDelegate newLayout) {
        FormModel.t("firing container layout exchange, container: " + (metacont != null ? metacont.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 4);
        ev.setLayout(metacont, oldLayout, newLayout);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacont != null && oldLayout != newLayout) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireContainerLayoutChanged(RADVisualContainer metacont, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing container layout change, container: " + (metacont != null ? metacont.getName() : "null") + ", property: " + propName);
        FormModelEvent ev = new FormModelEvent(this, 5);
        ev.setComponentAndContainer(metacont, metacont);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacont != null && (propName == null || oldValue != newValue)) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentLayoutChanged(RADVisualComponent metacomp, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing component layout change: " + (metacomp != null ? metacomp.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 6);
        ev.setComponentAndContainer(metacomp, null);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null && propName != null && oldValue != newValue) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentAdded(RADComponent metacomp, boolean addedNew) {
        FormModel.t("firing component added: " + (metacomp != null ? metacomp.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 7);
        ev.setAddData(metacomp, null, addedNew);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentRemoved(RADComponent metacomp, ComponentContainer metacont, int index, boolean removedFromModel) {
        FormModel.t("firing component removed: " + (metacomp != null ? metacomp.getName() : "null"));
        FormModelEvent ev = new FormModelEvent(this, 8);
        ev.setRemoveData(metacomp, metacont, index, removedFromModel);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null && metacont != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentsReordered(ComponentContainer metacont, int[] perm) {
        FormModel.t("firing components reorder in container: " + (metacont instanceof RADComponent ? ((RADComponent)((Object)metacont)).getName() : "<top>"));
        FormModelEvent ev = new FormModelEvent(this, 9);
        ev.setComponentAndContainer(null, metacont);
        ev.setReordering(perm);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacont != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireComponentPropertyChanged(RADComponent metacomp, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing component property change, component: " + (metacomp != null ? metacomp.getName() : "<null component>") + ", property: " + propName);
        FormModelEvent ev = new FormModelEvent(this, 10);
        ev.setComponentAndContainer(metacomp, null);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && metacomp != null && propName != null && oldValue != newValue) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireSyntheticPropertyChanged(RADComponent metacomp, String propName, Object oldValue, Object newValue) {
        FormModel.t("firing synthetic property change, component: " + (metacomp != null ? metacomp.getName() : "null") + ", property: " + propName);
        FormModelEvent ev = new FormModelEvent(this, 11);
        ev.setComponentAndContainer(metacomp, null);
        ev.setProperty(propName, oldValue, newValue);
        this.sendEvent(ev);
        if (this.undoRedoRecording && propName != null && oldValue != newValue) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireEventHandlerAdded(Event event, String handler, String bodyText, boolean createdNew) {
        FormModel.t("event handler added: " + handler);
        FormModelEvent ev = new FormModelEvent(this, 12);
        ev.setEvent(event, handler, bodyText, createdNew);
        this.sendEvent(ev);
        if (this.undoRedoRecording && event != null && handler != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireEventHandlerRemoved(Event event, String handler, boolean handlerDeleted) {
        FormModel.t("firing event handler removed: " + handler);
        FormModelEvent ev = new FormModelEvent(this, 13);
        ev.setEvent(event, handler, null, handlerDeleted);
        this.sendEvent(ev);
        if (this.undoRedoRecording && event != null && handler != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireEventHandlerRenamed(String oldHandlerName, String newHandlerName) {
        FormModel.t("event handler renamed: " + oldHandlerName + " to " + newHandlerName);
        FormModelEvent ev = new FormModelEvent(this, 14);
        ev.setEvent(oldHandlerName, newHandlerName);
        this.sendEvent(ev);
        if (this.undoRedoRecording && oldHandlerName != null && newHandlerName != null) {
            this.addUndoableEdit(ev.getUndoableEdit());
        }
        return ev;
    }

    public FormModelEvent fireFormChanged(boolean immediately) {
        FormModel.t("firing form change");
        FormModelEvent ev = new FormModelEvent(this, 15);
        if (immediately) {
            this.sendEventImmediately(ev);
        } else {
            this.sendEvent(ev);
        }
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvents(FormModelEvent[] events) {
        ArrayList targets;
        FormModel formModel = this;
        synchronized (formModel) {
            if (this.listeners == null) {
                return;
            }
            targets = (ArrayList)this.listeners.clone();
        }
        for (int i = 0; i < targets.size(); ++i) {
            FormModelListener l = (FormModelListener)targets.get(i);
            l.formChanged(events);
        }
    }

    void sendEvent(FormModelEvent ev) {
        EventBroker broker = this.getEventBroker();
        if (broker != null) {
            broker.sendEvent(ev);
        } else {
            FormModel.t("no event broker, firing event directly: " + ev.getChangeType());
            this.fireEvents(new FormModelEvent[]{ev});
        }
    }

    void sendEventLater(FormModelEvent ev) {
        EventBroker broker = this.getEventBroker();
        if (broker != null) {
            broker.sendEventLater(ev);
        } else {
            FormModel.t("no event broker, firing event directly: " + ev.getChangeType());
            this.fireEvents(new FormModelEvent[]{ev});
        }
    }

    void sendEventImmediately(FormModelEvent ev) {
        this.fireEvents(new FormModelEvent[]{ev});
    }

    EventBroker getEventBroker() {
        return this.eventBroker;
    }

    public FormSettings getSettings() {
        return this.settings;
    }

    CodeStructure getCodeStructure() {
        return this.codeStructure;
    }

    public boolean isFreeDesignDefaultLayout() {
        return this.freeDesignDefaultLayout;
    }

    void setFreeDesignDefaultLayout(boolean freeDesignDefaultLayout) {
        this.freeDesignDefaultLayout = freeDesignDefaultLayout;
    }

    static void t(String str) {
    }

    final class ModelContainer
    implements ComponentContainer {
        ModelContainer() {
        }

        public RADComponent[] getSubBeans() {
            int n = FormModel.this.otherComponents.size();
            if (FormModel.this.topRADComponent != null) {
                ++n;
            }
            RADComponent[] comps = new RADComponent[n];
            FormModel.this.otherComponents.toArray(comps);
            if (FormModel.this.topRADComponent != null) {
                comps[n - 1] = FormModel.this.topRADComponent;
            }
            return comps;
        }

        public void initSubComponents(RADComponent[] initComponents) {
            FormModel.this.otherComponents.clear();
            for (int i = 0; i < initComponents.length; ++i) {
                if (initComponents[i] == FormModel.this.topRADComponent) continue;
                FormModel.this.otherComponents.add(initComponents[i]);
            }
        }

        public void reorderSubComponents(int[] perm) {
            RADComponent[] components = new RADComponent[FormModel.this.otherComponents.size()];
            for (int i = 0; i < perm.length; ++i) {
                components[perm[i]] = (RADComponent)FormModel.this.otherComponents.get(i);
            }
            FormModel.this.otherComponents.clear();
            FormModel.this.otherComponents.addAll(Arrays.asList(components));
        }

        public void add(RADComponent comp) {
            comp.setParentComponent(null);
            FormModel.this.otherComponents.add(comp);
        }

        public void remove(RADComponent comp) {
            if (FormModel.this.otherComponents.remove(comp)) {
                comp.setParentComponent(null);
            }
        }

        public int getIndexOf(RADComponent comp) {
            int index = FormModel.this.otherComponents.indexOf(comp);
            if (index < 0 && comp == FormModel.this.topRADComponent) {
                index = FormModel.this.otherComponents.size();
            }
            return index;
        }
    }

    private class EventBroker
    implements Runnable {
        private List eventList;

        private EventBroker() {
        }

        public void sendEvent(FormModelEvent ev) {
            if (this.shouldSendLater(ev)) {
                this.sendEventLater(ev);
            } else {
                this.sendEventImmediately(ev);
            }
        }

        public void sendEventImmediately(FormModelEvent ev) {
            FormModel.t("firing event directly from event broker: " + ev.getChangeType());
            FormModel.this.fireEvents(new FormModelEvent[]{ev});
        }

        public void sendEventLater(FormModelEvent ev) {
            if (!EventQueue.isDispatchThread()) {
                this.sendEventImmediately(ev);
                return;
            }
            if (this.eventList == null) {
                this.eventList = new ArrayList();
                if (ev.isModifying() && FormModel.this.isUndoRedoRecording() && FormModel.this.startCompoundEdit(true)) {
                    FormModel.t("compound undoable edit started from event broker");
                }
                EventQueue.invokeLater(this);
            }
            this.eventList.add(ev);
            FormModel.t("event " + ev.getChangeType() + " added to queue in event broker");
        }

        private boolean shouldSendLater(FormModelEvent ev) {
            return this.eventList != null || ev.isModifying();
        }

        private List pickUpEvents() {
            List list = this.eventList;
            this.eventList = null;
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = this.pickUpEvents();
            boolean firedSuccessfully = false;
            try {
                if (list != null && !list.isEmpty()) {
                    FormModelEvent[] events = new FormModelEvent[list.size()];
                    list.toArray(events);
                    FormModel.t("firing event batch of " + list.size() + " events from event broker");
                    FormModel.this.fireEvents(events);
                }
                firedSuccessfully = true;
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (FormModel.this.autoEndCoumpoundEdit) {
                    CompoundEdit edit = FormModel.this.endCompoundEdit(true);
                    if (edit != null) {
                        FormModel.t("coumpound undoable edit ended automatically");
                        if ((FormModel.this.undoCompoundEdit || !firedSuccessfully) && FormModel.this.getUndoRedoManager().canUndo()) {
                            FormModel.this.undoCompoundEdit = false;
                            FormModel.this.getUndoRedoManager().undo();
                        }
                    }
                    FormModel.this.undoCompoundEdit = false;
                }
                throw throwable;
            }
            if (FormModel.this.autoEndCoumpoundEdit) {
                CompoundEdit edit = FormModel.this.endCompoundEdit(true);
                if (edit != null) {
                    FormModel.t("coumpound undoable edit ended automatically");
                    if ((FormModel.this.undoCompoundEdit || !firedSuccessfully) && FormModel.this.getUndoRedoManager().canUndo()) {
                        FormModel.this.undoCompoundEdit = false;
                        FormModel.this.getUndoRedoManager().undo();
                    }
                }
                FormModel.this.undoCompoundEdit = false;
            }
        }
    }

    class UndoRedoManager
    extends UndoRedo.Manager {
        private Mutex.ExceptionAction runUndo = new Mutex.ExceptionAction(){

            public Object run() throws Exception {
                UndoRedoManager.this.superUndo();
                return null;
            }
        };
        private Mutex.ExceptionAction runRedo = new Mutex.ExceptionAction(){

            public Object run() throws Exception {
                UndoRedoManager.this.superRedo();
                return null;
            }
        };

        UndoRedoManager() {
        }

        public void superUndo() throws CannotUndoException {
            super.undo();
        }

        public void superRedo() throws CannotRedoException {
            super.redo();
        }

        public void undo() throws CannotUndoException {
            if (EventQueue.isDispatchThread()) {
                this.superUndo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runUndo);
                }
                catch (MutexException ex) {
                    Exception e = ex.getException();
                    if (e instanceof CannotUndoException) {
                        throw (CannotUndoException)e;
                    }
                    e.printStackTrace();
                }
            }
        }

        public void redo() throws CannotRedoException {
            if (EventQueue.isDispatchThread()) {
                this.superRedo();
            } else {
                try {
                    Mutex.EVENT.readAccess(this.runRedo);
                }
                catch (MutexException ex) {
                    Exception e = ex.getException();
                    if (e instanceof CannotRedoException) {
                        throw (CannotRedoException)e;
                    }
                    e.printStackTrace();
                }
            }
        }
    }
}

