/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.form.FormUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class PersistenceObjectRegistry {
    private static Map _nameToClassname = new HashMap();
    private static Map _classToPrimaryName = new HashMap();

    private PersistenceObjectRegistry() {
    }

    public static void registerPrimaryName(String classname, String name) {
        _classToPrimaryName.put(classname, name);
        _nameToClassname.put(name, classname);
    }

    public static void registerPrimaryName(Class clazz, String name) {
        _classToPrimaryName.put(clazz.getName(), name);
        _nameToClassname.put(name, clazz.getName());
    }

    public static void registerAlias(String classname, String alias) {
        _nameToClassname.put(alias, classname);
    }

    public static void registerAlias(Class clazz, String alias) {
        _nameToClassname.put(alias, clazz.getName());
    }

    public static Object createInstance(String classname, FileObject form) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return PersistenceObjectRegistry.loadClass(classname, form).newInstance();
    }

    public static Class loadClass(String name, FileObject form) throws ClassNotFoundException {
        String classname = (String)_nameToClassname.get(name = Utilities.translate((String)name));
        if (classname == null) {
            classname = name;
        }
        return FormUtils.loadClass(classname, form);
    }

    public static String getPrimaryName(Object instance) {
        return PersistenceObjectRegistry.getPrimaryName(instance.getClass());
    }

    public static String getPrimaryName(Class clazz) {
        return PersistenceObjectRegistry.getPrimaryName(clazz.getName());
    }

    static String getPrimaryName(String className) {
        String name = (String)_classToPrimaryName.get(className);
        return name != null ? name : className;
    }

    static String getClassName(String primaryName) {
        String classname = (String)_nameToClassname.get(primaryName = Utilities.translate((String)primaryName));
        return classname != null ? classname : primaryName;
    }
}

