/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Rectangle;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;

public class LayoutTestUtils
implements LayoutConstants {
    static void writeString(List codeList, String name, String value) {
        if (value != null) {
            codeList.add("String " + name + "= \"" + value + "\";");
        } else {
            codeList.add("String " + name + " = null;");
        }
    }

    static void writeLayoutComponentArray(List codeList, String arrayName, String lcName) {
        codeList.add("LayoutComponent[] " + arrayName + " = new LayoutComponent[] { " + lcName + " };");
    }

    static void writeCollection(List codeList, String name, Collection c) {
        codeList.add("Collection " + name + " = new ArrayList();");
        Iterator i = c.iterator();
        while (i.hasNext()) {
            codeList.add(name + ".add(\"" + (String)i.next() + "\");");
        }
    }

    static void writeStringArray(List codeList, String name, String[] compIds) {
        codeList.add("String[] " + name + " = new String[] {");
        for (int i = 0; i < compIds.length; ++i) {
            codeList.add("\"" + compIds[i] + "\"" + (i + 1 < compIds.length ? "," : ""));
        }
        codeList.add("};");
    }

    static void writeIntArray(List codeList, String name, int[] values) {
        codeList.add("int[] " + name + " = new int[] {");
        for (int i = 0; i < values.length; ++i) {
            codeList.add(Integer.toString(values[i]) + (i + 1 < values.length ? "," : ""));
        }
        codeList.add("};");
    }

    static void writeRectangleArray(List codeList, String name, Rectangle[] bounds) {
        codeList.add("Rectangle[] " + name + " = new Rectangle[] {");
        for (int i = 0; i < bounds.length; ++i) {
            codeList.add("new Rectangle(" + bounds[i].x + ", " + bounds[i].y + ", " + bounds[i].width + ", " + bounds[i].height + (i + 1 < bounds.length ? "), " : ")"));
        }
        codeList.add("};");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dumpTestcode(List codeList, DataObject form, int modelCounter) {
        FileWriter fw = null;
        String template = "";
        if (form == null) {
            return;
        }
        try {
            FileObject primaryFile = form.getPrimaryFile();
            InputStream in = LayoutTestUtils.class.getResourceAsStream("/org/netbeans/modules/form/resources/LayoutModelAutoTest_template");
            LineNumberReader lReader = new LineNumberReader(new InputStreamReader(in));
            while (lReader.ready()) {
                template = template + lReader.readLine() + "\n";
            }
            lReader.close();
            String code = "";
            for (String line : codeList) {
                code = code + line + "\n";
            }
            Resource r = JavaModel.getResource((FileObject)primaryFile);
            Type type = JavaModel.getDefaultExtent().getType().resolve(r.getPackageName() + "." + primaryFile.getName());
            if (type instanceof UnresolvedClass) {
                return;
            }
            String testClassName = primaryFile.getName() + "Test";
            FileObject testFO = primaryFile.getParent().getFileObject(testClassName, "java");
            if (testFO == null) {
                testFO = primaryFile.getParent().createData(testClassName, "java");
                String output = Utilities.replaceString((String)template, (String)"${CLASS_NAME}", (String)testFO.getName());
                fw = new FileWriter(FileUtil.toFile((FileObject)testFO));
                fw.write(output);
                fw.close();
            }
            boolean rollback = true;
            JavaModel.getJavaRepository().beginTrans(true);
            try {
                JavaClass testClass = (JavaClass)LayoutTestUtils.resolveType("org.netbeans.modules.form.layoutdesign." + testFO.getName());
                if (!(testClass instanceof UnresolvedClass)) {
                    Method m = ((JavaModelPackage)testClass.refImmediatePackage()).getMethod().createMethod();
                    m.setName("doChanges" + modelCounter);
                    m.setBodyText(code);
                    m.setType(LayoutTestUtils.resolveType("void"));
                    m.setModifiers(1);
                    testClass.getContents().add(m);
                    rollback = false;
                }
            }
            finally {
                JavaModel.getJavaRepository().endTrans(rollback);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }

    private static Type resolveType(String typeName) {
        Type basicType;
        Type type = JavaModel.getDefaultExtent().getType().resolve(typeName);
        if (type instanceof UnresolvedClass && !((basicType = JavaModel.getDefaultExtent().getType().resolve("java.lang." + typeName)) instanceof UnresolvedClass)) {
            return basicType;
        }
        return type;
    }

    public static FileObject getTargetFolder(FileObject file) {
        FileObject targetFolder = file.getParent();
        try {
            FileObject folder = file.getParent().getParent().getParent().getParent().getParent().getParent().getParent().getFileObject("data/goldenfiles");
            if (folder != null) {
                targetFolder = folder;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return targetFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTest(FormDesigner fd, FormDataObject formDO, Map idToNameMap, LayoutModel lm) {
        FileObject formFO = formDO.getFormFile();
        fd.getLayoutDesigner().dumpTestcode((DataObject)formDO);
        OutputStreamWriter fw = null;
        try {
            FileObject targetFolder = LayoutTestUtils.getTargetFolder(formFO);
            FileObject fo = targetFolder.createData(formFO.getName() + "Test-ExpectedEndModel" + Integer.toString(fd.getLayoutDesigner().getModelCounter()), "txt");
            fw = new FileWriter(FileUtil.toFile((FileObject)fo));
            fw.write(lm.dump(idToNameMap));
            StatusDisplayer.getDefault().setStatusText("The test was successfully written: " + fo.getPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException io) {}
        }
    }
}

