/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.form.palette.AddToPaletteWizard;
import org.netbeans.modules.form.palette.CategorySelector;
import org.netbeans.modules.form.palette.PaletteItemDataObject;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public final class BeanInstaller {
    private static WeakReference wizardRef;
    private static final List NO_PARAMETERS;

    private BeanInstaller() {
    }

    public static void installBeans(String sourceType) {
        AddToPaletteWizard wizard = BeanInstaller.getAddWizard();
        if (wizard.show(sourceType)) {
            BeanInstaller.createPaletteItems(sourceType, wizard.getSelectedBeans(), wizard.getSelectedCategory());
        }
    }

    public static void installBeans(Node[] nodes) {
        final LinkedList beans = new LinkedList();
        final LinkedList unableToInstall = new LinkedList();
        for (int i = 0; i < nodes.length; ++i) {
            DataObject dobj = (DataObject)nodes[i].getCookie(DataObject.class);
            if (dobj == null) continue;
            final FileObject fo = dobj.getPrimaryFile();
            JavaClassHandler handler = new JavaClassHandler(){

                public void handle(JavaClass javaClass) {
                    ClassSource classSource = ClassPathUtils.getProjectClassSource(fo, javaClass.getName());
                    if (classSource == null) {
                        unableToInstall.add(javaClass.getName());
                    } else {
                        beans.add(classSource);
                    }
                }
            };
            BeanInstaller.scanFileObject(fo.getParent(), fo, handler);
        }
        if (unableToInstall.size() > 0) {
            Iterator iter = unableToInstall.iterator();
            StringBuffer sb = new StringBuffer();
            while (iter.hasNext()) {
                sb.append(iter.next() + ", ");
            }
            sb.delete(sb.length() - 2, sb.length());
            String messageFormat = PaletteUtils.getBundleString("MSG_cannotInstallBeans");
            String message = MessageFormat.format(messageFormat, sb.toString());
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (beans.size() == 0) {
                return;
            }
        }
        if (beans.size() == 0) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)PaletteUtils.getBundleString("MSG_noBeansUnderNodes"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        String category = CategorySelector.selectCategory();
        if (category == null) {
            return;
        }
        final FileObject categoryFolder = PaletteUtils.getPaletteFolder().getFileObject(category);
        try {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    for (ClassSource classSource : beans) {
                        try {
                            PaletteItemDataObject.createFile(categoryFolder, classSource);
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    static List findJavaBeansInJar(File[] jarFiles) {
        HashMap<String, ItemInfo> beans = null;
        for (int i = 0; i < jarFiles.length; ++i) {
            Manifest manifest;
            try {
                manifest = new JarFile(jarFiles[i]).getManifest();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                continue;
            }
            if (manifest == null) continue;
            String jarPath = jarFiles[i].getAbsolutePath();
            Map<String, Attributes> entries = manifest.getEntries();
            for (String key : entries.keySet()) {
                String value;
                if (!key.endsWith(".class") || !"True".equalsIgnoreCase(value = entries.get(key).getValue("Java-Bean"))) continue;
                String classname = key.substring(0, key.length() - 6).replace('\\', '/').replace('/', '.');
                if (classname.startsWith(".")) {
                    classname = classname.substring(1);
                }
                ItemInfo ii = new ItemInfo();
                ii.classname = classname;
                ii.source = jarPath;
                if (beans == null) {
                    beans = new HashMap<String, ItemInfo>(100);
                }
                beans.put(ii.classname, ii);
            }
        }
        return beans != null ? new ArrayList(beans.values()) : null;
    }

    static List findJavaBeans(File[] roots) {
        HashMap beans = new HashMap(100);
        for (int i = 0; i < roots.length; ++i) {
            FileObject foRoot = FileUtil.toFileObject((File)roots[i]);
            if (foRoot == null) continue;
            if (FileUtil.isArchiveFile((FileObject)foRoot)) {
                foRoot = FileUtil.getArchiveRoot((FileObject)foRoot);
            }
            if (foRoot == null || !foRoot.isFolder()) continue;
            BeanInstaller.scanFolderForBeans(foRoot, beans, roots[i].getAbsolutePath());
        }
        return new ArrayList(beans.values());
    }

    private static void createPaletteItems(final String sourceType, final ItemInfo[] beans, String category) {
        if (beans.length == 0) {
            return;
        }
        final FileObject categoryFolder = PaletteUtils.getPaletteFolder().getFileObject(category);
        if (categoryFolder == null) {
            return;
        }
        try {
            Repository.getDefault().getDefaultFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() {
                    String[] cpTypes = new String[]{sourceType};
                    for (int i = 0; i < beans.length; ++i) {
                        try {
                            PaletteItemDataObject.createFile(categoryFolder, new ClassSource(beans[i].classname, cpTypes, new String[]{beans[i].source}));
                            continue;
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private static void scanFolderForBeans(FileObject folder, final Map beans, final String root) {
        JavaClassHandler handler = new JavaClassHandler(){

            public void handle(JavaClass javaClass) {
                ItemInfo ii = new ItemInfo();
                ii.classname = javaClass.getName();
                ii.source = root;
                beans.put(ii.classname, ii);
            }
        };
        FileObject[] files = folder.getChildren();
        for (int i = 0; i < files.length; ++i) {
            FileObject fo = files[i];
            if (fo.isFolder()) {
                BeanInstaller.scanFolderForBeans(fo, beans, root);
                continue;
            }
            try {
                DataObject dobj;
                if (!"class".equals(fo.getExt()) || (dobj = DataObject.find((FileObject)fo)) == null) continue;
                BeanInstaller.scanFileObject(folder, fo, handler);
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanFileObject(FileObject folder, FileObject fileObject, JavaClassHandler handler) {
        JavaModel.getJavaRepository().beginTrans(false);
        JavaModel.setClassPath((FileObject)fileObject);
        try {
            Resource resource = JavaModel.getResource((FileObject)folder, (String)fileObject.getNameExt());
            List classifiers = resource.getClassifiers();
            for (Object classifier : classifiers) {
                JavaClass javaClass;
                if (!(classifier instanceof JavaClass) || !(javaClass = (JavaClass)classifier).getSimpleName().equals(fileObject.getName()) || !BeanInstaller.isDeclaredAsJavaBean(javaClass)) continue;
                handler.handle(javaClass);
                break;
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    private static boolean isDeclaredAsJavaBean(JavaClass jc) {
        int modifiers = jc.getModifiers();
        if (Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers)) {
            Constructor constructor = jc.getConstructor(NO_PARAMETERS, false);
            return constructor != null && Modifier.isPublic(constructor.getModifiers());
        }
        return false;
    }

    private static AddToPaletteWizard getAddWizard() {
        AddToPaletteWizard wizard = null;
        if (wizardRef != null) {
            wizard = (AddToPaletteWizard)((Object)wizardRef.get());
        }
        if (wizard == null) {
            wizard = new AddToPaletteWizard();
            wizardRef = new WeakReference<AddToPaletteWizard>(wizard);
        }
        return wizard;
    }

    static {
        NO_PARAMETERS = new ArrayList();
    }

    private static interface JavaClassHandler {
        public void handle(JavaClass var1);
    }

    static class ItemInfo
    implements Comparable {
        String classname;
        String source;

        ItemInfo() {
        }

        public int compareTo(Object o) {
            ItemInfo ii = (ItemInfo)o;
            int i = this.classname.lastIndexOf(46);
            String name1 = i >= 0 ? this.classname.substring(i + 1) : this.classname;
            i = ii.classname.lastIndexOf(46);
            String name2 = i >= 0 ? ii.classname.substring(i + 1) : ii.classname;
            return name1.compareTo(name2);
        }
    }
}

