/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.project.ClassSource;
import org.netbeans.modules.form.project.FormClassLoader;
import org.netbeans.modules.form.project.ProjectClassLoader;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClassPathUtils {
    private static Map loaders = new WeakHashMap();
    static final int UNSPECIFIED_CLASS = 0;
    static final int SYSTEM_CLASS = 1;
    static final int SYSTEM_CLASS_WITH_PROJECT = 2;
    private static FileObject patternSystemFolder;
    private static FileObject patternSystemWithProjectFolder;
    private static List patternsSystem;
    private static List patternsSystemWithProject;
    private static final String CL_LAYER_BASE = "org-netbeans-modules-form/classloader/";
    private static final String CL_SYSTEM_CLASS = "system";
    private static final String CL_SYSTEM_CLASS_WITH_PROJECT = "system_with_project";

    public static Class loadClass(String name, FileObject fileInProject) throws ClassNotFoundException {
        return Class.forName(name, true, ClassPathUtils.getFormClassLoader(fileInProject));
    }

    public static boolean checkUserClass(String name, FileObject fileInProject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/execute");
        if (classPath == null) {
            return false;
        }
        String fileName = name.replace('.', '/').concat(".class");
        return classPath.findResource(fileName) != null;
    }

    private static FormClassLoader getFormClassLoader(FileObject fileInProject) {
        Project p = FileOwnerQuery.getOwner((FileObject)fileInProject);
        FormClassLoader fcl = (FormClassLoader)loaders.get(p);
        ClassLoader existingProjectCL = fcl != null ? fcl.getProjectClassLoader() : null;
        ClassLoader newProjectCL = ProjectClassLoader.getUpToDateClassLoader(fileInProject, existingProjectCL);
        if (fcl == null || newProjectCL != existingProjectCL) {
            fcl = new FormClassLoader(newProjectCL);
            loaders.put(p, fcl);
        }
        return fcl;
    }

    static int getClassLoadingType(String className) {
        int i = className.lastIndexOf("[L");
        if (i != -1) {
            className = className.substring(i + 2, className.length() - 1);
        }
        if (ClassPathUtils.isClassLoaderType(className, 1)) {
            return 1;
        }
        if (ClassPathUtils.isClassLoaderType(className, 2)) {
            return 2;
        }
        return 0;
    }

    public static Class loadClass(ClassSource classSource) throws ClassNotFoundException {
        String className = classSource.getClassName();
        if (className == null) {
            return null;
        }
        ClassLoader loader = null;
        int cpRootCount = classSource.getCPRootCount();
        if (cpRootCount == 0) {
            loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        } else {
            try {
                ArrayList<URL> urlList = new ArrayList<URL>();
                for (int i = 0; i < cpRootCount; ++i) {
                    String type = classSource.getCPRootType(i);
                    String name = classSource.getCPRootName(i);
                    if ("jar".equals(type)) {
                        File jarFile = new File(name);
                        urlList.add(FileUtil.getArchiveRoot((URL)jarFile.toURI().toURL()));
                        continue;
                    }
                    if ("library".equals(type)) {
                        Library lib = LibraryManager.getDefault().getLibrary(name);
                        if (lib == null) continue;
                        List content = lib.getContent("classpath");
                        for (URL rootURL : content) {
                            if (FileUtil.isArchiveFile((URL)rootURL)) {
                                rootURL = FileUtil.getArchiveRoot((URL)rootURL);
                            }
                            urlList.add(rootURL);
                        }
                        continue;
                    }
                    if (!"project".equals(type)) continue;
                    File outputFile = new File(name);
                    URL rootURL = FileUtil.getArchiveRoot((URL)outputFile.toURI().toURL());
                    if (FileUtil.isArchiveFile((URL)rootURL)) {
                        rootURL = FileUtil.getArchiveRoot((URL)rootURL);
                    }
                    urlList.add(rootURL);
                }
                if (urlList.size() <= 0) {
                    return null;
                }
                URL[] roots = new URL[urlList.size()];
                urlList.toArray(roots);
                loader = ClassPathSupport.createClassPath((URL[])roots).getClassLoader(true);
            }
            catch (Exception ex) {
                IllegalArgumentException iae = new IllegalArgumentException();
                ErrorManager.getDefault().annotate((Throwable)iae, (Throwable)ex);
                throw iae;
            }
        }
        return loader.loadClass(classSource.getClassName());
    }

    public static ClassSource getProjectClassSource(FileObject fileInProject, String classname) {
        File outputFile;
        URI[] artifactLocations;
        Project project = FileOwnerQuery.getOwner((FileObject)fileInProject);
        if (project == null) {
            return null;
        }
        AntArtifact[] artifacts = AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar");
        if (artifacts.length == 0) {
            return null;
        }
        String[] outputs = null;
        block2: for (int i = 0; i < artifacts.length; ++i) {
            URI scriptLocation = artifacts[i].getScriptLocation().toURI();
            artifactLocations = artifacts[i].getArtifactLocations();
            for (int k = 0; k < artifactLocations.length; ++k) {
                URL outputURL;
                outputFile = new File(scriptLocation.resolve(artifactLocations[k]).normalize());
                try {
                    outputURL = outputFile.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    continue;
                }
                if (FileUtil.isArchiveFile((URL)outputURL)) {
                    outputURL = FileUtil.getArchiveRoot((URL)outputURL);
                }
                FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)outputURL).getRoots();
                for (int j = 0; j < sourceRoots.length; ++j) {
                    if (!FileUtil.isParentOf((FileObject)sourceRoots[j], (FileObject)fileInProject)) continue;
                    outputs = new String[]{outputFile.getAbsolutePath()};
                    break;
                }
                if (outputs != null) continue block2;
            }
        }
        if (outputs == null) {
            if (!fileInProject.getExt().equals("class")) {
                return null;
            }
            ArrayList<String> outputList = new ArrayList<String>(artifacts.length);
            for (int i = 0; i < artifacts.length; ++i) {
                artifactLocations = artifacts[i].getArtifactLocations();
                for (int j = 0; j < artifactLocations.length; ++j) {
                    outputFile = new File(artifacts[i].getScriptLocation().getParent() + File.separator + artifactLocations[j].getPath());
                    outputList.add(outputFile.getAbsolutePath());
                }
            }
            outputs = outputList.toArray(new String[outputList.size()]);
        }
        String[] types = new String[outputs.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = "project";
        }
        return new ClassSource(classname, types, outputs);
    }

    public static boolean isJava6ProjectPlatform(FileObject fileInProject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/boot");
        if (classPath == null) {
            return false;
        }
        return classPath.findResource("javax/swing/GroupLayout.class") != null;
    }

    public static boolean updateProject(FileObject fileInProject, ClassSource classSource) throws IOException {
        if (classSource.getCPRootCount() == 0) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileInProject);
        if (project == null) {
            return false;
        }
        ProjectClassPathExtender projectClassPath = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
        if (projectClassPath == null) {
            return false;
        }
        int n = classSource.getCPRootCount();
        for (int i = 0; i < n; ++i) {
            AntArtifact artifact;
            Object jarFile;
            String type = classSource.getCPRootType(i);
            String name = classSource.getCPRootName(i);
            if ("jar".equals(type)) {
                jarFile = FileUtil.toFileObject((File)new File(name));
                projectClassPath.addArchiveFile(jarFile);
                continue;
            }
            if ("library".equals(type)) {
                Library lib = LibraryManager.getDefault().getLibrary(name);
                projectClassPath.addLibrary(lib);
                continue;
            }
            if (!"project".equals(type) || (artifact = AntArtifactQuery.findArtifactFromFile((File)(jarFile = new File(name)))).getProject() == project) continue;
            URI[] locs = artifact.getArtifactLocations();
            for (int y = 0; y < locs.length; ++y) {
                projectClassPath.addAntArtifact(artifact, locs[y]);
            }
        }
        return true;
    }

    public static String getClassSourceDescription(ClassSource classSource) {
        if (classSource == null || classSource.getCPRootCount() == 0) {
            String className = classSource.getClassName();
            if (className != null) {
                if (className.startsWith("javax.") || className.startsWith("java.")) {
                    return ClassPathUtils.getBundleString("MSG_StandardJDKSource");
                }
                if (className.startsWith("org.netbeans.")) {
                    return ClassPathUtils.getBundleString("MSG_NetBeansSource");
                }
            }
        } else {
            String type = classSource.getCPRootType(0);
            String name = classSource.getCPRootName(0);
            if ("jar".equals(type)) {
                return MessageFormat.format(ClassPathUtils.getBundleString("FMT_JarSource"), name);
            }
            if ("library".equals(type)) {
                Library lib = LibraryManager.getDefault().getLibrary(name);
                return MessageFormat.format(ClassPathUtils.getBundleString("FMT_LibrarySource"), lib != null ? lib.getDisplayName() : name);
            }
            if ("project".equals(type)) {
                try {
                    Project project = FileOwnerQuery.getOwner((URI)new File(name).toURI());
                    return MessageFormat.format(ClassPathUtils.getBundleString("FMT_ProjectSource"), project == null ? name : project.getProjectDirectory().getPath().replace('/', File.separatorChar));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ClassPathUtils.getBundleString("MSG_UnspecifiedSource");
    }

    static String getBundleString(String key) {
        return NbBundle.getBundle(ClassPathUtils.class).getString(key);
    }

    private static boolean isClassLoaderType(String className, int clType) {
        List list = ClassPathUtils.getClassPatterns(clType);
        if (list == null) {
            return false;
        }
        for (ClassPattern cp : list) {
            switch (cp.type) {
                case 0: {
                    if (!className.equals(cp.name)) break;
                    return true;
                }
                case 1: {
                    if (!className.startsWith(cp.name) || className.lastIndexOf(46) > cp.name.length()) break;
                    return true;
                }
                case 2: {
                    if (!className.startsWith(cp.name)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static List getClassPatterns(int clType) {
        List list = null;
        switch (clType) {
            case 1: {
                list = patternsSystem;
                if (list != null) break;
                patternsSystem = list = ClassPathUtils.loadClassPatterns(ClassPathUtils.getClassPatternsFolder(clType));
                break;
            }
            case 2: {
                list = patternsSystemWithProject;
                if (list != null) break;
                patternsSystemWithProject = list = ClassPathUtils.loadClassPatterns(ClassPathUtils.getClassPatternsFolder(clType));
            }
        }
        return list;
    }

    private static FileObject getClassPatternsFolder(int clType) {
        FileObject folder = null;
        switch (clType) {
            case 1: {
                folder = patternSystemFolder;
                if (folder != null) break;
                folder = ClassPathUtils.getClassPatternsFolder(CL_SYSTEM_CLASS);
                if (folder == null) {
                    return null;
                }
                folder.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDataCreated(FileEvent ev) {
                        patternsSystem = null;
                        loaders.clear();
                    }

                    public void fileDeleted(FileEvent ev) {
                        patternsSystem = null;
                        if (ev.getFile() == patternSystemFolder) {
                            patternSystemFolder.removeFileChangeListener((FileChangeListener)this);
                            patternSystemFolder = null;
                        }
                        loaders.clear();
                    }
                });
                patternSystemFolder = folder;
                break;
            }
            case 2: {
                folder = patternSystemWithProjectFolder;
                if (folder != null) break;
                folder = ClassPathUtils.getClassPatternsFolder(CL_SYSTEM_CLASS_WITH_PROJECT);
                if (folder == null) {
                    return null;
                }
                folder.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDataCreated(FileEvent ev) {
                        patternsSystemWithProject = null;
                        loaders.clear();
                    }

                    public void fileDeleted(FileEvent ev) {
                        patternsSystemWithProject = null;
                        if (ev.getFile() == patternSystemFolder) {
                            patternSystemWithProjectFolder.removeFileChangeListener((FileChangeListener)this);
                            patternSystemWithProjectFolder = null;
                        }
                        loaders.clear();
                    }
                });
                patternSystemWithProjectFolder = folder;
            }
        }
        return folder;
    }

    private static FileObject getClassPatternsFolder(String folderName) {
        FileObject folder = null;
        if (folderName != null) {
            try {
                folder = Repository.getDefault().getDefaultFileSystem().findResource(CL_LAYER_BASE + folderName);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return folder;
    }

    private static List loadClassPatterns(FileObject folder) {
        ArrayList<ClassPattern> list = new ArrayList<ClassPattern>();
        if (folder == null) {
            return list;
        }
        FileObject[] files = folder.getChildren();
        for (int i = 0; i < files.length; ++i) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(files[i].getInputStream()));
                String line = r.readLine();
                while (line != null) {
                    if (!line.equals("")) {
                        ClassPattern cp = line.endsWith("**") ? new ClassPattern(line.substring(0, line.length() - 2), 2) : (line.endsWith("*") ? new ClassPattern(line.substring(0, line.length() - 1), 1) : new ClassPattern(line, 0));
                        list.add(cp);
                    }
                    line = r.readLine();
                }
                continue;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return list;
    }

    private static class ClassPattern {
        static final int CLASS = 0;
        static final int PACKAGE = 1;
        static final int PACKAGE_AND_SUBPACKAGES = 2;
        String name;
        int type;

        ClassPattern(String name, int type) {
            this.name = name;
            this.type = type;
        }
    }
}

