/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.classpath.Util;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.WeakListeners;

public class RefactoringClassPathImplementation
implements ClassPathImplementation,
GlobalPathRegistryListener,
PropertyChangeListener {
    private List resourceCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Collection fileSet;
    private Set sources;
    private Set compile;
    private Set boot;
    private static ClassPath defaultInstance;
    private static ClassPath customInstance;
    private static RefactoringClassPathImplementation customInstanceSPI;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RefactoringClassPathImplementation(Collection set) {
        this.fileSet = set;
    }

    public synchronized List getResources() {
        if (this.resourceCache == null) {
            this.resourceCache = Collections.unmodifiableList(this.createResources());
        }
        return this.resourceCache;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void pathsAdded(GlobalPathRegistryEvent event) {
        RefactoringClassPathImplementation.resetCache();
    }

    public void pathsRemoved(GlobalPathRegistryEvent event) {
        RefactoringClassPathImplementation.resetCache();
    }

    public void propertyChange(PropertyChangeEvent event) {
        RefactoringClassPathImplementation.resetCache();
    }

    private List createResources() {
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        HashSet<URL> covered = new HashSet<URL>();
        GlobalPathRegistry regs = GlobalPathRegistry.getDefault();
        regs.addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create((Class)GlobalPathRegistryListener.class, (EventListener)this, (Object)regs));
        if (!$assertionsDisabled && regs == null) {
            throw new AssertionError((Object)"GlobalPathRegistry.getDefault() returned null");
        }
        this.computeDependencies();
        Iterator it = this.sources.iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            Iterator et = cp.entries().iterator();
            while (et.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)et.next();
                URL url = entry.getURL();
                if (!$assertionsDisabled && url == null) {
                    throw new AssertionError((Object)"ClassPath.Entry.getURL() returned null");
                }
                if (!covered.add(url)) continue;
                result.add(ClassPathSupport.createResource((URL)url));
            }
            cp.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)(class$java$beans$PropertyChangeListener == null ? RefactoringClassPathImplementation.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener), (EventListener)this, (Object)cp));
        }
        this.addResources(this.boot, covered, result);
        this.addResources(this.compile, covered, result);
        return result;
    }

    private void computeDependencies() {
        if (this.fileSet.isEmpty()) {
            GlobalPathRegistry regs = GlobalPathRegistry.getDefault();
            this.sources = regs.getPaths("classpath/source");
            if (!$assertionsDisabled && this.sources == null) {
                throw new AssertionError((Object)"GlobalPathRegistry.getPath() for SOURCES returned null");
            }
            this.compile = regs.getPaths("classpath/compile");
            if (!$assertionsDisabled && this.compile == null) {
                throw new AssertionError((Object)"GlobalPathRegistry.getPath() for COMPILE returned null");
            }
            this.boot = regs.getPaths("classpath/boot");
            if (!$assertionsDisabled && this.boot == null) {
                throw new AssertionError((Object)"GlobalPathRegistry.getPath() for BOOT returned null");
            }
        } else {
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)PropertyChangeListener.class, (EventListener)this, (Object)OpenProjects.getDefault()));
            this.sources = new HashSet();
            this.compile = new HashSet();
            this.boot = new HashSet();
            Iterator it = this.getRelevantProjects().iterator();
            while (it.hasNext()) {
                Project p = (Project)it.next();
                Sources src = ProjectUtils.getSources((Project)p);
                SourceGroup[] groups = src.getSourceGroups("java");
                for (int i = 0; i < groups.length; ++i) {
                    ClassPath cp = ClassPath.getClassPath((FileObject)groups[i].getRootFolder(), (String)"classpath/source");
                    this.sources.add(cp);
                    cp = ClassPath.getClassPath((FileObject)groups[i].getRootFolder(), (String)"classpath/compile");
                    this.compile.add(cp);
                    cp = ClassPath.getClassPath((FileObject)groups[i].getRootFolder(), (String)"classpath/boot");
                    this.boot.add(cp);
                }
            }
        }
    }

    private Collection getRelevantProjects() {
        HashSet<Project> relevantProjects = new HashSet<Project>();
        Iterator i = this.fileSet.iterator();
        while (i.hasNext()) {
            FileObject fo = (FileObject)i.next();
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            if (p == null) {
                return Arrays.asList(OpenProjects.getDefault().getOpenProjects());
            }
            relevantProjects.addAll(Util.getSuperprojects(p));
            relevantProjects.add(p);
        }
        return relevantProjects;
    }

    private void addResources(Set classPaths, Set coveredResources, List addTo) {
        Iterator it = classPaths.iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            Iterator et = cp.entries().iterator();
            while (et.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)et.next();
                URL url = entry.getURL();
                if (!$assertionsDisabled && url == null) {
                    throw new AssertionError((Object)"ClassPath.Entry.getURL() returned null");
                }
                if (RefactoringClassPathImplementation.isCovered(coveredResources, url)) continue;
                addTo.add(ClassPathSupport.createResource((URL)url));
                coveredResources.add(url);
            }
            cp.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)(class$java$beans$PropertyChangeListener == null ? RefactoringClassPathImplementation.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener), (EventListener)this, (Object)cp));
        }
    }

    private static boolean isCovered(Set coveredResources, URL url) {
        if (coveredResources.contains(url)) {
            return true;
        }
        FileObject[] fos = SourceForBinaryQuery.findSourceRoots((URL)url).getRoots();
        if (!$assertionsDisabled && fos == null) {
            throw new AssertionError((Object)"SourceForBinaryQuery.findSourceRoot() returned null.");
        }
        for (int i = 0; i < fos.length; ++i) {
            try {
                if (!coveredResources.contains(fos[i].getURL())) continue;
                return true;
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return false;
    }

    private void firePropertyChange() {
        this.support.firePropertyChange("resources", null, null);
    }

    public static synchronized ClassPath getDefault() {
        if (defaultInstance == null) {
            defaultInstance = ClassPathFactory.createClassPath((ClassPathImplementation)new RefactoringClassPathImplementation(Collections.EMPTY_SET));
        }
        return defaultInstance;
    }

    public static synchronized ClassPath getCustom(Collection set) {
        if (!$assertionsDisabled && set == null) {
            throw new AssertionError();
        }
        if (customInstance == null || !RefactoringClassPathImplementation.theSameProjects(set, RefactoringClassPathImplementation.customInstanceSPI.fileSet)) {
            customInstanceSPI = new RefactoringClassPathImplementation(set);
            customInstance = ClassPathFactory.createClassPath((ClassPathImplementation)customInstanceSPI);
        }
        return customInstance;
    }

    private static boolean theSameProjects(Collection set1, Collection set2) {
        if (((Object)set1).equals(set2)) {
            return true;
        }
        HashSet projects1 = RefactoringClassPathImplementation.getProjects(set1);
        HashSet projects2 = RefactoringClassPathImplementation.getProjects(set2);
        return projects1.equals(projects2);
    }

    private static HashSet getProjects(Collection files) {
        HashSet<Project> projects = new HashSet<Project>(2);
        Iterator i = files.iterator();
        while (i.hasNext()) {
            FileObject fo = (FileObject)i.next();
            if (fo == null) continue;
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            projects.add(p);
        }
        return projects;
    }

    private static synchronized void resetCache() {
        defaultInstance = null;
        customInstance = null;
        Util.resetCache();
    }

    static {
        $assertionsDisabled = !RefactoringClassPathImplementation.class.desiredAssertionStatus();
    }
}

