/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import javax.swing.Action;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.refactoring.APIAccessor;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.SafeDeleteRefactoringElement;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.ProblemDetailsFactory;
import org.netbeans.modules.refactoring.spi.ProblemDetailsImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.RefactoringPanel;
import org.netbeans.modules.refactoring.ui.SafeDeleteUI;
import org.netbeans.modules.refactoring.ui.WhereUsedQueryUI;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class SafeDeleteRefactoringPlugin
extends JavaRefactoringPlugin {
    private SafeDeleteRefactoring refactoring;
    private WhereUsedQuery[] whereUsedQueries;

    public SafeDeleteRefactoringPlugin(SafeDeleteRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Collection refElementCollection = refactoringElements.getSession().getRefactoringElements();
        RefactoringSession inner = RefactoringSession.create("delete");
        HashSet<Object> refactoredObjects = new HashSet<Object>();
        this.fireProgressListenerStart(2, this.whereUsedQueries.length + 1);
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            Object refactoredObject = this.whereUsedQueries[i].getRefactoredObject();
            refactoredObjects.add(refactoredObject);
            if (!(this.whereUsedQueries[i].getRefactoredObject() instanceof Resource)) {
                this.whereUsedQueries[i].prepare(inner);
            }
            SafeDeleteRefactoringElement element = new SafeDeleteRefactoringElement((Element)refactoredObject);
            refactoringElements.add(this.refactoring, element);
            this.fireProgressListenerStep();
        }
        Iterator iter = inner.getRefactoringElements().iterator();
        while (iter.hasNext()) {
            Element elem;
            boolean isOuterRef = true;
            for (Element comp = elem = ((RefactoringElement)iter.next()).getJavaElement(); !(comp instanceof Resource) && comp != null; comp = (Element)comp.refImmediateComposite()) {
                if (!refactoredObjects.contains(comp)) continue;
                isOuterRef = false;
                break;
            }
            if (!isOuterRef) continue;
            this.fireProgressListenerStop();
            return new Problem(false, SafeDeleteRefactoringPlugin.getString("ERR_ReferencesFound"), ProblemDetailsFactory.createProblemDetails(new ProblemDetailsImplemen(new WhereUsedQueryUI((RefObject)elem), inner)));
        }
        this.fireProgressListenerStop();
        return null;
    }

    public Problem preCheck() {
        Element[] refElements = this.refactoring.getElementsToDelete();
        for (int i = 0; i < refElements.length; ++i) {
            boolean validType;
            Element refactoredObject = refElements[i];
            boolean bl = validType = refactoredObject instanceof ClassMember || refactoredObject instanceof LocalVariable || refactoredObject instanceof Resource;
            if (!validType) {
                String errMsg = NbBundle.getMessage((Class)SafeDeleteRefactoringPlugin.class, (String)"ERR_SafeDel_InvalidType");
                return new Problem(true, errMsg);
            }
            if (CheckUtils.isElementInOpenProject(refactoredObject)) continue;
            return new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        Element[] namedElements = this.refactoring.getElementsToDelete();
        this.whereUsedQueries = new WhereUsedQuery[namedElements.length];
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            this.whereUsedQueries[i] = APIAccessor.DEFAULT.createInternalWhereUsedQuery(namedElements[i], this.refactoring);
            this.whereUsedQueries[i].setSearchInComments(this.refactoring.isCheckInComments());
        }
        Problem problemFromUsage = null;
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            if (this.whereUsedQueries[i].getRefactoredObject() instanceof Resource || (problemFromUsage = this.whereUsedQueries[i].checkParameters()) == null) continue;
            return problemFromUsage;
        }
        return null;
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)SafeDeleteRefactoringPlugin.class, (String)key);
    }

    private Problem getProblemMessage(Object refactoredObject) {
        String errorMsg = NbBundle.getMessage((Class)SafeDeleteUI.class, (String)"DSC_SafeDelProblem", (Object)refactoredObject);
        return new Problem(true, errorMsg);
    }

    private class ProblemDetailsImplemen
    implements ProblemDetailsImplementation {
        private RefactoringUI ui;
        private RefactoringSession rs;

        public ProblemDetailsImplemen(RefactoringUI ui, RefactoringSession rs) {
            this.ui = ui;
            this.rs = rs;
        }

        public void showDetails(Action callback, Cancellable parent) {
            parent.cancel();
            new RefactoringPanel(this.ui, this.rs, callback).setVisible(true);
        }

        public String getDetailsHint() {
            return SafeDeleteRefactoringPlugin.getString("LBL_ShowUsages");
        }
    }
}

