/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public class CheckNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    private int selectionMode;
    private boolean isSelected = true;
    private String nodeLabel;
    private Icon icon;
    private boolean disabled = false;
    private boolean needsRefresh = false;
    private PositionBounds bounds = null;
    private String resourceName;
    private String tooltip;

    public CheckNode(Object userObject, String nodeLabel, Icon icon) {
        super(userObject, !(userObject instanceof RefactoringElement));
        this.setSelectionMode(4);
        this.nodeLabel = nodeLabel;
        this.icon = icon;
        if (userObject instanceof RefactoringElement) {
            Element el;
            RefactoringElement ree = (RefactoringElement)userObject;
            FileObject fo = ree.getParentFile();
            if (fo == null && (fo = JavaModel.getFileObject((Resource)(el = ree.getJavaElement()).getResource())) == null) {
                this.resourceName = null;
                return;
            }
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            this.resourceName = cp != null ? cp.getResourceName(fo) : null;
        }
    }

    String getLabel() {
        return this.nodeLabel;
    }

    Icon getIcon() {
        return this.icon;
    }

    public void setDisabled() {
        this.disabled = true;
        this.isSelected = false;
        this.removeAllChildren();
    }

    boolean isDisabled() {
        return this.disabled;
    }

    void setNeedsRefresh() {
        this.needsRefresh = true;
        this.setDisabled();
    }

    boolean needsRefresh() {
        return this.needsRefresh;
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (this.userObject instanceof RefactoringElement) {
            ((RefactoringElement)this.userObject).setEnabled(isSelected);
        }
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                CheckNode node = (CheckNode)e.nextElement();
                node.setSelected(isSelected);
            }
        }
    }

    public boolean isSelected() {
        if (this.userObject instanceof RefactoringElement) {
            return ((RefactoringElement)this.userObject).isEnabled() && ((RefactoringElement)this.userObject).getStatus() != 2 && ((RefactoringElement)this.userObject).getStatus() != 3;
        }
        return this.isSelected;
    }

    public PositionBounds getPosition() {
        if (this.userObject instanceof RefactoringElement) {
            return ((RefactoringElement)this.userObject).getPosition();
        }
        return null;
    }

    public String getToolTip() {
        if (this.tooltip == null) {
            if (this.resourceName != null && this.userObject instanceof RefactoringElement) {
                RefactoringElement ree = (RefactoringElement)this.userObject;
                PositionBounds bounds = this.getPosition();
                if (bounds != null) {
                    int line;
                    try {
                        line = bounds.getBegin().getLine() + 1;
                    }
                    catch (IOException ioe) {
                        return null;
                    }
                    this.tooltip = this.resourceName + ':' + line;
                }
            }
            return null;
        }
        return this.tooltip;
    }
}

