/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.net.SocketFactory;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;
import org.openide.util.NbBundle;

public class SSHConnection
extends AbstractConnection {
    private static final String CVS_SERVER_COMMAND = System.getProperty("Env-CVS_SERVER", "cvs") + " server";
    private final SocketFactory socketFactory;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private Session session;
    private ChannelExec channel;

    public SSHConnection(SocketFactory socketFactory, String host, int port, String username, String password) {
        this.socketFactory = socketFactory;
        this.host = host;
        this.port = port;
        this.username = username != null ? username : System.getProperty("user.name");
        this.password = password;
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        Properties props = new Properties();
        props.put("StrictHostKeyChecking", "no");
        JSch jsch = new JSch();
        try {
            this.session = jsch.getSession(this.username, this.host, this.port);
            this.session.setSocketFactory((com.jcraft.jsch.SocketFactory)new SocketFactoryBridge());
            this.session.setConfig(props);
            this.session.setUserInfo((UserInfo)new SSHUserInfo());
            this.session.connect();
        }
        catch (JSchException e) {
            throw new AuthenticationException((Throwable)e, NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3001"));
        }
        try {
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.channel.setCommand(CVS_SERVER_COMMAND);
            this.setInputStream(new LoggedDataInputStream((InputStream)new SshChannelInputStream((Channel)this.channel)));
            this.setOutputStream(new LoggedDataOutputStream(this.channel.getOutputStream()));
            this.channel.connect();
        }
        catch (JSchException e) {
            IOException ioe = new IOException(NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3002"));
            ioe.initCause(e);
            throw new AuthenticationException((Throwable)ioe, NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3003"));
        }
        catch (IOException e) {
            throw new AuthenticationException((Throwable)e, NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3003"));
        }
    }

    public void verify() throws AuthenticationException {
        try {
            this.open();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.channel.getExitStatus() != -1) {
                throw new AuthenticationException(CVS_SERVER_COMMAND, NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3004", (Object)CVS_SERVER_COMMAND));
            }
            this.close();
        }
        catch (CommandAbortedException e) {
            throw new AuthenticationException((Throwable)e, NbBundle.getMessage((Class)SSHConnection.class, (String)"BK3005"));
        }
        catch (IOException e) {
            throw new AuthenticationException((Throwable)e, NbBundle.getMessage((Class)SSHConnection.class, (String)"Bk3006"));
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        this.session = null;
        this.channel = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        this.reset();
    }

    public boolean isOpen() {
        return this.channel != null && this.channel.isConnected();
    }

    public int getPort() {
        return this.port;
    }

    public void modifyInputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyOutputStream(this.getOutputStream());
    }

    private static class SshChannelInputStream
    extends FilterInputStream {
        private final Channel channel;

        public SshChannelInputStream(Channel channel) throws IOException {
            super(channel.getInputStream());
            this.channel = channel;
        }

        public int available() throws IOException {
            this.checkChannelState();
            return super.available();
        }

        private void checkChannelState() throws IOException {
            int exitStatus = this.channel.getExitStatus();
            if (exitStatus > 0 || exitStatus < -1) {
                throw new IOException(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$SSHConnection == null ? (class$org$netbeans$modules$versioning$system$cvss$SSHConnection = SSHConnection.class$("org.netbeans.modules.versioning.system.cvss.SSHConnection")) : class$org$netbeans$modules$versioning$system$cvss$SSHConnection), (String)"BK3004", (Object)CVS_SERVER_COMMAND));
            }
            if (exitStatus == 0 || this.channel.isEOF()) {
                throw new EOFException(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$SSHConnection == null ? (class$org$netbeans$modules$versioning$system$cvss$SSHConnection = SSHConnection.class$("org.netbeans.modules.versioning.system.cvss.SSHConnection")) : class$org$netbeans$modules$versioning$system$cvss$SSHConnection), (String)"BK3007"));
            }
        }
    }

    private class SocketFactoryBridge
    implements com.jcraft.jsch.SocketFactory {
        private SocketFactoryBridge() {
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return SSHConnection.this.socketFactory.createSocket(host, port);
        }

        public InputStream getInputStream(Socket socket) throws IOException {
            return socket.getInputStream();
        }

        public OutputStream getOutputStream(Socket socket) throws IOException {
            return socket.getOutputStream();
        }
    }

    private class SSHUserInfo
    implements UserInfo {
        private SSHUserInfo() {
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return SSHConnection.this.password;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return false;
        }

        public void showMessage(String message) {
        }
    }
}

