/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class UpdateProjectsAction
extends SystemAction {
    public UpdateProjectsAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"CTL_MenuItem_UpdateProjects");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(UpdateProjectsAction.class);
    }

    public boolean isEnabled() {
        if (super.isEnabled()) {
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projects.length; ++i) {
                Project project = projects[i];
                if (!Utils.isVersionedProject(project)) continue;
                return true;
            }
        }
        return false;
    }

    public void actionPerformed(ActionEvent ev) {
        this.setEnabled(false);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                UpdateProjectsAction.this.async();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void async() {
        ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"BK0002"));
        try {
            group.progress(NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"BK0003"));
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            Context ctx = Utils.getProjectsContext(projects);
            if (ctx.getRootFiles().length == 0) {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"MSG_NoProjectFiles_Prompt"), NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"MSG_NoProjectFiles_Title"), 1);
                return;
            }
            GlobalOptions options = CvsVersioningSystem.createGlobalOptions();
            if (ctx.getExclusions().size() > 0) {
                options.setExclusions(ctx.getExclusions().toArray(new File[ctx.getExclusions().size()]));
            }
            UpdateCommand cmd = new UpdateCommand();
            cmd.setDisplayName(NbBundle.getMessage((Class)UpdateProjectsAction.class, (String)"BK0002"));
            cmd.setFiles(ctx.getRootFiles());
            cmd.setBuildDirectories(true);
            cmd.setPruneDirectories(true);
            group.addExecutors(UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), options));
            group.execute();
        }
        finally {
            this.setEnabled(true);
            group.executed();
        }
    }
}

