/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.log.LogCommand;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.BinaryMessageEvent;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.FileRemovedEvent;
import org.netbeans.lib.cvsclient.event.FileToRemoveEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchNodeChildren;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.Kit;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ModuleSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.NodeOperation2;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxyDescriptor;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;

public final class BranchSelector
implements Runnable {
    private CVSRoot root;
    private String module;
    private File file;
    private ProxyDescriptor proxyDescriptor;
    private Node rootNode;
    private BranchNodeChildren rootKids;

    public String selectTag(File file, ProxyDescriptor proxy) {
        this.file = file;
        this.proxyDescriptor = proxy;
        return this.showSelector();
    }

    public String selectTag(CVSRoot root, String module, ProxyDescriptor proxy) {
        this.root = root;
        this.module = module;
        this.proxyDescriptor = proxy;
        return this.showSelector();
    }

    private String showSelector() {
        this.rootKids = new BranchNodeChildren();
        this.rootNode = new AbstractNode((Children)this.rootKids);
        RequestProcessor.getDefault().post((Runnable)this);
        try {
            NodeOperation2 op = new NodeOperation2();
            op.setIconsVisible(false);
            op.setRootVisible(false);
            op.setHelpCtx(new HelpCtx(BranchSelector.class));
            Node[] selected = op.select(NbBundle.getMessage((Class)BranchSelector.class, (String)"BK2012"), NbBundle.getMessage((Class)BranchSelector.class, (String)"BK2013"), NbBundle.getMessage((Class)BranchSelector.class, (String)"ACSD_BranchSelect"), this.rootNode, NbBundle.getMessage((Class)BranchSelector.class, (String)"ACSN_BranchesTree"), NbBundle.getMessage((Class)BranchSelector.class, (String)"ACSD_BranchesTree"), new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodes) {
                    if (nodes.length != 1) {
                        return false;
                    }
                    return nodes[0].getLookup().lookup(class$java$lang$String == null ? (class$java$lang$String = BranchSelector.class$("java.lang.String")) : class$java$lang$String) != null;
                }
            });
            Node node = selected[0];
            String branch = (String)node.getLookup().lookup(String.class);
            return branch;
        }
        catch (UserCancelException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block21: {
            block20: {
                block19: {
                    block18: {
                        gtx = CvsVersioningSystem.createGlobalOptions();
                        if (this.root != null) {
                            gtx.setCVSRoot(this.root.toString());
                        }
                        checkoutFolder = null;
                        if (this.file != null) ** GOTO lbl42
                        checkoutFolder = Kit.createTmpFolder();
                        if (checkoutFolder != null) break block18;
                        this.error(NbBundle.getMessage((Class)BranchSelector.class, (String)"BK2015"));
                        Kit.deleteRecursively(checkoutFolder);
                        return;
                    }
                    checkout = new CheckoutCommand();
                    checkout.setRecursive(false);
                    if (".".equals(this.module)) {
                        client = Kit.createClient(this.root, this.proxyDescriptor);
                        l = ModuleSelector.listRepositoryPath(client, this.root, "");
                        it = l.iterator();
                        counter = max = l.size();
                        random = new Random();
                        while (counter-- > 0) {
                            rnd = random.nextInt(max);
                            path = (String)l.get(rnd);
                            if ("CVSROOT".equals(path)) continue;
                            this.module = path;
                            break;
                        }
                    }
                    checkout.setModule(this.module);
                    checkoutFiles = new File[]{checkoutFolder};
                    checkout.setFiles(checkoutFiles);
                    client = Kit.createClient(this.root, this.proxyDescriptor);
                    client.setLocalPath(checkoutFolder.getAbsolutePath());
                    client.executeCommand((Command)checkout, gtx);
                    files = checkoutFolder.listFiles();
                    localPath = checkoutFolder;
                    for (i = 0; i < files.length; ++i) {
                        if (files[i].isFile() || "CVSROOT".equals(files[i].getName())) continue;
                        files = files[i].listFiles();
                        break block19;
                    }
                    break block19;
lbl42:
                    // 1 sources

                    if (this.file.isDirectory()) {
                        files = this.file.listFiles();
                        localPath = this.file;
                    } else {
                        files = new File[]{this.file};
                        localPath = this.file.getParentFile();
                    }
                }
                logFiles = new ArrayList<E>(files.length);
                this.fillLogFiles(files, logFiles);
                if (!logFiles.isEmpty()) break block20;
                this.tagsLoaded(Collections.EMPTY_SET, Collections.EMPTY_SET);
                Kit.deleteRecursively(checkoutFolder);
                return;
            }
            try {
                log = new LogCommand();
                log.setHeaderOnly(true);
                cmdFiles = logFiles.toArray(new File[logFiles.size()]);
                log.setFiles(cmdFiles);
                if (this.root == null) {
                    for (i = 0; i < cmdFiles.length; ++i) {
                        try {
                            this.root = CVSRoot.parse((String)Utils.getCVSRootFor(cmdFiles[i]));
                            break;
                        }
                        catch (IOException e) {
                            err = ErrorManager.getDefault();
                            err.annotate((Throwable)e, "Can not find CVSROOT for " + cmdFiles[i]);
                            err.notify(1, (Throwable)e);
                            continue;
                        }
                    }
                }
                client = Kit.createClient(this.root, this.proxyDescriptor);
                tags = new TreeSet<E>();
                branches = new TreeSet<E>();
                mgr = client.getEventManager();
                mgr.addCVSListener(new CVSListener(){

                    public void messageSent(MessageEvent e) {
                    }

                    public void messageSent(BinaryMessageEvent e) {
                    }

                    public void fileAdded(FileAddedEvent e) {
                    }

                    public void fileToRemove(FileToRemoveEvent e) {
                    }

                    public void fileRemoved(FileRemovedEvent e) {
                    }

                    public void fileUpdated(FileUpdatedEvent e) {
                    }

                    public void fileInfoGenerated(FileInfoEvent e) {
                        LogInformation info = (LogInformation)e.getInfoContainer();
                        List symNames = info.getAllSymbolicNames();
                        Iterator it = symNames.iterator();
                        while (it.hasNext()) {
                            LogInformation.SymName name = (LogInformation.SymName)it.next();
                            if (name.isBranch()) {
                                branches.add(name.getName());
                                continue;
                            }
                            tags.add(name.getName());
                        }
                    }

                    public void commandTerminated(TerminationEvent e) {
                    }

                    public void moduleExpanded(ModuleExpansionEvent e) {
                    }
                });
                client.setLocalPath(localPath.getAbsolutePath());
                client.executeCommand((Command)log, gtx);
                this.tagsLoaded(branches, tags);
                Kit.deleteRecursively(checkoutFolder);
            }
            catch (CommandException e) {
                this.error(NbBundle.getMessage((Class)BranchSelector.class, (String)"BK2016"));
                err = ErrorManager.getDefault();
                err.annotate((Throwable)e, NbBundle.getMessage((Class)BranchSelector.class, (String)"BK2016"));
                err.notify((Throwable)e);
                Kit.deleteRecursively(checkoutFolder);
                break block21;
            }
            catch (AuthenticationException e) {
                this.error(NbBundle.getMessage((Class)BranchSelector.class, (String)"BK2016"));
                err = ErrorManager.getDefault();
                err.annotate((Throwable)e, NbBundle.getMessage((Class)BranchSelector.class, (String)"BK2016"));
                err.notify((Throwable)e);
                {
                    catch (Throwable var14_22) {
                        Kit.deleteRecursively(checkoutFolder);
                        throw var14_22;
                    }
                }
                Kit.deleteRecursively(checkoutFolder);
            }
            Kit.deleteRecursively(checkoutFolder);
        }
    }

    private void fillLogFiles(File[] files, List logFiles) {
        int i;
        if (files == null) {
            return;
        }
        if (!logFiles.isEmpty()) {
            return;
        }
        for (i = 0; i < files.length; ++i) {
            FileInformation info;
            if (!files[i].isFile() || ((info = CvsVersioningSystem.getInstance().getStatusCache().getStatus(files[i])).getStatus() & 0xFF8) == 0) continue;
            logFiles.add(files[i]);
        }
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            this.fillLogFiles(files[i].listFiles(), logFiles);
        }
    }

    private void tagsLoaded(Collection branches, Collection tags) {
        this.rootKids.setBranches(branches);
        this.rootKids.setTags(tags);
    }

    private void error(String msg) {
        this.rootNode.setDisplayName(msg);
    }
}

