/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.modules.versioning.system.cvss.settings.HistorySettings;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxyConfigurationPanel;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ProxyDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ProxySelector
implements ActionListener,
DocumentListener {
    private ProxyDescriptor proxyDescriptor;
    private ProxyConfigurationPanel proxyPanel;
    private DialogDescriptor dialogDescriptor;

    public ProxyDescriptor selectProxy() {
        this.proxyPanel = new ProxyConfigurationPanel();
        if (this.proxyDescriptor != null) {
            if (this.proxyDescriptor.isSystemProxyDescriptor()) {
                this.proxyPanel.systemProxyRadioButton.setSelected(true);
            } else if (this.proxyDescriptor.getType() == 1) {
                this.proxyPanel.httpProxyRadioButton.setSelected(true);
            } else if (this.proxyDescriptor.getType() == 2) {
                this.proxyPanel.socksProxyRadioButton.setSelected(true);
            } else if (this.proxyDescriptor.getType() == 0) {
                this.proxyPanel.directRadioButton.setSelected(true);
            }
        } else {
            this.proxyDescriptor = new ProxyDescriptor();
        }
        this.updateFields(this.proxyDescriptor);
        this.proxyPanel.systemProxyRadioButton.addActionListener(this);
        this.proxyPanel.directRadioButton.addActionListener(this);
        this.proxyPanel.httpProxyRadioButton.addActionListener(this);
        this.proxyPanel.socksProxyRadioButton.addActionListener(this);
        this.proxyPanel.portTextField.getDocument().addDocumentListener(this);
        this.proxyPanel.serverTextField.getDocument().addDocumentListener(this);
        this.proxyPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.dialogDescriptor = new DialogDescriptor((Object)this.proxyPanel, NbBundle.getMessage((Class)ProxySelector.class, (String)"BK2004"));
        this.dialogDescriptor.setModal(true);
        this.dialogDescriptor.setHelpCtx(new HelpCtx(ProxySelector.class));
        this.revalidate();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ProxySelector.class, (String)"ACSD_ProxyDialog"));
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(this.dialogDescriptor.getValue())) {
            if (this.proxyPanel.systemProxyRadioButton.isSelected()) {
                return new ProxyDescriptor();
            }
            int type = 1;
            if (this.proxyPanel.socksProxyRadioButton.isSelected()) {
                type = 2;
            } else if (this.proxyPanel.directRadioButton.isSelected()) {
                return ProxyDescriptor.DIRECT;
            }
            String host = this.proxyPanel.serverTextField.getText();
            int port = -1;
            String portNum = this.proxyPanel.portTextField.getText();
            try {
                port = Integer.parseInt(portNum);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            String user = null;
            String password = null;
            if (this.proxyPanel.loginCheckBox.isSelected()) {
                user = this.proxyPanel.nameTextField.getText();
                password = this.proxyPanel.passwordTextField.getText();
            }
            HistorySettings history = HistorySettings.getDefault();
            if (type == 1) {
                history.setHttpProxyHost(host);
                history.setHttpProxyPort(portNum);
            } else if (type == 2) {
                history.setSocksProxyHost(host);
                history.setSocksProxyPort(portNum);
            }
            return new ProxyDescriptor(type, host, port, user, password);
        }
        return null;
    }

    private void updateFields(ProxyDescriptor proxyDescriptor) {
        boolean editable = !proxyDescriptor.isSystemProxyDescriptor() && proxyDescriptor.getType() != 0;
        String tip = null;
        if (!editable) {
            tip = proxyDescriptor.getDescription();
        }
        if (tip == null) {
            tip = ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/selectors/Bundle").getString("TT_UseSystemProxy");
        }
        this.proxyPanel.systemProxyRadioButton.setToolTipText(tip);
        String host = null;
        String port = null;
        String user = null;
        String password = null;
        if (proxyDescriptor.getType() != 0) {
            host = proxyDescriptor.getHost();
            int i = proxyDescriptor.getPort();
            if (i != -1) {
                port = "" + i;
            }
            user = proxyDescriptor.getUserName();
            password = proxyDescriptor.getPassword();
        }
        this.proxyPanel.serverTextField.setText(host);
        this.proxyPanel.portTextField.setText(port);
        this.proxyPanel.loginCheckBox.setSelected(user != null);
        this.proxyPanel.nameTextField.setText(user);
        this.proxyPanel.passwordTextField.setText(password);
        this.proxyPanel.serverTextField.setEditable(editable);
        this.proxyPanel.portTextField.setEditable(editable);
        this.proxyPanel.loginCheckBox.setEnabled(editable);
        this.proxyPanel.passwordTextField.setEnabled(editable && user != null);
        this.proxyPanel.nameTextField.setEnabled(editable && user != null);
        this.proxyPanel.enableServerPart(editable);
    }

    private void revalidate() {
        if (this.proxyPanel.directRadioButton.isSelected() || this.proxyPanel.systemProxyRadioButton.isSelected()) {
            this.dialogDescriptor.setValid(true);
        } else {
            boolean valid = true;
            Document doc = this.proxyPanel.portTextField.getDocument();
            try {
                int port = Integer.parseInt(doc.getText(0, doc.getLength()));
                valid &= port > 0;
            }
            catch (Exception e) {
                valid = false;
            }
            doc = this.proxyPanel.serverTextField.getDocument();
            this.dialogDescriptor.setValid(valid &= doc.getLength() > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProxyDescriptor detectSystemProxy() {
        String home;
        File kioslaverc;
        String hostName = System.getProperty("socksProxyHost");
        if (hostName != null) {
            int port = Integer.parseInt(System.getProperty("socksProxyPort", "1080"));
            String user = System.getProperty("java.net.socks.username", System.getProperty("user.name"));
            String password = System.getProperty("java.net.socks.password");
            return new ProxyDescriptor(2, hostName, port, user, password);
        }
        ProxyDescriptor pd = ProxySelector.detectNetbeansHttpProxy();
        if (pd != null) {
            return pd;
        }
        String hostHttp = System.getProperty("http.ProxyHost");
        String portHttp = System.getProperty("http.ProxyPort");
        if (hostHttp != null) {
            int port;
            try {
                port = Integer.parseInt(portHttp);
            }
            catch (NumberFormatException e) {
                port = 8080;
            }
            return new ProxyDescriptor(1, hostHttp, port, null, null);
        }
        if ("Linux".equalsIgnoreCase(System.getProperty("os.name")) && (kioslaverc = new File(home = System.getProperty("user.home"), ".kde/share/config/kioslaverc")).exists()) {
            BufferedReader r = null;
            try {
                FileInputStream in = new FileInputStream(kioslaverc);
                InputStreamReader inr = new InputStreamReader(in);
                r = new BufferedReader(inr);
                String MAGIC = "httpProxy=";
                String line = r.readLine();
                while (true) {
                    if (line != null) {
                        if (line.startsWith("httpProxy=")) {
                            ProxyDescriptor desc;
                            String host;
                            int portOffset;
                            String setting = line.substring("httpProxy=".length());
                            int port = -1;
                            int hostOffset = setting.indexOf("//");
                            if (hostOffset != -1) {
                                setting = setting.substring(hostOffset + 2);
                            }
                            if ((portOffset = setting.indexOf(58)) != -1) {
                                host = setting.substring(0, portOffset);
                                String s = setting.substring(portOffset + 1);
                                port = Integer.parseInt(s);
                            } else {
                                host = setting;
                            }
                            String msg = NbBundle.getMessage((Class)ProxySelector.class, (String)"BK2001");
                            ProxyDescriptor proxyDescriptor = desc = new ProxyDescriptor(1, host, port, null, null, msg);
                            return proxyDescriptor;
                        }
                        line = r.readLine();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                ErrorManager err = ErrorManager.getDefault();
                err.annotate((Throwable)e, NbBundle.getMessage((Class)ProxySelector.class, (String)"BK2023") + kioslaverc);
                err.notify((Throwable)e);
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException alreadyClosed) {}
                }
            }
        }
        return null;
    }

    private static ProxyDescriptor detectNetbeansHttpProxy() {
        int port;
        String host = ProxySelector.getNetbeansProxyHost();
        if (host == null) {
            return null;
        }
        String portHttp = ProxySelector.getNetbeansProxyPort();
        try {
            port = Integer.parseInt(portHttp);
        }
        catch (NumberFormatException e) {
            port = 8080;
        }
        String desc = NbBundle.getMessage((Class)ProxySelector.class, (String)"BK2000");
        return new ProxyDescriptor(1, host, port, null, null, desc);
    }

    private static String getNetbeansProxyHost() {
        String systemProxy = System.getProperty("netbeans.system_http_proxy");
        if (systemProxy == null) {
            return null;
        }
        int i = systemProxy.indexOf(":");
        if (i <= 0 || i >= systemProxy.length() - 1) {
            return null;
        }
        return systemProxy.substring(0, i);
    }

    private static String getNetbeansProxyPort() {
        String systemProxy = System.getProperty("netbeans.system_http_proxy");
        if (systemProxy == null) {
            return "";
        }
        int i = systemProxy.indexOf(":");
        if (i <= 0 || i >= systemProxy.length() - 1) {
            return "";
        }
        return systemProxy.substring(i + 1);
    }

    public void setProxyDescriptor(ProxyDescriptor proxyDescriptor) {
        this.proxyDescriptor = proxyDescriptor;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.proxyPanel.systemProxyRadioButton.isSelected()) {
            ProxyDescriptor bootstrap = ProxySelector.detectSystemProxy();
            if (bootstrap == null) {
                bootstrap = ProxyDescriptor.DIRECT;
            }
            this.updateFields(bootstrap);
        } else if (this.proxyPanel.directRadioButton.isSelected()) {
            this.updateFields(ProxyDescriptor.DIRECT);
        } else if (this.proxyPanel.httpProxyRadioButton.isSelected()) {
            if ("".equals(this.proxyPanel.portTextField.getText()) && "".equals(this.proxyPanel.serverTextField.getText())) {
                HistorySettings history = HistorySettings.getDefault();
                this.proxyPanel.serverTextField.setText(history.getHttpProxyHost());
                this.proxyPanel.portTextField.setText(history.getHttpProxyPort());
            }
        } else if (this.proxyPanel.socksProxyRadioButton.isSelected() && "".equals(this.proxyPanel.portTextField.getText()) && "".equals(this.proxyPanel.serverTextField.getText())) {
            HistorySettings history = HistorySettings.getDefault();
            this.proxyPanel.serverTextField.setText(history.getSocksProxyHost());
            this.proxyPanel.portTextField.setText(history.getSocksProxyPort());
        }
        this.revalidate();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.revalidate();
    }

    public void removeUpdate(DocumentEvent e) {
        this.revalidate();
    }
}

