/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.netbeans.modules.db.sql.execute.StatementInfo;

public class SQLExecutionResult {
    private final StatementInfo statementInfo;
    private final Statement statement;
    private final ResultSet resultSet;
    private final SQLException exception;
    private final long executionTime;
    private final int rowCount;

    public SQLExecutionResult(StatementInfo info, Statement statement, ResultSet resultSet, long executionTime) {
        this(info, statement, resultSet, -1, null, executionTime);
    }

    public SQLExecutionResult(StatementInfo info, Statement statement, int rowCount, long executionTime) {
        this(info, statement, null, rowCount, null, executionTime);
    }

    public SQLExecutionResult(StatementInfo info, Statement statement, SQLException exception) {
        this(info, statement, null, -1, exception, 0L);
    }

    private SQLExecutionResult(StatementInfo info, Statement statement, ResultSet resultSet, int rowCount, SQLException exception, long executionTime) {
        this.statementInfo = info;
        this.statement = statement;
        this.resultSet = resultSet;
        this.rowCount = rowCount;
        this.exception = exception;
        this.executionTime = executionTime;
    }

    public StatementInfo getStatementInfo() {
        return this.statementInfo;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public SQLException getException() {
        return this.exception;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        finally {
            if (this.statement != null) {
                this.statement.close();
            }
        }
    }

    public String toString() {
        return "SQLExecutionResult[resultSet=" + this.resultSet + ",rowCount=" + this.rowCount + ",exception=" + this.exception + ",executionTime=" + this.executionTime + "]";
    }
}

