/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class JavaActions
implements ActionProvider {
    static final String NS_GENERAL = "http://www.netbeans.org/ns/freeform-project/1";
    private static final String[] ACTIONS;
    static final String FILE_SCRIPT_PATH = "nbproject/ide-file-targets.xml";
    static final String GENERAL_SCRIPT_PATH = "nbproject/ide-targets.xml";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final AuxiliaryConfiguration aux;
    private boolean setOutputsNotified;
    private static final String[] DEBUG_VM_ARGS;
    private static final String[] rootElementsOrder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JavaActions(Project project, AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
        this.project = project;
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
    }

    public String[] getSupportedActions() {
        return ACTIONS;
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if (command.equals("compile.single")) {
            return this.findPackageRoot(context) != null;
        }
        if (command.equals("debug")) {
            return true;
        }
        throw new IllegalArgumentException(command);
    }

    public void invokeAction(final String command, final Lookup context) throws IllegalArgumentException {
        try {
            this.project.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    block4: {
                        try {
                            if (command.equals("compile.single")) {
                                JavaActions.this.handleCompileSingle(context);
                                break block4;
                            }
                            if (command.equals("debug")) {
                                JavaActions.this.handleDebug();
                                break block4;
                            }
                            throw new IllegalArgumentException(command);
                        }
                        catch (SAXException e) {
                            throw (IOException)new IOException(e.toString()).initCause(e);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private boolean alert(String commandDisplayName, String scriptPath) {
        String projectDisplayName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        String title = NbBundle.getMessage((Class)JavaActions.class, (String)"TITLE_generate_target_dialog", (Object)commandDisplayName, (Object)projectDisplayName);
        String body = NbBundle.getMessage((Class)JavaActions.class, (String)"TEXT_generate_target_dialog", (Object)commandDisplayName, (Object)scriptPath);
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)body, 3);
        d.setTitle(title);
        d.setOptionType(2);
        JButton generate = new JButton(NbBundle.getMessage((Class)JavaActions.class, (String)"LBL_generate"));
        generate.setDefaultCapable(true);
        d.setOptions(new Object[]{generate, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == generate;
    }

    private boolean alertOutputs(String commandDisplayName) {
        JButton setOutputOption = new JButton(NbBundle.getMessage((Class)JavaActions.class, (String)"CTL_SetOutput"));
        setOutputOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)JavaActions.class, (String)"AD_SetOutput"));
        setOutputOption.setDefaultCapable(true);
        String projectDisplayName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        String title = NbBundle.getMessage((Class)JavaActions.class, (String)"TITLE_set_outputs_dialog", (Object)commandDisplayName, (Object)projectDisplayName);
        String body = NbBundle.getMessage((Class)JavaActions.class, (String)"TEXT_set_outputs_dialog");
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)body, 3);
        d.setTitle(title);
        d.setOptionType(2);
        d.setOptions(new Object[]{setOutputOption, NotifyDescriptor.CANCEL_OPTION});
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == setOutputOption) {
            CustomizerProvider customizerProvider = (CustomizerProvider)this.project.getLookup().lookup(CustomizerProvider.class);
            if (!$assertionsDisabled && customizerProvider == null) {
                throw new AssertionError();
            }
            customizerProvider.showCustomizer();
            return true;
        }
        return false;
    }

    private void handleCompileSingle(Lookup context) throws IOException, SAXException {
        if (!this.alert(NbBundle.getMessage((Class)JavaActions.class, (String)"ACTION_compile.single"), FILE_SCRIPT_PATH)) {
            return;
        }
        Document doc = this.readCustomScript(FILE_SCRIPT_PATH);
        this.ensurePropertiesCopied(doc.getDocumentElement());
        Comment comm = doc.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_edit_target") + " ");
        doc.getDocumentElement().appendChild(comm);
        comm = doc.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_more_info_x.single") + " ");
        doc.getDocumentElement().appendChild(comm);
        String propertyName = "files";
        AntLocation root = this.findPackageRoot(context);
        if (!$assertionsDisabled && root == null) {
            throw new AssertionError(context);
        }
        Element target = this.createCompileSingleTarget(doc, context, propertyName, root);
        doc.getDocumentElement().appendChild(target);
        this.writeCustomScript(doc, FILE_SCRIPT_PATH);
        String pattern = "\\.java$";
        String targetName = target.getAttribute("name");
        this.addBinding("compile.single", FILE_SCRIPT_PATH, targetName, propertyName, root.virtual, pattern, "relative-path", ",");
        this.jumpToBinding("compile.single");
        this.jumpToBuildScript(FILE_SCRIPT_PATH, targetName);
    }

    Element createCompileSingleTarget(Document doc, Lookup context, String propertyName, AntLocation root) {
        String cp;
        String targetName = "compile-selected-files-in-" + root.physical.getNameExt();
        Element target = doc.createElement("target");
        target.setAttribute("name", targetName);
        Element fail = doc.createElement("fail");
        fail.setAttribute("unless", propertyName);
        fail.appendChild(doc.createTextNode(NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_must_set_property", (Object)propertyName)));
        target.appendChild(fail);
        String classesDir = this.findClassesOutputDir(root.virtual);
        if (classesDir == null) {
            target.appendChild(doc.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_must_set_build_classes_dir") + " "));
            classesDir = "${build.classes.dir}";
        }
        Element mkdir = doc.createElement("mkdir");
        mkdir.setAttribute("dir", classesDir);
        target.appendChild(mkdir);
        Element javac = doc.createElement("javac");
        javac.setAttribute("srcdir", root.virtual);
        javac.setAttribute("destdir", classesDir);
        javac.setAttribute("includes", "${" + propertyName + "}");
        String sourceLevel = this.findSourceLevel(root.virtual);
        if (sourceLevel != null) {
            javac.setAttribute("source", sourceLevel);
        }
        if ((cp = this.findCompileClasspath(root.virtual)) != null) {
            Element classpath = doc.createElement("classpath");
            classpath.setAttribute("path", cp);
            javac.appendChild(classpath);
        }
        target.appendChild(javac);
        return target;
    }

    private void handleDebug() throws IOException, SAXException {
        Element generatedTarget;
        Document doc;
        String generatedScriptPath;
        if (!this.setOutputsNotified) {
            ProjectModel pm = ProjectModel.createModel(Util.getProjectLocation((AntProjectHelper)this.helper, (PropertyEvaluator)this.evaluator), FileUtil.toFile((FileObject)this.project.getProjectDirectory()), this.evaluator, this.helper);
            List cuKeys = pm.createCompilationUnitKeys();
            if (!$assertionsDisabled && cuKeys == null) {
                throw new AssertionError();
            }
            boolean hasOutputs = false;
            Iterator it = cuKeys.iterator();
            while (it.hasNext()) {
                ProjectModel.CompilationUnitKey ck = (ProjectModel.CompilationUnitKey)it.next();
                JavaProjectGenerator.JavaCompilationUnit cu = pm.getCompilationUnit(ck, false);
                if (cu.output == null || cu.output.size() <= 0) continue;
                hasOutputs = true;
                break;
            }
            if (!hasOutputs) {
                this.alertOutputs(NbBundle.getMessage((Class)JavaActions.class, (String)"ACTION_debug"));
                this.setOutputsNotified = true;
                return;
            }
        }
        String[] bindings = this.findCommandBinding("run");
        Element task = null;
        Element origTarget = null;
        if (bindings != null && bindings.length <= 2 && (origTarget = this.findExistingBuildTarget("run")) != null) {
            task = this.targetUsesTaskExactlyOnce(origTarget, "java");
        }
        if (!this.alert(NbBundle.getMessage((Class)JavaActions.class, (String)"ACTION_debug"), task != null ? GENERAL_SCRIPT_PATH : FILE_SCRIPT_PATH)) {
            return;
        }
        String generatedTargetName = "debug-nb";
        if (task != null) {
            generatedScriptPath = GENERAL_SCRIPT_PATH;
            doc = this.readCustomScript(GENERAL_SCRIPT_PATH);
            this.ensureImports(doc.getDocumentElement(), bindings[0]);
            generatedTarget = this.createDebugTargetFromTemplate(generatedTargetName, origTarget, task, doc);
        } else {
            generatedScriptPath = FILE_SCRIPT_PATH;
            doc = this.readCustomScript(FILE_SCRIPT_PATH);
            this.ensurePropertiesCopied(doc.getDocumentElement());
            generatedTarget = this.createDebugTargetFromScratch(generatedTargetName, doc);
        }
        Comment comm = doc.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_edit_target") + " ");
        doc.getDocumentElement().appendChild(comm);
        comm = doc.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_more_info_debug") + " ");
        doc.getDocumentElement().appendChild(comm);
        doc.getDocumentElement().appendChild(generatedTarget);
        this.writeCustomScript(doc, generatedScriptPath);
        this.addBinding("debug", generatedScriptPath, generatedTargetName, null, null, null, null, null);
        this.jumpToBinding("debug");
        this.jumpToBuildScript(generatedScriptPath, generatedTargetName);
    }

    private Element createNbjpdastart(Document ownerDocument) {
        Element nbjpdastart = ownerDocument.createElement("nbjpdastart");
        nbjpdastart.setAttribute("name", ProjectUtils.getInformation((Project)this.project).getDisplayName());
        nbjpdastart.setAttribute("addressproperty", "jpda.address");
        nbjpdastart.setAttribute("transport", "dt_socket");
        return nbjpdastart;
    }

    private void addDebugVMArgs(Element java, Document ownerDocument) {
        int i;
        NamedNodeMap attrs = java.getAttributes();
        boolean found = false;
        for (i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!"fork".equals(attr.getName())) continue;
            String value = attr.getValue();
            if (!"on".equalsIgnoreCase(value) && !"true".equalsIgnoreCase(value) && !"yes".equalsIgnoreCase(value)) break;
            found = true;
            break;
        }
        if (!found) {
            java.setAttribute("fork", "true");
        }
        for (i = 0; i < DEBUG_VM_ARGS.length; ++i) {
            Element jvmarg = ownerDocument.createElement("jvmarg");
            jvmarg.setAttribute("value", DEBUG_VM_ARGS[i]);
            java.appendChild(jvmarg);
        }
    }

    Element createDebugTargetFromTemplate(String generatedTargetName, Element origTarget, Element origTask, Document ownerDocument) {
        NodeList tasks = origTarget.getChildNodes();
        int taskIndex = -1;
        for (int i = 0; i < tasks.getLength(); ++i) {
            if (tasks.item(i) != origTask) continue;
            taskIndex = i;
            break;
        }
        if (!$assertionsDisabled && taskIndex == -1) {
            throw new AssertionError();
        }
        Element target = (Element)ownerDocument.importNode(origTarget, true);
        Element task = (Element)target.getChildNodes().item(taskIndex);
        target.setAttribute("name", generatedTargetName);
        Element nbjpdastart = this.createNbjpdastart(ownerDocument);
        String textualCp = task.getAttribute("classpath");
        if (textualCp.length() > 0) {
            Element classpath = ownerDocument.createElement("classpath");
            classpath.setAttribute("path", textualCp);
            nbjpdastart.appendChild(classpath);
        } else {
            NodeList origClasspath = task.getElementsByTagName("classpath");
            if (origClasspath.getLength() == 1) {
                Element classpath = (Element)ownerDocument.importNode(origClasspath.item(0), true);
                nbjpdastart.appendChild(classpath);
            }
        }
        target.insertBefore(nbjpdastart, task);
        this.addDebugVMArgs(task, ownerDocument);
        return target;
    }

    Element createDebugTargetFromScratch(String generatedTargetName, Document ownerDocument) {
        Element target = ownerDocument.createElement("target");
        target.setAttribute("name", generatedTargetName);
        Element path = ownerDocument.createElement("path");
        path.setAttribute("id", "cp");
        path.appendChild(ownerDocument.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_set_runtime_cp") + " "));
        target.appendChild(path);
        Element nbjpdastart = this.createNbjpdastart(ownerDocument);
        Element classpath = ownerDocument.createElement("classpath");
        classpath.setAttribute("refid", "cp");
        nbjpdastart.appendChild(classpath);
        target.appendChild(nbjpdastart);
        target.appendChild(ownerDocument.createComment(" " + NbBundle.getMessage((Class)JavaActions.class, (String)"COMMENT_set_main_class") + " "));
        Element java = ownerDocument.createElement("java");
        java.setAttribute("classname", "some.main.Class");
        classpath = ownerDocument.createElement("classpath");
        classpath.setAttribute("refid", "cp");
        java.appendChild(classpath);
        this.addDebugVMArgs(java, ownerDocument);
        target.appendChild(java);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Document readCustomScript(String scriptPath) throws IOException, SAXException {
        FileObject script = this.helper.getProjectDirectory().getFileObject(scriptPath);
        if (script != null) {
            InputStream is = script.getInputStream();
            try {
                Document document = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)true, null, null);
                return document;
            }
            finally {
                is.close();
            }
        }
        Document doc = XMLUtil.createDocument((String)"project", null, null, null);
        Element root = doc.getDocumentElement();
        String projname = ProjectUtils.getInformation((Project)this.project).getDisplayName();
        root.setAttribute("name", NbBundle.getMessage((Class)JavaActions.class, (String)"LBL_generated_script_name", (Object)projname));
        return doc;
    }

    void ensurePropertiesCopied(Element antProject) {
        if (antProject.getAttribute("basedir").length() > 0) {
            return;
        }
        antProject.setAttribute("basedir", "..");
        Element data = this.helper.getPrimaryConfigurationData(true);
        Element properties = Util.findElement((Element)data, (String)"properties", (String)NS_GENERAL);
        if (properties != null) {
            Iterator propertiesIt = Util.findSubElements((Element)properties).iterator();
            while (propertiesIt.hasNext()) {
                Element el = (Element)propertiesIt.next();
                Element nue = antProject.getOwnerDocument().createElement("property");
                if (el.getLocalName().equals("property")) {
                    String name = el.getAttribute("name");
                    if (!$assertionsDisabled && name == null) {
                        throw new AssertionError();
                    }
                    String text = Util.findText((Element)el);
                    if (!$assertionsDisabled && text == null) {
                        throw new AssertionError();
                    }
                    nue.setAttribute("name", name);
                    nue.setAttribute("value", text);
                } else if (el.getLocalName().equals("property-file")) {
                    String text = Util.findText((Element)el);
                    if (!$assertionsDisabled && text == null) {
                        throw new AssertionError();
                    }
                    nue.setAttribute("file", text);
                } else if (!$assertionsDisabled) {
                    throw new AssertionError(el);
                }
                antProject.appendChild(nue);
            }
        }
    }

    void ensureImports(Element antProject, String origScriptPath) throws IOException, SAXException {
        String basedir;
        String importPath;
        File origScript;
        if (antProject.getAttribute("basedir").length() > 0) {
            return;
        }
        String origScriptPathEval = this.evaluator.evaluate(origScriptPath);
        if (origScriptPathEval == null) {
            return;
        }
        String origScriptURI = this.helper.resolveFile(origScriptPathEval).toURI().toString();
        Document origScriptDocument = XMLUtil.parse((InputSource)new InputSource(origScriptURI), (boolean)false, (boolean)true, null, null);
        String origBasedir = origScriptDocument.getDocumentElement().getAttribute("basedir");
        if (origBasedir.length() == 0) {
            origBasedir = ".";
        }
        if ((origScript = new File(origScriptPathEval)).isAbsolute()) {
            importPath = origScriptPathEval;
            basedir = new File(origBasedir).isAbsolute() ? origBasedir : PropertyUtils.resolveFile((File)origScript.getParentFile(), (String)origBasedir).getAbsolutePath();
        } else {
            String prefix = "../";
            importPath = prefix + origScriptPathEval;
            if (new File(origBasedir).isAbsolute()) {
                basedir = origBasedir;
            } else {
                int slash = origScriptPathEval.replace(File.separatorChar, '/').lastIndexOf(47);
                basedir = slash == -1 ? prefix + origBasedir : prefix + origScriptPathEval.substring(0, slash + 1) + origBasedir;
                basedir = basedir.replaceAll("/\\.$", "");
            }
        }
        antProject.setAttribute("basedir", basedir);
        Element importEl = antProject.getOwnerDocument().createElement("import");
        importEl.setAttribute("file", importPath);
        antProject.appendChild(importEl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCustomScript(Document doc, String scriptPath) throws IOException {
        FileObject script = this.helper.getProjectDirectory().getFileObject(scriptPath);
        if (script == null) {
            script = FileUtil.createData((FileObject)this.helper.getProjectDirectory(), (String)scriptPath);
        }
        FileLock lock = script.lock();
        try {
            OutputStream os = script.getOutputStream(lock);
            try {
                XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    private Iterator compilationUnitsIterator() {
        Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
        if (java == null) {
            return Collections.EMPTY_SET.iterator();
        }
        List compilationUnits = Util.findSubElements((Element)java);
        return compilationUnits.iterator();
    }

    AntLocation findPackageRoot(Lookup context) {
        Iterator cuIt = this.compilationUnitsIterator();
        while (cuIt.hasNext()) {
            Element compilationUnitEl = (Element)cuIt.next();
            if (!$assertionsDisabled && !compilationUnitEl.getLocalName().equals("compilation-unit")) {
                throw new AssertionError(compilationUnitEl);
            }
            List packageRootNames = Classpaths.findPackageRootNames(compilationUnitEl);
            Map packageRootsByName = Classpaths.findPackageRootsByName(this.helper, this.evaluator, packageRootNames);
            Iterator it = packageRootsByName.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                FileObject root = (FileObject)entry.getValue();
                if (!JavaActions.containsSelectedJavaSources(root, context)) continue;
                return new AntLocation((String)entry.getKey(), root);
            }
        }
        return null;
    }

    static boolean containsSelectedJavaSources(FileObject root, Lookup context) {
        HashSet<FileObject> selection = new HashSet<FileObject>(context.lookup(new Lookup.Template(FileObject.class)).allInstances());
        Iterator selectionDO = context.lookup(new Lookup.Template(DataObject.class)).allInstances().iterator();
        while (selectionDO.hasNext()) {
            DataObject dob = (DataObject)selectionDO.next();
            selection.add(dob.getPrimaryFile());
        }
        if (selection.isEmpty()) {
            return false;
        }
        Iterator selIt = selection.iterator();
        while (selIt.hasNext()) {
            FileObject f = (FileObject)selIt.next();
            if (f.isData() && !f.hasExt("java")) {
                return false;
            }
            if (f == root || FileUtil.isParentOf((FileObject)root, (FileObject)f)) continue;
            return false;
        }
        return true;
    }

    private Element findCompilationUnit(String sources) {
        Iterator cuIt = this.compilationUnitsIterator();
        while (cuIt.hasNext()) {
            Element compilationUnitEl = (Element)cuIt.next();
            Iterator packageRoots = Util.findSubElements((Element)compilationUnitEl).iterator();
            while (packageRoots.hasNext()) {
                Element packageRoot = (Element)packageRoots.next();
                if (!packageRoot.getLocalName().equals("package-root") || !Util.findText((Element)packageRoot).equals(sources)) continue;
                return compilationUnitEl;
            }
        }
        return null;
    }

    String findClassesOutputDir(String sources) {
        Element compilationUnitEl = this.findCompilationUnit(sources);
        if (compilationUnitEl != null) {
            return this.findClassesOutputDir(compilationUnitEl);
        }
        return null;
    }

    private String findClassesOutputDir(Element compilationUnitEl) {
        Iterator builtTos = Util.findSubElements((Element)compilationUnitEl).iterator();
        while (builtTos.hasNext()) {
            URL destU;
            String rawtext;
            String evaltext;
            Element builtTo = (Element)builtTos.next();
            if (!builtTo.getLocalName().equals("built-to") || (evaltext = this.evaluator.evaluate(rawtext = Util.findText((Element)builtTo))) == null) continue;
            File dest = this.helper.resolveFile(evaltext);
            try {
                destU = dest.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            if (FileUtil.isArchiveFile((URL)destU)) continue;
            return rawtext;
        }
        return null;
    }

    String findSourceLevel(String sources) {
        Element sourceLevel;
        Element compilationUnitEl = this.findCompilationUnit(sources);
        if (compilationUnitEl != null && (sourceLevel = Util.findElement((Element)compilationUnitEl, (String)"source-level", (String)"http://www.netbeans.org/ns/freeform-project-java/2")) != null) {
            return Util.findText((Element)sourceLevel);
        }
        return null;
    }

    String findCompileClasspath(String sources) {
        Element compilationUnitEl = this.findCompilationUnit(sources);
        if (compilationUnitEl != null) {
            Iterator classpaths = Util.findSubElements((Element)compilationUnitEl).iterator();
            while (classpaths.hasNext()) {
                String mode;
                Element classpath = (Element)classpaths.next();
                if (!classpath.getLocalName().equals("classpath") || !(mode = classpath.getAttribute("mode")).equals("compile")) continue;
                return Util.findText((Element)classpath);
            }
        }
        return null;
    }

    void addBinding(String command, String scriptPath, String target, String propertyName, String dir, String pattern, String format, String separator) throws IOException {
        Element data = this.helper.getPrimaryConfigurationData(true);
        Element ideActions = Util.findElement((Element)data, (String)"ide-actions", (String)NS_GENERAL);
        if (ideActions == null) {
            ideActions = data.getOwnerDocument().createElementNS(NS_GENERAL, "ide-actions");
            Util.appendChildElement((Element)data, (Element)ideActions, (String[])rootElementsOrder);
        }
        Document doc = data.getOwnerDocument();
        Element action = doc.createElementNS(NS_GENERAL, "action");
        action.setAttribute("name", command);
        Element script = doc.createElementNS(NS_GENERAL, "script");
        script.appendChild(doc.createTextNode(scriptPath));
        action.appendChild(script);
        Element targetEl = doc.createElementNS(NS_GENERAL, "target");
        targetEl.appendChild(doc.createTextNode(target));
        action.appendChild(targetEl);
        if (propertyName != null) {
            Element context = doc.createElementNS(NS_GENERAL, "context");
            Element property = doc.createElementNS(NS_GENERAL, "property");
            property.appendChild(doc.createTextNode(propertyName));
            context.appendChild(property);
            Element folder = doc.createElementNS(NS_GENERAL, "folder");
            folder.appendChild(doc.createTextNode(dir));
            context.appendChild(folder);
            if (pattern != null) {
                Element patternEl = doc.createElementNS(NS_GENERAL, "pattern");
                patternEl.appendChild(doc.createTextNode(pattern));
                context.appendChild(patternEl);
            }
            Element formatEl = doc.createElementNS(NS_GENERAL, "format");
            formatEl.appendChild(doc.createTextNode(format));
            context.appendChild(formatEl);
            Element arity = doc.createElementNS(NS_GENERAL, "arity");
            if (separator != null) {
                Element separatorEl = doc.createElementNS(NS_GENERAL, "separated-files");
                separatorEl.appendChild(doc.createTextNode(separator));
                arity.appendChild(separatorEl);
            } else {
                arity.appendChild(doc.createElementNS(NS_GENERAL, "one-file-only"));
            }
            context.appendChild(arity);
            action.appendChild(context);
        } else {
            Element contextMenu;
            Element view = Util.findElement((Element)data, (String)"view", (String)NS_GENERAL);
            if (view != null && (contextMenu = Util.findElement((Element)view, (String)"context-menu", (String)NS_GENERAL)) != null) {
                Element ideAction = doc.createElementNS(NS_GENERAL, "ide-action");
                ideAction.setAttribute("name", command);
                contextMenu.appendChild(ideAction);
            }
        }
        ideActions.appendChild(action);
        this.helper.putPrimaryConfigurationData(data, true);
        ProjectManager.getDefault().saveProject(this.project);
    }

    private void jumpToBuildScript(String scriptPath, String target) {
        this.jumpToFile(scriptPath, target, "target", "name");
    }

    private void jumpToBinding(String command) {
        this.jumpToFile("nbproject/project.xml", command, "action", "name");
    }

    private void jumpToFile(String path, String match, String elementLocalName, String elementAttributeName) {
        DataObject fileDO;
        int line;
        FileObject file = this.helper.getProjectDirectory().getFileObject(path);
        if (file == null) {
            return;
        }
        try {
            line = JavaActions.findLine(file, match, elementLocalName, elementAttributeName);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return;
        }
        if (line == -1) {
            line = 0;
        }
        try {
            fileDO = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        LineCookie lines = (LineCookie)fileDO.getCookie(LineCookie.class);
        if (lines != null) {
            try {
                lines.getLineSet().getCurrent(line).show(2);
            }
            catch (IndexOutOfBoundsException e) {
                ErrorManager.getDefault().getInstance(JavaActions.class.getName()).log(16, e + " [file=" + file + " match=" + match + " line=" + line + "]");
                lines.getLineSet().getCurrent(0).show(2);
            }
        }
    }

    static final int findLine(FileObject file, String match, String elementLocalName, String elementAttributeName) throws IOException, SAXException, ParserConfigurationException {
        InputSource in = new InputSource(file.getURL().toString());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        int[] line = new int[]{-1};
        class Handler
        extends DefaultHandler {
            private Locator locator;
            private final /* synthetic */ int[] val$line;
            private final /* synthetic */ String val$elementLocalName;
            private final /* synthetic */ String val$match;
            private final /* synthetic */ String val$elementAttributeName;

            Handler(int[] nArray, String string, String string2, String string3) {
                this.val$line = nArray;
                this.val$elementLocalName = string;
                this.val$match = string2;
                this.val$elementAttributeName = string3;
            }

            public void setDocumentLocator(Locator l) {
                this.locator = l;
            }

            public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                if (this.val$line[0] == -1 && localname.equals(this.val$elementLocalName) && this.val$match.equals(attr.getValue(this.val$elementAttributeName))) {
                    this.val$line[0] = this.locator.getLineNumber() - 1;
                }
            }
        }
        parser.parse(in, (DefaultHandler)new Handler(line, elementLocalName, match, elementAttributeName));
        return line[0];
    }

    Element findExistingBuildTarget(String command) throws IOException, SAXException {
        String targetName;
        String[] binding = this.findCommandBinding(command);
        if (binding == null) {
            return null;
        }
        String scriptName = binding[0];
        if (!$assertionsDisabled && scriptName == null) {
            throw new AssertionError();
        }
        if (binding.length == 1) {
            targetName = null;
        } else if (binding.length == 2) {
            targetName = binding[1];
        } else {
            return null;
        }
        String scriptPath = this.evaluator.evaluate(scriptName);
        if (scriptPath == null) {
            return null;
        }
        File scriptFile = this.helper.resolveFile(scriptPath);
        String scriptURI = scriptFile.toURI().toString();
        Document doc = XMLUtil.parse((InputSource)new InputSource(scriptURI), (boolean)false, (boolean)true, null, null);
        if (targetName == null && (targetName = doc.getDocumentElement().getAttribute("default")) == null) {
            return null;
        }
        Iterator targets = Util.findSubElements((Element)doc.getDocumentElement()).iterator();
        while (targets.hasNext()) {
            Element target = (Element)targets.next();
            if (!target.getLocalName().equals("target") || !targetName.equals(target.getAttribute("name"))) continue;
            return target;
        }
        return null;
    }

    String[] findCommandBinding(String command) {
        Element data = this.helper.getPrimaryConfigurationData(true);
        Element ideActions = Util.findElement((Element)data, (String)"ide-actions", (String)NS_GENERAL);
        if (ideActions == null) {
            return null;
        }
        String scriptName = "build.xml";
        Iterator actions = Util.findSubElements((Element)ideActions).iterator();
        while (actions.hasNext()) {
            Element action = (Element)actions.next();
            if (!$assertionsDisabled && !action.getLocalName().equals("action")) {
                throw new AssertionError();
            }
            if (!action.getAttribute("name").equals(command)) continue;
            Element script = Util.findElement((Element)action, (String)"script", (String)NS_GENERAL);
            if (script != null) {
                scriptName = Util.findText((Element)script);
            }
            ArrayList<String> scriptPlusTargetNames = new ArrayList<String>();
            scriptPlusTargetNames.add(scriptName);
            Iterator targets = Util.findSubElements((Element)action).iterator();
            while (targets.hasNext()) {
                Element target = (Element)targets.next();
                if (!target.getLocalName().equals("target")) continue;
                scriptPlusTargetNames.add(Util.findText((Element)target));
            }
            return scriptPlusTargetNames.toArray(new String[scriptPlusTargetNames.size()]);
        }
        return null;
    }

    Element targetUsesTaskExactlyOnce(Element target, String taskName) {
        Iterator tasks = Util.findSubElements((Element)target).iterator();
        Element foundTask = null;
        while (tasks.hasNext()) {
            Element task = (Element)tasks.next();
            if (!task.getLocalName().equals(taskName)) continue;
            if (foundTask != null) {
                return null;
            }
            foundTask = task;
        }
        return foundTask;
    }

    static {
        $assertionsDisabled = !JavaActions.class.desiredAssertionStatus();
        ACTIONS = new String[]{"compile.single", "debug"};
        DEBUG_VM_ARGS = new String[]{"-Xdebug", "-Xnoagent", "-Djava.compiler=none", "-Xrunjdwp:transport=dt_socket,address=${jpda.address}"};
        rootElementsOrder = new String[]{"name", "properties", "folders", "ide-actions", "export", "view", "subprojects"};
    }

    static final class AntLocation {
        public final String virtual;
        public final FileObject physical;

        public AntLocation(String virtual, FileObject physical) {
            this.virtual = virtual;
            this.physical = physical;
        }

        public String toString() {
            return "AntLocation[" + this.virtual + "=" + this.physical + "]";
        }
    }
}

