/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

final class SourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation,
AntProjectListener {
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private AuxiliaryConfiguration aux;
    private Map roots = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SourceForBinaryQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
        helper.addAntProjectListener((AntProjectListener)this);
    }

    private void refresh() {
        this.roots = null;
    }

    public synchronized SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        if (this.roots == null) {
            this.roots = new HashMap();
            Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/2", true);
            if (java == null) {
                return null;
            }
            List compilationUnits = Util.findSubElements((Element)java);
            Iterator it = compilationUnits.iterator();
            while (it.hasNext()) {
                Element compilationUnitEl = (Element)it.next();
                if (!$assertionsDisabled && !compilationUnitEl.getLocalName().equals("compilation-unit")) {
                    throw new AssertionError(compilationUnitEl);
                }
                List binaries = this.findBinaries(compilationUnitEl);
                if (binaries.isEmpty()) continue;
                List packageRoots = Classpaths.findPackageRoots(this.helper, this.evaluator, compilationUnitEl);
                FileObject[] sources = packageRoots.toArray(new FileObject[packageRoots.size()]);
                Iterator it2 = binaries.iterator();
                while (it2.hasNext()) {
                    URL u = (URL)it2.next();
                    FileObject[] orig = (FileObject[])this.roots.get(u);
                    if (orig != null) {
                        FileObject[] merged = new FileObject[orig.length + sources.length];
                        System.arraycopy(orig, 0, merged, 0, orig.length);
                        System.arraycopy(sources, 0, merged, orig.length, sources.length);
                        sources = merged;
                    }
                    this.roots.put(u, sources);
                }
            }
        }
        if (!$assertionsDisabled && this.roots == null) {
            throw new AssertionError();
        }
        FileObject[] sources = (FileObject[])this.roots.get(binaryRoot);
        return sources == null ? null : new Result(sources);
    }

    private List findBinaries(Element compilationUnitEl) {
        List builtToEls = Util.findSubElements((Element)compilationUnitEl);
        ArrayList<URL> binaries = new ArrayList<URL>(builtToEls.size());
        Iterator it = builtToEls.iterator();
        while (it.hasNext()) {
            URL buildProductURL;
            block9: {
                String text;
                String textEval;
                Element builtToEl = (Element)it.next();
                if (!builtToEl.getLocalName().equals("built-to") || (textEval = this.evaluator.evaluate(text = Util.findText((Element)builtToEl))) == null) continue;
                File buildProduct = this.helper.resolveFile(textEval);
                try {
                    buildProductURL = buildProduct.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)e);
                    }
                    continue;
                }
                if (FileUtil.isArchiveFile((URL)buildProductURL)) {
                    buildProductURL = FileUtil.getArchiveRoot((URL)buildProductURL);
                } else if (!buildProduct.exists() && !buildProductURL.toExternalForm().endsWith("/")) {
                    try {
                        buildProductURL = new URL(buildProductURL.toExternalForm() + "/");
                    }
                    catch (MalformedURLException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError((Object)e);
                    }
                }
            }
            binaries.add(buildProductURL);
        }
        return binaries;
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.refresh();
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    static {
        $assertionsDisabled = !SourceForBinaryQueryImpl.class.desiredAssertionStatus();
    }

    private static class Result
    implements SourceForBinaryQuery.Result {
        private FileObject[] ret;

        public Result(FileObject[] ret) {
            this.ret = ret;
        }

        public FileObject[] getRoots() {
            return this.ret;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

