/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;

public final class JSFPaletteUtilities {
    public static void insert(String s, JTextComponent target) throws BadLocationException {
        JSFPaletteUtilities.insert(s, target, true);
    }

    public static void insert(String s, JTextComponent target, boolean reformat) throws BadLocationException {
        Document doc = target.getDocument();
        if (doc == null) {
            return;
        }
        if (s == null) {
            s = "";
        }
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).atomicLock();
        }
        int start = JSFPaletteUtilities.insert(s, target, doc);
        if (reformat && start >= 0 && doc instanceof BaseDocument) {
            int end = start + s.length();
            Formatter f = ((BaseDocument)doc).getFormatter();
            f.reformat((BaseDocument)doc, start, end);
        }
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).atomicUnlock();
        }
    }

    private static int insert(String s, JTextComponent target, Document doc) throws BadLocationException {
        int start = -1;
        try {
            Caret caret = target.getCaret();
            int p0 = Math.min(caret.getDot(), caret.getMark());
            int p1 = Math.max(caret.getDot(), caret.getMark());
            doc.remove(p0, p1 - p0);
            start = caret.getDot();
            doc.insertString(start, s, null);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return start;
    }
}

