/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.config.model.FacesConfig;
import org.netbeans.modules.web.jsf.config.model.ManagedBean;
import org.netbeans.modules.web.jsf.editor.JSFEditorUtilities;
import org.netbeans.modules.web.jsf.wizards.ManagedBeanPanel;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class ManagedBeanIterator
implements TemplateWizard.Iterator {
    private int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient boolean debug = false;

    public void initialize(TemplateWizard wizard) {
        if (this.debug) {
            this.log("initialize");
        }
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        DataFolder targetFolder = null;
        try {
            targetFolder = wizard.getTargetFolder();
        }
        catch (IOException ex) {
            targetFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        }
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (this.debug) {
            this.log("\tproject: " + project);
            this.log("\ttargetFolder: " + targetFolder);
            this.log("\tsourceGroups.length: " + sourceGroups.length);
        }
        ManagedBeanPanel secondPanel = new ManagedBeanPanel(project, (WizardDescriptor)wizard);
        WizardDescriptor.Panel javaPanel = sourceGroups.length == 0 ? Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)secondPanel) : JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)secondPanel);
        this.panels = new WizardDescriptor.Panel[]{javaPanel};
        Object prop = wizard.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            JComponent jc = (JComponent)this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = jc.getName();
            }
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wizard) {
        this.panels = null;
    }

    public Set instantiate(TemplateWizard wizard) throws IOException {
        if (this.debug) {
            this.log("instantiate");
        }
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)wizard);
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, Templates.getTargetName((WizardDescriptor)wizard));
        String configFile = (String)wizard.getProperty("ConfigFile");
        Project project = Templates.getProject((WizardDescriptor)wizard);
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        dir = wm.getDocumentBase();
        FileObject fo = dir.getFileObject(configFile);
        JSFConfigDataObject configDO = (JSFConfigDataObject)DataObject.find((FileObject)fo);
        FacesConfig config = configDO.getFacesConfig();
        ManagedBean bean = config.newManagedBean();
        String targetName = Templates.getTargetName((WizardDescriptor)wizard);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
        for (int i = 0; i < groups.length && packageName == null && (packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder)) == null; ++i) {
        }
        packageName = packageName != null ? packageName.replace('/', '.') : "";
        String className = null;
        className = packageName.length() > 0 ? packageName + "." + targetName : targetName;
        bean.setManagedBeanName(this.getUniqueName(targetName, config));
        bean.setManagedBeanClass(className);
        bean.setManagedBeanScope((String)wizard.getProperty("Scope"));
        String description = (String)wizard.getProperty("Description");
        if (description != null && description.length() > 0) {
            String newLine = System.getProperty("line.separator");
            bean.setDescription(new String[]{newLine + description + newLine});
        }
        config.addManagedBean(bean);
        BaseDocument doc = (BaseDocument)configDO.getEditorSupport().getDocument();
        if (doc == null) {
            ((OpenCookie)configDO.getCookie(OpenCookie.class)).open();
            doc = (BaseDocument)configDO.getEditorSupport().getDocument();
        }
        JSFEditorUtilities.writeBean(doc, (BaseBean)bean, "managed-bean");
        configDO.getEditorSupport().saveDocument();
        return Collections.singleton(dobj);
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public String name() {
        return NbBundle.getMessage(ManagedBeanIterator.class, (String)"TITLE_x_of_y", (Object)new Integer(this.index + 1), (Object)new Integer(this.panels.length));
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private void log(String message) {
        System.out.println("ActionIterator:: \t" + message);
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    private void replaceInDocument(Document document, String replaceFrom, String replaceTo) {
        AbstractDocument doc = (AbstractDocument)document;
        int len = replaceFrom.length();
        try {
            String content = doc.getText(0, doc.getLength());
            int index = content.lastIndexOf(replaceFrom);
            while (index >= 0) {
                doc.replace(index, len, replaceTo, null);
                content = content.substring(0, index);
                index = content.lastIndexOf(replaceFrom);
            }
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
    }

    private String getUniqueName(String original, FacesConfig config) {
        String value = original;
        ManagedBean[] beans = config.getManagedBean();
        int index = 0;
        int count = 0;
        while (index < beans.length) {
            if (!beans[index].getManagedBeanName().equals(value)) {
                ++index;
                continue;
            }
            index = 0;
            value = original + ++count;
        }
        return value;
    }
}

