/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.ObjectResolver;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.memoryimpl.MultivaluedIndexImpl;
import org.netbeans.mdr.persistence.memoryimpl.MultivaluedOrderedIndexImpl;
import org.netbeans.mdr.persistence.memoryimpl.PrimaryIndexImpl;
import org.netbeans.mdr.persistence.memoryimpl.SinglevaluedIndexImpl;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class StorageImpl
implements Storage {
    static final String PRIMARY_INDEX_NAME = "PI";
    private static final int INDEX_SINGLEVALUED = 1;
    private static final int INDEX_MULTIVALUED = 2;
    private static final int INDEX_ORDERED = 3;
    private final HashMap maps = new HashMap();
    private final String storageId;
    private final String fileName;
    private PrimaryIndexImpl primaryIndex;
    private int lastMofId = 0;
    private Set newIndexes = new HashSet();
    private HashMap removedIndexes = new HashMap();

    public StorageImpl(String name, String fileName) {
        this.storageId = name;
        this.fileName = fileName;
    }

    public void writeMOFID(OutputStream outputStream, MOFID mofid) throws StorageException {
        try {
            if (this.storageId.equals(mofid.getStorageID())) {
                IOUtils.writeString(outputStream, null);
            } else {
                IOUtils.writeString(outputStream, mofid.getStorageID());
            }
            IOUtils.writeLong(outputStream, mofid.getSerialNumber());
        }
        catch (IOException ioException) {
            throw new StorageIOException(ioException);
        }
    }

    public MOFID readMOFID(InputStream inputStream) throws StorageException {
        try {
            String storageId = IOUtils.readString(inputStream);
            if (storageId == null) {
                storageId = this.storageId;
            }
            long serial = IOUtils.readLong(inputStream);
            return new MOFID(serial, storageId);
        }
        catch (IOException ioException) {
            throw new StorageIOException(ioException);
        }
    }

    public synchronized void create(boolean replace, ObjectResolver resolver) throws StorageException {
        if (this.fileName != null) {
            if (!replace && this.exists()) {
                throw new StorageBadRequestException("Storage already exists");
            }
            new File(this.getName()).delete();
        }
        this.createPrimaryIndex();
    }

    public synchronized void close() throws StorageException {
        this.shutDown();
    }

    public synchronized boolean delete() throws StorageException {
        return new File(this.getName()).delete();
    }

    public String getName() {
        return this.fileName + ".mem";
    }

    public String getStorageId() {
        return this.storageId;
    }

    public synchronized long getSerialNumber() {
        return this.lastMofId++;
    }

    public synchronized boolean exists() throws StorageException {
        return new File(this.getName()).exists();
    }

    public synchronized void open(boolean createOnNoExist, ObjectResolver resolver) throws StorageException {
        this.createPrimaryIndex();
        if (this.fileName != null) {
            try {
                if (!this.exists() && !createOnNoExist) {
                    throw new StorageBadRequestException("Storage " + this.getName() + " does not exist.");
                }
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.getName()));
                this.lastMofId = IOUtils.readInt(is);
                String id = IOUtils.readString(is);
                if (!this.storageId.equals(id)) {
                    throw new StoragePersistentDataException("Invalid storage id in the persistent file: " + id + " (expected: " + this.storageId + ")");
                }
                this.primaryIndex.read(is);
                int size = IOUtils.readInt(is);
                for (int i = 0; i < size; ++i) {
                    Streamable index;
                    switch (IOUtils.readInt(is)) {
                        case 1: {
                            index = new SinglevaluedIndexImpl();
                            break;
                        }
                        case 2: {
                            index = new MultivaluedOrderedIndexImpl();
                            break;
                        }
                        case 3: {
                            index = new MultivaluedOrderedIndexImpl();
                            break;
                        }
                        default: {
                            throw new StoragePersistentDataException("Unknown type of index.");
                        }
                    }
                    index.read(is);
                    this.maps.put(((Index)((Object)index)).getName(), index);
                }
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException && createOnNoExist) {
                    return;
                }
                throw (StorageIOException)Logger.getDefault().annotate((Throwable)new StorageIOException(e), (Throwable)e);
            }
        }
    }

    public synchronized void objectStateWillChange(Object key) throws StorageException {
        this.primaryIndex.willChange(key);
    }

    public synchronized void objectStateChanged(Object key) throws StorageException {
        this.primaryIndex.changed(key);
    }

    public synchronized void rollBackChanges() throws StorageException {
        Iterator<Object> iter = this.newIndexes.iterator();
        while (iter.hasNext()) {
            this.maps.remove(iter.next());
        }
        for (String name : this.removedIndexes.keySet()) {
            this.maps.put(name, this.removedIndexes.get(name));
        }
        iter = this.maps.entrySet().iterator();
        while (iter.hasNext()) {
            Object index = ((Map.Entry)iter.next()).getValue();
            if (index instanceof SinglevaluedIndexImpl) {
                ((SinglevaluedIndexImpl)index).rollBackChanges();
                continue;
            }
            if (!(index instanceof MultivaluedIndexImpl)) continue;
            ((MultivaluedIndexImpl)index).rollBackChanges();
        }
        this.primaryIndex.rollBackChanges();
    }

    synchronized void serialize() throws StorageException {
        if (this.fileName == null) {
            throw new StorageBadRequestException("No storage file name specified");
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.getName()));
            IOUtils.writeInt(out, this.lastMofId);
            IOUtils.writeString(out, this.storageId);
            this.primaryIndex.write(out);
            IOUtils.writeInt(out, this.maps.size());
            for (Index index : this.maps.values()) {
                if (index instanceof SinglevaluedIndexImpl) {
                    ((OutputStream)out).write(1);
                } else if (index instanceof MultivaluedOrderedIndexImpl) {
                    ((OutputStream)out).write(3);
                } else if (index instanceof MultivaluedIndexImpl) {
                    ((OutputStream)out).write(2);
                } else {
                    throw new DebugException("Invalid index class: " + index.getClass().getName());
                }
                ((Streamable)((Object)index)).write(out);
            }
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw (StorageIOException)Logger.getDefault().annotate((Throwable)new StorageIOException(e), (Throwable)e);
        }
    }

    public synchronized void shutDown() throws StorageException {
        this.commitChanges();
    }

    public synchronized void commitChanges() throws StorageException {
        this.newIndexes.clear();
        this.removedIndexes.clear();
        Iterator iter = this.maps.entrySet().iterator();
        while (iter.hasNext()) {
            Object index = iter.next().getValue();
            if (index instanceof SinglevaluedIndexImpl) {
                ((SinglevaluedIndexImpl)index).commitChanges();
                continue;
            }
            if (!(index instanceof MultivaluedIndexImpl)) continue;
            ((MultivaluedIndexImpl)index).commitChanges();
        }
        this.primaryIndex.commitChanges();
    }

    public synchronized SinglevaluedIndex getSinglevaluedIndex(String name) throws StorageException {
        return (SinglevaluedIndex)this.getIndex(name);
    }

    public synchronized MultivaluedIndex getMultivaluedIndex(String name) throws StorageException {
        return (MultivaluedIndex)this.getIndex(name);
    }

    public synchronized MultivaluedOrderedIndex getMultivaluedOrderedIndex(String name) throws StorageException {
        return (MultivaluedOrderedIndex)this.getIndex(name);
    }

    public synchronized void dropIndex(String name) throws StorageException {
        Object index = this.maps.remove(name);
        if (index != null && !this.newIndexes.remove(name)) {
            this.removedIndexes.put(name, index);
        }
    }

    private synchronized void addIndex(String name, Index index) throws StorageException {
        this.maps.put(name, index);
        this.newIndexes.add(name);
    }

    public synchronized SinglevaluedIndex createSinglevaluedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType) throws StorageException {
        if (valueType.equals(Storage.EntryType.STREAMABLE)) {
            throw new StorageBadRequestException("Cannot create another primary index with STREAMABLE value type.");
        }
        SinglevaluedIndexImpl sm = new SinglevaluedIndexImpl(name, this, keyType, valueType);
        this.addIndex(name, sm);
        return sm;
    }

    public synchronized MultivaluedOrderedIndex createMultivaluedOrderedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) throws StorageException {
        MultivaluedOrderedIndexImpl sm = new MultivaluedOrderedIndexImpl(name, this, keyType, valueType, unique);
        this.addIndex(name, sm);
        return sm;
    }

    public synchronized MultivaluedIndex createMultivaluedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) throws StorageException {
        MultivaluedOrderedIndexImpl sm = new MultivaluedOrderedIndexImpl(name, this, keyType, valueType, unique);
        this.addIndex(name, sm);
        return sm;
    }

    public synchronized SinglevaluedIndex getPrimaryIndex() throws StorageException {
        return this.primaryIndex;
    }

    private void createPrimaryIndex() throws StorageException {
        this.primaryIndex = new PrimaryIndexImpl(this);
    }

    public synchronized Index getIndex(String name) throws StorageException {
        return (Index)this.maps.get(name);
    }
}

