/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.cookies;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.ValidateXMLCookie;
import org.netbeans.modules.xsl.cookies.Util;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.xml.sax.InputSource;

public class ValidateXSLSupport
implements ValidateXMLCookie {
    private final InputSource inputSource;
    private CookieObserver console;
    private int fatalErrors;
    private int errors;

    public ValidateXSLSupport(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateXML(CookieObserver l) {
        try {
            this.console = l;
            boolean fatalErrors = false;
            boolean errors = false;
            String checkedFile = this.inputSource.getSystemId();
            this.sendMessage(Util.THIS.getString("MSG_checking", checkedFile));
            XslErrorListener errorListener = new XslErrorListener();
            try {
                SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
                factory.setErrorListener(errorListener);
                TransformerHandler transformerHandler = factory.newTransformerHandler(new SAXSource(this.inputSource));
            }
            catch (TransformerException ex) {
                CookieMessage message = new CookieMessage(ex.getLocalizedMessage(), 3, (Object)new DefaultXMLProcessorDetail(ex));
                this.sendMessage(message);
            }
            boolean bl = !errors && !fatalErrors;
            return bl;
        }
        finally {
            this.console = null;
        }
    }

    private void sendMessage(String message) {
        if (this.console != null) {
            this.console.receive(new CookieMessage(message));
        }
    }

    private void sendMessage(CookieMessage message) {
        if (this.console != null) {
            this.console.receive(message);
        }
    }

    private class XslErrorListener
    implements ErrorListener {
        private XslErrorListener() {
        }

        public void error(TransformerException ex) throws TransformerException {
            if (ValidateXSLSupport.this.errors++ == this.getMaxErrorCount()) {
                String msg = Util.THIS.getString("MSG_too_many_errs");
                ValidateXSLSupport.this.sendMessage(msg);
                throw ex;
            }
            CookieMessage message = new CookieMessage(ex.getLocalizedMessage(), 2, (Object)new DefaultXMLProcessorDetail(ex));
            ValidateXSLSupport.this.sendMessage(message);
        }

        public void fatalError(TransformerException ex) throws TransformerException {
            ValidateXSLSupport.this.fatalErrors++;
            CookieMessage message = new CookieMessage(ex.getLocalizedMessage(), 3, (Object)new DefaultXMLProcessorDetail(ex));
            ValidateXSLSupport.this.sendMessage(message);
        }

        public void warning(TransformerException ex) throws TransformerException {
            CookieMessage message = new CookieMessage(ex.getLocalizedMessage(), 1, (Object)new DefaultXMLProcessorDetail(ex));
            ValidateXSLSupport.this.sendMessage(message);
        }

        private int getMaxErrorCount() {
            return 20;
        }
    }
}

