/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.ui;

import java.awt.Image;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.xml.core.lib.AbstractUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;

class Util
extends AbstractUtil {
    public static final Util THIS = new Util();
    static Node icons = null;

    private Util() {
    }

    static Node projectView() {
        Children.SortedArray kids = new Children.SortedArray();
        kids.setComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Node)o1).getDisplayName().compareToIgnoreCase(((Node)o2).getDisplayName());
            }
        });
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int pi = 0; pi < projects.length; ++pi) {
            Project project = projects[pi];
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] group = sources.getSourceGroups("generic");
            Arrays.sort(group, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((SourceGroup)o1).getDisplayName().compareToIgnoreCase(((SourceGroup)o2).getDisplayName());
                }
            });
            for (int i = 0; i < group.length; ++i) {
                ErrorManager err;
                FileObject folder = group[i].getRootFolder();
                if (folder.isFolder()) {
                    kids.add(new Node[]{new FolderNode(folder, group[i])});
                    if (icons != null) continue;
                    try {
                        DataObject dobj = DataObject.find((FileObject)folder);
                        icons = dobj.getNodeDelegate();
                    }
                    catch (DataObjectNotFoundException e) {
                        err = ErrorManager.getDefault();
                        err.notify((Throwable)e);
                    }
                    continue;
                }
                try {
                    kids.add(new Node[]{new FilterNode(DataObject.find((FileObject)folder).getNodeDelegate())});
                    continue;
                }
                catch (DataObjectNotFoundException e) {
                    err = ErrorManager.getDefault();
                    err.notify((Throwable)e);
                }
            }
        }
        AbstractNode content = new AbstractNode((Children)kids){

            public void setName(String name) {
                super.setName(name);
                super.setIconBase("org/netbeans/modules/xsl/resources/repository");
            }
        };
        content.setName(THIS.getString("projects"));
        return content;
    }

    private static class FolderNode
    extends AbstractNode {
        private final FileObject fileObject;
        private SourceGroup group;

        public FolderNode(FileObject fileObject, SourceGroup root) {
            super((Children)new FolderContent(fileObject, root), Lookups.singleton((Object)fileObject));
            this.fileObject = fileObject;
            this.group = root;
        }

        public FolderNode(FileObject fileObject) {
            super((Children)new FolderContent(fileObject), Lookups.singleton((Object)fileObject));
            this.fileObject = fileObject;
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            return this.fileObject.getName();
        }

        public Image getIcon(int type) {
            if (icons != null) {
                return icons.getIcon(type);
            }
            return super.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            if (icons != null) {
                return icons.getOpenedIcon(type);
            }
            return super.getOpenedIcon(type);
        }

        private static class FolderContent
        extends Children.Keys {
            private final FileObject fileObject;
            private final SourceGroup group;

            public FolderContent(FileObject fileObject) {
                this(fileObject, null);
            }

            public FolderContent(FileObject fileObject, SourceGroup group) {
                this.fileObject = fileObject;
                this.group = group;
            }

            protected void addNotify() {
                FileObject[] fo = this.fileObject.getChildren();
                Arrays.sort(fo, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return ((FileObject)o1).getNameExt().compareToIgnoreCase(((FileObject)o2).getNameExt());
                    }
                });
                this.setKeys(Arrays.asList(fo));
            }

            protected void removeNotify() {
                this.setKeys(Collections.EMPTY_SET);
            }

            protected Node[] createNodes(Object key) {
                FileObject fo = (FileObject)key;
                if (this.group == null || this.group.contains(fo)) {
                    if (fo.isFolder()) {
                        return new Node[]{new FolderNode(fo)};
                    }
                    try {
                        return new Node[]{new FilterNode(DataObject.find((FileObject)fo).getNodeDelegate())};
                    }
                    catch (DataObjectNotFoundException e) {
                        ErrorManager err = ErrorManager.getDefault();
                        err.notify((Throwable)e);
                    }
                }
                return new Node[0];
            }
        }
    }
}

