/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.options;

import java.awt.Color;
import java.awt.Dimension;
import java.util.MissingResourceException;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.html.HTMLIndentEngine;
import org.netbeans.modules.editor.html.HTMLKit;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.OptionSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class HTMLOptions
extends BaseOptions {
    public static final String HTML = "html";
    public static final String COMPLETION_AUTO_POPUP_PROP = "completionAutoPopup";
    public static final String COMPLETION_AUTO_POPUP_DELAY_PROP = "completionAutoPopupDelay";
    public static final String COMPLETION_INSTANT_SUBSTITUTION_PROP = "completionInstantSubstitution";
    public static final String COMPLETION_LOWER_CASE_PROP = "completionLowerCase";
    private static final String HELP_ID = "editing.editor.html";
    public static final String JAVADOC_AUTO_POPUP_PROP = "javaDocAutoPopup";
    public static final String JAVADOC_BGCOLOR = "javaDocBGColor";
    public static final String JAVADOC_PREFERRED_SIZE_PROP = "javaDocPreferredSize";
    public static final String CODE_FOLDING_UPDATE_TIMEOUT_PROP = "codeFoldingUpdateInterval";
    public static final String CODE_FOLDING_ENABLE_PROP = "codeFoldingEnable";
    static final String[] HTML_PROP_NAMES = OptionSupport.mergeStringArrays((String[])BaseOptions.BASE_PROP_NAMES, (String[])new String[]{"completionAutoPopup", "completionAutoPopupDelay", "completionInstantSubstitution", "completionLowerCase", "javaDocAutoPopup", "javaDocPreferredSize", "javaDocBGColor", "codeFoldingUpdateInterval", "codeFoldingEnable"});
    static final long serialVersionUID = 75289734362748537L;

    public HTMLOptions() {
        super(HTMLKit.class, HTML);
    }

    public boolean getCompletionAutoPopup() {
        return this.getSettingBoolean("completion-auto-popup");
    }

    public void setCompletionAutoPopup(boolean v) {
        this.setSettingBoolean("completion-auto-popup", v, COMPLETION_AUTO_POPUP_PROP);
    }

    public int getCompletionAutoPopupDelay() {
        return this.getSettingInteger("completion-auto-popup-delay");
    }

    public void setCompletionAutoPopupDelay(int delay) {
        if (delay < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("completion-auto-popup-delay", delay, COMPLETION_AUTO_POPUP_DELAY_PROP);
    }

    public boolean getCompletionInstantSubstitution() {
        return this.getSettingBoolean("completion-instant-substitution");
    }

    public void setCompletionInstantSubstitution(boolean v) {
        this.setSettingBoolean("completion-instant-substitution", v, COMPLETION_INSTANT_SUBSTITUTION_PROP);
    }

    public boolean getCompletionLowerCase() {
        return this.getSettingBoolean("completion-lower-case");
    }

    public void setCompletionLowerCase(boolean v) {
        this.setSettingBoolean("completion-lower-case", v, COMPLETION_LOWER_CASE_PROP);
    }

    protected Class getDefaultIndentEngineClass() {
        return HTMLIndentEngine.class;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public boolean getJavaDocAutoPopup() {
        return this.getSettingBoolean("javadoc-auto-popup");
    }

    public void setJavaDocAutoPopup(boolean auto) {
        this.setSettingBoolean("javadoc-auto-popup", auto, JAVADOC_AUTO_POPUP_PROP);
    }

    public Color getJavaDocBGColor() {
        return (Color)this.getSettingValue("javadoc-bg-color");
    }

    public void setJavaDocBGColor(Color c) {
        this.setSettingValue("javadoc-bg-color", c, JAVADOC_BGCOLOR);
    }

    public Dimension getJavaDocPreferredSize() {
        return (Dimension)this.getSettingValue("javadoc-preferred-size");
    }

    public void setJavaDocPreferredSize(Dimension d) {
        this.setSettingValue("javadoc-preferred-size", d, JAVADOC_PREFERRED_SIZE_PROP);
    }

    public int getCodeFoldingUpdateInterval() {
        return this.getSettingInteger("code-folding-update-interval");
    }

    public void setCodeFoldingUpdateInterval(int timeout) {
        if (timeout < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("code-folding-update-interval", timeout, CODE_FOLDING_UPDATE_TIMEOUT_PROP);
    }

    public boolean getCodeFoldingEnable() {
        return this.getSettingBoolean("code-folding-enable");
    }

    public void setCodeFoldingEnable(boolean state) {
        this.setSettingBoolean("code-folding-enable", state, CODE_FOLDING_ENABLE_PROP);
    }

    protected String getString(String key) {
        try {
            return NbBundle.getMessage((Class)HTMLOptions.class, (String)key);
        }
        catch (MissingResourceException e) {
            return super.getString(key);
        }
    }
}

