/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;

public abstract class Attribute {
    public Type type;
    public static final Attribute[] emptyArray = new Attribute[0];
    static /* synthetic */ java.lang.Class class$com$sun$tools$javac$code$Attribute;

    public Attribute(Type type) {
        this.type = type;
    }

    public abstract void accept(Visitor var1);

    public static interface Visitor {
        public void visitConstant(Constant var1);

        public void visitClass(Class var1);

        public void visitCompound(Compound var1);

        public void visitArray(Array var1);

        public void visitEnum(Enum var1);

        public void visitError(Error var1);
    }

    public static class Error
    extends Attribute {
        public Error(Type type) {
            super(type);
        }

        public void accept(Visitor v) {
            v.visitError(this);
        }

        public String toString() {
            return "<error>";
        }
    }

    public static class Enum
    extends Attribute {
        public Symbol.VarSymbol value;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Enum(Type type, Symbol.VarSymbol value) {
            super(type);
            if (!$assertionsDisabled && value == null) {
                throw new AssertionError();
            }
            this.value = value;
        }

        public void accept(Visitor v) {
            v.visitEnum(this);
        }

        public String toString() {
            return this.value == null ? "null" : this.value.name.toString();
        }

        static {
            $assertionsDisabled = !(class$com$sun$tools$javac$code$Attribute == null ? (class$com$sun$tools$javac$code$Attribute = Attribute.class$("com.sun.tools.javac.code.Attribute")) : class$com$sun$tools$javac$code$Attribute).desiredAssertionStatus();
        }
    }

    public static class Array
    extends Attribute {
        public final Attribute[] values;

        public Array(Type type, Attribute[] values) {
            super(type);
            this.values = values;
        }

        public void accept(Visitor v) {
            v.visitArray(this);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("{");
            boolean first = true;
            Attribute[] arr$ = this.values;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Attribute value = arr$[i$];
                if (!first) {
                    buf.append(",");
                }
                first = false;
                buf.append(value);
            }
            buf.append("}");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Compound
    extends Attribute {
        public static final List<Compound> emptyList = new List();
        public final List<Pair<Symbol.MethodSymbol, Attribute>> values;

        public Compound(Type type, List<Pair<Symbol.MethodSymbol, Attribute>> values) {
            super(type);
            this.values = values;
        }

        @Override
        public void accept(Visitor v) {
            v.visitCompound(this);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("@");
            buf.append(this.type.tsym.fullName());
            buf.append("{");
            boolean first = true;
            List<Pair<Symbol.MethodSymbol, Attribute>> v = this.values;
            while (v.nonEmpty()) {
                Pair value = (Pair)v.head;
                if (!first) {
                    buf.append(",");
                }
                first = false;
                buf.append(((Symbol.MethodSymbol)value.fst).name);
                buf.append("=");
                buf.append(value.snd);
                v = v.tail;
            }
            buf.append("}");
            return buf.toString();
        }

        public Attribute member(Name member) {
            for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                if (((Symbol.MethodSymbol)pair.fst).name != member) continue;
                return (Attribute)pair.snd;
            }
            return null;
        }
    }

    public static class Class
    extends Attribute {
        public final Type type;

        public void accept(Visitor v) {
            v.visitClass(this);
        }

        public Class(Types types, Type type) {
            super(Class.makeClassType(types, type));
            this.type = type;
        }

        static Type makeClassType(Types types, Type type) {
            Type arg = type.isPrimitive() ? types.boxedClass((Type)type).type : types.erasure(type);
            return new Type.ClassType(types.syms.classType.outer(), Type.emptyList.prepend(arg), types.syms.classType.tsym);
        }

        public String toString() {
            return this.type + ".class";
        }
    }

    public static class Constant
    extends Attribute {
        public final Object value;

        public void accept(Visitor v) {
            v.visitConstant(this);
        }

        public Constant(Type type, Object value) {
            super(type);
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

