/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.util.Iterator;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;

public class RepositoryClassReader
extends ClassReader {
    private Name.Table names;
    private Symtab syms;
    private Types types;
    private Annotate annotate;
    private JavaClass javaClass;
    private JavaModelPackage repository;
    private boolean allowGenerics;

    public static void register(final Context context) {
        context.put(classReaderKey, new Context.Factory<ClassReader>(){

            @Override
            public ClassReader make() {
                return new RepositoryClassReader(context, true);
            }

            @Override
            public /* synthetic */ Object make() {
                return this.make();
            }
        });
    }

    protected RepositoryClassReader(Context context, boolean definitive) {
        super(context, definitive);
        this.names = Name.Table.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.annotate = Annotate.instance(context);
        try {
            this.repository = JavaMetamodel.getManager().getDefaultExtent();
            if (this.repository.getJavaPackage().resolvePackage("java.lang") == null) {
                this.repository = null;
                ErrorManager.getDefault().log(256, "GJAST: JDK not found on classpath - using default class reader.");
            }
        }
        catch (Throwable e) {
            System.err.println("NetBeans repository not found.");
            e.printStackTrace();
            this.repository = null;
        }
    }

    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (this.repository == null) {
            super.complete(sym);
        } else {
            if (sym.kind == 2) {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
                c.members_field = new Scope.ErrorScope(c);
                c.owner.complete();
                this.fillIn(c);
            } else if (sym.kind == 1) {
                Symbol.PackageSymbol p = (Symbol.PackageSymbol)sym;
                this.fillIn(p);
            }
            this.annotate.flush();
        }
    }

    private void fillIn(Symbol.ClassSymbol c) {
        ClassPath cpath = JavaMetamodel.getManager().getClassPath();
        this.javaClass = ClassIndex.getClassByFqn((String)c.fullname.toString(), (ClassPath)cpath);
        if (this.javaClass == null) {
            System.err.println("JMI lookup failure on class " + c.fullname.toString());
            String fn = RepositoryClassReader.externalizeFileName(c.flatname);
            throw new Symbol.CompletionFailure(c, Log.getLocalizedString("dot.class.not.found", new Object[]{fn}));
        }
        this.currentOwner = c;
        Resource resource = this.javaClass.getResource();
        String name = resource.getName();
        this.readClass(c);
    }

    void readClass(Symbol.ClassSymbol c) {
        Iterator i$;
        Type.ClassType ct = (Type.ClassType)c.type;
        c.members_field = new Scope(this.currentOwner);
        this.typevars = this.typevars.dup(c);
        if (ct.outer().tag == 10) {
            this.enterTypevars(ct.outer());
        }
        long flags = this.adjustClassFlags(this.javaClass.getModifiers());
        if (c.owner.kind == 1) {
            c.flags_field = flags;
        }
        if (ct.supertype_field == null) {
            if (this.javaClass.isInterface()) {
                ct.supertype_field = this.syms.objectType;
            } else {
                JavaClass scls = this.javaClass.getSuperClass();
                com.sun.tools.javac.code.Type type = ct.supertype_field = scls == null ? com.sun.tools.javac.code.Type.noType : this.getClassSymbol(scls).erasure(this.types);
            }
        }
        if (ct.interfaces_field == null) {
            ListBuffer<com.sun.tools.javac.code.Type> lb = new ListBuffer<com.sun.tools.javac.code.Type>();
            i$ = this.javaClass.getInterfaces().iterator();
            while (i$.hasNext()) {
                Object interfce = i$.next();
                lb.append(this.getClassSymbol((JavaClass)interfce).erasure(this.types));
            }
            ct.interfaces_field = lb.toList();
        }
        String srcfile = this.javaClass.getResource().getName();
        c.sourcefile = this.names.fromString(srcfile);
        i$ = this.javaClass.getContents().iterator();
        while (i$.hasNext()) {
            Object member = i$.next();
            Symbol sym = null;
            if (member instanceof Field) {
                sym = this.getFieldSymbol((Field)member);
            } else if (member instanceof CallableFeature) {
                sym = this.getMethodSymbol((CallableFeature)member);
            } else if (member instanceof JavaClass) {
                sym = this.getInnerClassSymbol(c, (JavaClass)member);
            }
            if (sym == null) continue;
            c.members_field.enter(sym);
        }
        this.typevars = this.typevars.leave();
    }

    private long adjustClassFlags(int jmiFlags) {
        return jmiFlags;
    }

    private long adjustFieldFlags(int jmiFlags) {
        return jmiFlags;
    }

    private long adjustMethodFlags(int jmiFlags) {
        long flags = jmiFlags;
        if ((flags & 0x40L) != 0L) {
            flags &= 0xFFFFFFFFFFFFFFBFL;
            flags |= 0x80000000L;
            if (!this.allowGenerics) {
                flags &= 0xFFFFFFFFFFFFEFFFL;
            }
        }
        if ((flags & 0x80L) != 0L) {
            flags &= 0xFFFFFFFFFFFFFF7FL;
            flags |= 0x400000000L;
        }
        return flags;
    }

    private Symbol.ClassSymbol getClassSymbol(JavaClass jcls) {
        RefFeatured owner = jcls.refImmediateComposite();
        if (owner instanceof JavaClass) {
            Name simpleName = this.names.fromString(jcls.getSimpleName());
            return this.enterClass(simpleName, this.getClassSymbol((JavaClass)owner));
        }
        return this.enterClass(this.names.fromString(jcls.getName()));
    }

    private Symbol.VarSymbol getFieldSymbol(Field f) {
        if (f.getName() == null) {
            return null;
        }
        long flags = this.adjustFieldFlags(f.getModifiers());
        Name name = this.names.fromString(f.getName());
        com.sun.tools.javac.code.Type type = this.findType((TypedElement)f);
        Symbol.VarSymbol v = new Symbol.VarSymbol(flags, name, type, this.currentOwner);
        return v;
    }

    private Symbol.MethodSymbol getMethodSymbol(CallableFeature meth) {
        String sname = meth.getName();
        if (sname == null && !(meth instanceof Constructor)) {
            return null;
        }
        long flags = this.adjustMethodFlags(meth.getModifiers());
        Name name = sname == null ? this.names.init : this.names.fromString(sname);
        com.sun.tools.javac.code.Type type = this.findType(meth);
        if (name == this.names.init && this.currentOwner.hasOuterInstance()) {
            type = new Type.MethodType(type.argtypes().tail, type.restype(), type.thrown(), this.syms.methodClass);
        }
        Symbol.MethodSymbol m = new Symbol.MethodSymbol(flags, name, type, this.currentOwner);
        Symbol prevOwner = this.currentOwner;
        this.currentOwner = m;
        this.currentOwner = prevOwner;
        return m;
    }

    private Symbol.ClassSymbol getInnerClassSymbol(Symbol.ClassSymbol outer, JavaClass jcls) {
        long flags = this.adjustClassFlags(jcls.getModifiers());
        Name name = this.names.fromString(jcls.getSimpleName());
        Symbol.ClassSymbol member = this.enterClass(name, outer);
        if ((flags & 8L) == 0L) {
            ((Type.ClassType)member.type).outer_field = outer.type;
        }
        member.flags_field = flags;
        return member;
    }

    private com.sun.tools.javac.code.Type findType(TypedElement element) {
        return this.findType(element.getType());
    }

    private com.sun.tools.javac.code.Type findType(CallableFeature element) {
        com.sun.tools.javac.code.Type retType = this.findType(element.getType());
        ListBuffer<com.sun.tools.javac.code.Type> thrown = new ListBuffer<com.sun.tools.javac.code.Type>();
        ListBuffer<com.sun.tools.javac.code.Type> parList = new ListBuffer<com.sun.tools.javac.code.Type>();
        Iterator i$ = element.getParameters().iterator();
        while (i$.hasNext()) {
            Object p = i$.next();
            Parameter parameter = (Parameter)p;
            parList.append(this.findType(parameter.getType()));
        }
        i$ = element.getExceptions().iterator();
        while (i$.hasNext()) {
            Object ex = i$.next();
            JavaClass exc = (JavaClass)ex;
            thrown.append(this.findType(exc));
        }
        return new Type.MethodType(parList.toList(), retType, thrown.toList(), this.syms.methodClass);
    }

    private com.sun.tools.javac.code.Type findType(JavaClass jcls) {
        RefFeatured owner = jcls.refImmediateComposite();
        if (owner instanceof JavaClass) {
            JavaClass ownerClass = (JavaClass)owner;
            return new Type.ClassType(this.findType(ownerClass), com.sun.tools.javac.code.Type.emptyList, this.getClassSymbol(jcls));
        }
        return this.getClassSymbol(jcls).erasure(this.types);
    }

    private com.sun.tools.javac.code.Type findType(Type t) {
        if (t instanceof JavaClass) {
            return this.findType((JavaClass)t);
        }
        if (t instanceof PrimitiveType) {
            PrimitiveTypeKind kind = ((PrimitiveType)t).getKind();
            if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)kind)) {
                return this.syms.booleanType;
            }
            if (PrimitiveTypeKindEnum.INT.equals((Object)kind)) {
                return this.syms.intType;
            }
            if (PrimitiveTypeKindEnum.CHAR.equals((Object)kind)) {
                return this.syms.charType;
            }
            if (PrimitiveTypeKindEnum.BYTE.equals((Object)kind)) {
                return this.syms.byteType;
            }
            if (PrimitiveTypeKindEnum.SHORT.equals((Object)kind)) {
                return this.syms.shortType;
            }
            if (PrimitiveTypeKindEnum.LONG.equals((Object)kind)) {
                return this.syms.longType;
            }
            if (PrimitiveTypeKindEnum.FLOAT.equals((Object)kind)) {
                return this.syms.floatType;
            }
            if (PrimitiveTypeKindEnum.DOUBLE.equals((Object)kind)) {
                return this.syms.doubleType;
            }
            return this.syms.voidType;
        }
        if (t instanceof Array) {
            Type el = ((Array)t).getType();
            return new Type.ArrayType(this.findType(el), (Symbol.TypeSymbol)this.syms.arrayClass);
        }
        throw new IllegalArgumentException(t.toString());
    }

    private void fillIn(Symbol.PackageSymbol p) {
        JavaPackageClass pkgCls;
        JavaPackage pkg;
        Name packageName;
        if (p.members_field == null) {
            p.members_field = new Scope(p);
        }
        if ((packageName = p.fullName()) == this.names.emptyPackage) {
            packageName = this.names.empty;
        }
        if ((pkg = (pkgCls = this.repository.getJavaPackage()).resolvePackage(packageName.toString())) == null) {
            System.err.println("JMI lookup failure on package " + packageName.toString());
            throw new Symbol.CompletionFailure(p, "package not found");
        }
        if ((p.flags_field & 0x800000L) == 0L) {
            Symbol q = p;
            while (q != null && q.kind == 1) {
                q.flags_field |= 0x800000L;
                q = q.owner;
            }
        }
        Iterator i$ = pkg.getResources().iterator();
        while (i$.hasNext()) {
            Object rsc = i$.next();
            Resource resource = (Resource)rsc;
            int seen = resource.getName().endsWith(".class") ? 0x2000000 : 0x4000000;
            Iterator i$2 = resource.getClassifiers().iterator();
            while (i$2.hasNext()) {
                Object classifier = i$2.next();
                JavaClass cls = (JavaClass)classifier;
                Name classname = this.names.fromString(cls.getSimpleName());
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)p.members_field.lookup((Name)classname).sym;
                if (c == null) {
                    c = this.enterClass(classname, p);
                    if (c.owner == p) {
                        p.members_field.enter(c);
                    }
                }
                c.flags_field |= (long)seen;
            }
        }
    }
}

