/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast.lite;

import com.sun.tools.javac.code.Source;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.netbeans.lib.gjast.lite.LayoutCharacters;
import org.netbeans.lib.java.parser.JScanner;
import org.netbeans.lib.java.parser.ParserTokens;

public class Scanner
implements LayoutCharacters,
JScanner,
ParserTokens {
    private static boolean scannerDebug;
    private boolean deprecatedFlag = false;
    private char[] sbuf = new char[128];
    private int sp;
    private char[] buf;
    private int bp;
    private int buflen;
    private int token;
    private int pos;
    private char ch;
    private int unicodeConversionBp = 0;
    private Source source;
    private static final ByteBufferCache byteBufferCache;
    private static String encodingName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String yytext() {
        return new String(this.sbuf, 0, this.sp);
    }

    public int yyhash() {
        int h = 0;
        for (int i = 0; i < this.sp; ++i) {
            h = 31 * h + this.sbuf[i];
        }
        return h;
    }

    private static Source getSource(String sourceLevel) {
        Source s;
        Source source = s = sourceLevel != null ? Source.lookup(sourceLevel) : null;
        if (s == null) {
            s = Source.DEFAULT;
        }
        return s;
    }

    public Scanner(char[] input, String sourceLevel) {
        this.source = Scanner.getSource(sourceLevel);
        if (!$assertionsDisabled && this.source == null) {
            throw new AssertionError();
        }
        this.buf = input;
        this.buflen = input.length - 1;
        this.buf[this.buflen] = 26;
        this.bp = -1;
        this.scanChar();
    }

    public Scanner(InputStream in, String sourceLevel) {
        try {
            ByteBuffer byteBuffer = Scanner.makeByteBuffer(in);
            CharBuffer charBuffer = Scanner.decode(byteBuffer);
            byteBufferCache.put(byteBuffer);
            this.source = Source.lookup(sourceLevel);
            if (!$assertionsDisabled && this.source == null) {
                throw new AssertionError();
            }
            this.buf = ((CharBuffer)charBuffer.compact().flip()).array();
            this.buflen = charBuffer.limit();
            this.buf[this.buflen] = 26;
            this.bp = -1;
            this.scanChar();
        }
        catch (IOException e) {
            System.out.println(e);
            this.token = 367;
        }
    }

    private static ByteBuffer makeByteBuffer(InputStream in) throws IOException {
        int limit = in.available();
        if (limit < 1024) {
            limit = 1024;
        }
        ByteBuffer result = byteBufferCache.get(limit);
        int position = 0;
        while (in.available() != 0) {
            int count;
            if (position >= limit) {
                result = ByteBuffer.allocate(limit <<= 1).put((ByteBuffer)result.flip());
            }
            if ((count = in.read(result.array(), position, limit - position)) < 0) break;
            result.position(position += count);
        }
        return (ByteBuffer)result.flip();
    }

    private static CharBuffer decode(ByteBuffer inbuf) {
        CoderResult result;
        CharsetDecoder decoder;
        try {
            Charset charset = Charset.forName(encodingName);
            decoder = charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.IGNORE).onUnmappableCharacter(CodingErrorAction.IGNORE);
        }
        catch (IllegalCharsetNameException e) {
            System.out.println(e);
            return null;
        }
        catch (UnsupportedCharsetException e) {
            System.out.println(e);
            return null;
        }
        float factor = decoder.averageCharsPerByte() * 0.8f + decoder.maxCharsPerByte() * 0.2f;
        CharBuffer dest = CharBuffer.allocate(10 + (int)((float)inbuf.remaining() * factor));
        while (true) {
            result = decoder.decode(inbuf, dest, true);
            dest.flip();
            if (result.isUnderflow()) {
                if (dest.limit() == dest.capacity()) {
                    dest = CharBuffer.allocate(dest.capacity() + 1).put(dest);
                    dest.flip();
                }
                return dest;
            }
            if (result.isOverflow()) {
                int newCapacity = 10 + dest.capacity() + (int)((float)inbuf.remaining() * decoder.maxCharsPerByte());
                dest = CharBuffer.allocate(newCapacity).put(dest);
                continue;
            }
            if (!result.isMalformed() && !result.isUnmappable()) break;
            inbuf.position(inbuf.position() + result.length());
            dest.position(dest.limit());
            dest.limit(dest.capacity());
            dest.put('\ufffd');
        }
        throw new AssertionError(result);
    }

    private int digit(int base) {
        char c = this.ch;
        int result = Character.digit(c, base);
        if (result >= 0 && c > '\u007f') {
            this.ch = "0123456789abcdef".charAt(result);
        }
        return result;
    }

    private void convertUnicode() {
        if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
            ++this.bp;
            this.ch = this.buf[this.bp];
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                } while (this.ch == 'u');
                int limit = this.bp + 3;
                if (limit < this.buflen) {
                    int d;
                    int code = d = this.digit(16);
                    while (this.bp < limit && d >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        d = this.digit(16);
                        code = (code << 4) + d;
                    }
                    if (d >= 0) {
                        this.ch = (char)code;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
            } else {
                --this.bp;
                this.ch = (char)92;
            }
        }
    }

    private void scanChar() {
        ++this.bp;
        this.ch = this.buf[this.bp];
        if (this.ch == '\\') {
            this.convertUnicode();
        }
    }

    private void scanCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void scanLitChar() {
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                this.scanChar();
            } else {
                this.scanChar();
                switch (this.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char leadch = this.ch;
                        int oct = this.digit(8);
                        this.scanChar();
                        if ('0' > this.ch || this.ch > '7') break;
                        oct = oct * 8 + this.digit(8);
                        this.scanChar();
                        if (leadch > '3' || '0' > this.ch || this.ch > '7') break;
                        oct = oct * 8 + this.digit(8);
                        this.scanChar();
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        this.scanChar();
                        break;
                    }
                }
            }
        } else if (this.bp != this.buflen) {
            this.scanChar();
        }
    }

    private void scanHexExponentAndSuffix() {
        if (this.ch == 'p' || this.ch == 'P') {
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
            }
        }
        if (this.ch == 'f' || this.ch == 'F') {
            this.scanChar();
            this.token = 276;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.scanChar();
            }
            this.token = 270;
        }
    }

    private void scanFraction() {
        while (this.digit(10) >= 0) {
            this.scanChar();
        }
        int sp1 = this.sp;
        if (this.ch == 'e' || this.ch == 'E') {
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                return;
            }
            this.sp = sp1;
        }
    }

    private void scanFractionAndSuffix() {
        this.scanFraction();
        if (this.ch == 'f' || this.ch == 'F') {
            this.scanChar();
            this.token = 276;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.scanChar();
            }
            this.token = 270;
        }
    }

    private void scanHexFractionAndSuffix(boolean seendigit) {
        this.scanChar();
        while (this.digit(16) >= 0) {
            seendigit = true;
            this.scanChar();
        }
        if (seendigit) {
            this.scanHexExponentAndSuffix();
        }
    }

    private void scanNumber(int radix) {
        int digitRadix = radix <= 10 ? 10 : 16;
        boolean seendigit = false;
        while (this.digit(digitRadix) >= 0) {
            seendigit = true;
            this.scanChar();
        }
        if (radix == 16 && this.ch == '.') {
            this.scanHexFractionAndSuffix(seendigit);
        } else if (seendigit && radix == 16 && (this.ch == 'p' || this.ch == 'P')) {
            this.scanHexExponentAndSuffix();
        } else if (radix <= 10 && this.ch == '.') {
            this.scanChar();
            this.scanFractionAndSuffix();
        } else if (radix <= 10 && (this.ch == 'e' || this.ch == 'E' || this.ch == 'f' || this.ch == 'F' || this.ch == 'd' || this.ch == 'D')) {
            this.scanFractionAndSuffix();
        } else if (this.ch == 'l' || this.ch == 'L') {
            this.scanChar();
            this.token = 285;
        } else {
            this.token = 283;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int scanIdent() {
        block72: while (true) {
            if (this.sp == this.sbuf.length) {
                newsbuf = new char[this.sbuf.length * 2];
                System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                this.sbuf = newsbuf;
            }
            this.sbuf[this.sp++] = this.ch;
            this.scanChar();
            switch (this.ch) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '\u007f': {
                    continue block72;
                }
                case '\u001a': {
                    if (this.bp < this.buflen) continue block72;
                    break block72;
                }
                default: {
                    if (!Character.isJavaIdentifierPart(this.ch) || this.bp >= this.buflen) ** break;
                    continue block72;
                    break block72;
                }
            }
            break;
        }
        switch (this.sp) {
            case 2: {
                switch (this.sbuf[0]) {
                    case 'd': {
                        if (this.sbuf[1] != 'o') break;
                        return 269;
                    }
                    case 'i': {
                        if (this.sbuf[1] != 'f') break;
                        return 279;
                    }
                }
                break;
            }
            case 3: {
                switch (this.sbuf[0]) {
                    case 'f': {
                        if (this.sbuf[1] != 'o' || this.sbuf[2] != 'r') break;
                        return 277;
                    }
                    case 'i': {
                        if (this.sbuf[1] != 'n' || this.sbuf[2] != 't') break;
                        return 283;
                    }
                    case 'n': {
                        if (this.sbuf[1] != 'e' || this.sbuf[2] != 'w') break;
                        return 287;
                    }
                    case 't': {
                        if (this.sbuf[1] != 'r' || this.sbuf[2] != 'y') break;
                        return 303;
                    }
                }
                break;
            }
            case 4: {
                switch (this.sbuf[0]) {
                    case 'b': {
                        if (this.sbuf[1] != 'y' || this.sbuf[2] != 't' || this.sbuf[3] != 'e') break;
                        return 261;
                    }
                    case 'c': {
                        if (this.sbuf[1] == 'a' && this.sbuf[2] == 's' && this.sbuf[3] == 'e') {
                            return 262;
                        }
                        if (this.sbuf[1] != 'h' || this.sbuf[2] != 'a' || this.sbuf[3] != 'r') break;
                        return 264;
                    }
                    case 'e': {
                        if (this.sbuf[1] == 'l' && this.sbuf[2] == 's' && this.sbuf[3] == 'e') {
                            return 271;
                        }
                        if (this.sbuf[1] != 'n' || this.sbuf[2] != 'u' || this.sbuf[3] != 'm') break;
                        return this.source.allowEnums() != false ? 272 : 361;
                    }
                    case 'g': {
                        if (this.sbuf[1] != 'o' || this.sbuf[2] != 't' || this.sbuf[3] != 'o') break;
                        return 278;
                    }
                    case 'l': {
                        if (this.sbuf[1] != 'o' || this.sbuf[2] != 'n' || this.sbuf[3] != 'g') break;
                        return 285;
                    }
                    case 'n': {
                        if (this.sbuf[1] != 'u' || this.sbuf[2] != 'l' || this.sbuf[3] != 'l') break;
                        return 360;
                    }
                    case 't': {
                        if (this.sbuf[1] == 'h' && this.sbuf[2] == 'i' && this.sbuf[3] == 's') {
                            return 299;
                        }
                        if (this.sbuf[1] != 'r' || this.sbuf[2] != 'u' || this.sbuf[3] != 'e') break;
                        return 355;
                    }
                    case 'v': {
                        if (this.sbuf[1] != 'o' || this.sbuf[2] != 'i' || this.sbuf[3] != 'd') break;
                        return 304;
                    }
                }
                break;
            }
            case 5: {
                switch (this.sbuf[0]) {
                    case 'b': {
                        if (this.sbuf[1] != 'r' || this.sbuf[2] != 'e' || this.sbuf[3] != 'a' || this.sbuf[4] != 'k') break;
                        return 260;
                    }
                    case 'c': {
                        if (this.sbuf[1] == 'a' && this.sbuf[2] == 't' && this.sbuf[3] == 'c' && this.sbuf[4] == 'h') {
                            return 263;
                        }
                        if (this.sbuf[1] == 'l' && this.sbuf[2] == 'a' && this.sbuf[3] == 's' && this.sbuf[4] == 's') {
                            return 265;
                        }
                        if (this.sbuf[1] != 'o' || this.sbuf[2] != 'n' || this.sbuf[3] != 's' || this.sbuf[4] != 't') break;
                        return 266;
                    }
                    case 'f': {
                        if (this.sbuf[1] == 'a' && this.sbuf[2] == 'l' && this.sbuf[3] == 's' && this.sbuf[4] == 'e') {
                            return 355;
                        }
                        if (this.sbuf[1] == 'i' && this.sbuf[2] == 'n' && this.sbuf[3] == 'a' && this.sbuf[4] == 'l') {
                            return 274;
                        }
                        if (this.sbuf[1] != 'l' || this.sbuf[2] != 'o' || this.sbuf[3] != 'a' || this.sbuf[4] != 't') break;
                        return 276;
                    }
                    case 's': {
                        if (this.sbuf[1] == 'h' && this.sbuf[2] == 'o' && this.sbuf[3] == 'r' && this.sbuf[4] == 't') {
                            return 293;
                        }
                        if (this.sbuf[1] != 'u' || this.sbuf[2] != 'p' || this.sbuf[3] != 'e' || this.sbuf[4] != 'r') break;
                        return 296;
                    }
                    case 't': {
                        if (this.sbuf[1] != 'h' || this.sbuf[2] != 'r' || this.sbuf[3] != 'o' || this.sbuf[4] != 'w') break;
                        return 300;
                    }
                    case 'w': {
                        if (this.sbuf[1] != 'h' || this.sbuf[2] != 'i' || this.sbuf[3] != 'l' || this.sbuf[4] != 'e') break;
                        return 306;
                    }
                }
                break;
            }
            case 6: {
                switch (this.sbuf[0]) {
                    case 'a': {
                        if (this.sbuf[1] != 's' || this.sbuf[2] != 's' || this.sbuf[3] != 'e' || this.sbuf[4] != 'r' || this.sbuf[5] != 't') break;
                        return this.source.allowAsserts() != false ? 258 : 361;
                    }
                    case 'd': {
                        if (this.sbuf[1] != 'o' || this.sbuf[2] != 'u' || this.sbuf[3] != 'b' || this.sbuf[4] != 'l' || this.sbuf[5] != 'e') break;
                        return 270;
                    }
                    case 'i': {
                        if (this.sbuf[1] != 'm' || this.sbuf[2] != 'p' || this.sbuf[3] != 'o' || this.sbuf[4] != 'r' || this.sbuf[5] != 't') break;
                        return 281;
                    }
                    case 'n': {
                        if (this.sbuf[1] != 'a' || this.sbuf[2] != 't' || this.sbuf[3] != 'i' || this.sbuf[4] != 'v' || this.sbuf[5] != 'e') break;
                        return 286;
                    }
                    case 'p': {
                        if (this.sbuf[1] != 'u' || this.sbuf[2] != 'b' || this.sbuf[3] != 'l' || this.sbuf[4] != 'i' || this.sbuf[5] != 'c') break;
                        return 291;
                    }
                    case 'r': {
                        if (this.sbuf[1] != 'e' || this.sbuf[2] != 't' || this.sbuf[3] != 'u' || this.sbuf[4] != 'r' || this.sbuf[5] != 'n') break;
                        return 292;
                    }
                    case 's': {
                        if (this.sbuf[1] == 't' && this.sbuf[2] == 'a' && this.sbuf[3] == 't' && this.sbuf[4] == 'i' && this.sbuf[5] == 'c') {
                            return 294;
                        }
                        if (this.sbuf[1] != 'w' || this.sbuf[2] != 'i' || this.sbuf[3] != 't' || this.sbuf[4] != 'c' || this.sbuf[5] != 'h') break;
                        return 297;
                    }
                    case 't': {
                        if (this.sbuf[1] != 'h' || this.sbuf[2] != 'r' || this.sbuf[3] != 'o' || this.sbuf[4] != 'w' || this.sbuf[5] != 's') break;
                        return 301;
                    }
                }
                break;
            }
            case 7: {
                switch (this.sbuf[0]) {
                    case 'b': {
                        if (this.sbuf[1] != 'o' || this.sbuf[2] != 'o' || this.sbuf[3] != 'l' || this.sbuf[4] != 'e' || this.sbuf[5] != 'a' || this.sbuf[6] != 'n') break;
                        return 259;
                    }
                    case 'd': {
                        if (this.sbuf[1] != 'e' || this.sbuf[2] != 'f' || this.sbuf[3] != 'a' || this.sbuf[4] != 'u' || this.sbuf[5] != 'l' || this.sbuf[6] != 't') break;
                        return 268;
                    }
                    case 'e': {
                        if (this.sbuf[1] != 'x' || this.sbuf[2] != 't' || this.sbuf[3] != 'e' || this.sbuf[4] != 'n' || this.sbuf[5] != 'd' || this.sbuf[6] != 's') break;
                        return 273;
                    }
                    case 'f': {
                        if (this.sbuf[1] != 'i' || this.sbuf[2] != 'n' || this.sbuf[3] != 'a' || this.sbuf[4] != 'l' || this.sbuf[5] != 'l' || this.sbuf[6] != 'y') break;
                        return 275;
                    }
                    case 'p': {
                        if (this.sbuf[1] == 'a' && this.sbuf[2] == 'c' && this.sbuf[3] == 'k' && this.sbuf[4] == 'a' && this.sbuf[5] == 'g' && this.sbuf[6] == 'e') {
                            return 288;
                        }
                        if (this.sbuf[1] != 'r' || this.sbuf[2] != 'i' || this.sbuf[3] != 'v' || this.sbuf[4] != 'a' || this.sbuf[5] != 't' || this.sbuf[6] != 'e') break;
                        return 289;
                    }
                }
                break;
            }
            case 8: {
                switch (this.sbuf[0]) {
                    case 'a': {
                        if (this.sbuf[1] != 'b' || this.sbuf[2] != 's' || this.sbuf[3] != 't' || this.sbuf[4] != 'r' || this.sbuf[5] != 'a' || this.sbuf[6] != 'c' || this.sbuf[7] != 't') break;
                        return 257;
                    }
                    case 'c': {
                        if (this.sbuf[1] != 'o' || this.sbuf[2] != 'n' || this.sbuf[3] != 't' || this.sbuf[4] != 'i' || this.sbuf[5] != 'n' || this.sbuf[6] != 'u' || this.sbuf[7] != 'e') break;
                        return 267;
                    }
                    case 's': {
                        if (this.sbuf[1] != 't' || this.sbuf[2] != 'r' || this.sbuf[3] != 'i' || this.sbuf[4] != 'c' || this.sbuf[5] != 't' || this.sbuf[6] != 'f' || this.sbuf[7] != 'p') break;
                        return 295;
                    }
                    case 'v': {
                        if (this.sbuf[1] != 'o' || this.sbuf[2] != 'l' || this.sbuf[3] != 'a' || this.sbuf[4] != 't' || this.sbuf[5] != 'i' || this.sbuf[6] != 'l' || this.sbuf[7] != 'e') break;
                        return 305;
                    }
                }
                break;
            }
            case 9: {
                switch (this.sbuf[0]) {
                    case 'i': {
                        if (this.sbuf[1] != 'n' || this.sbuf[2] != 't' || this.sbuf[3] != 'e' || this.sbuf[4] != 'r' || this.sbuf[5] != 'f' || this.sbuf[6] != 'a' || this.sbuf[7] != 'c' || this.sbuf[8] != 'e') break;
                        return 284;
                    }
                    case 'p': {
                        if (this.sbuf[1] != 'r' || this.sbuf[2] != 'o' || this.sbuf[3] != 't' || this.sbuf[4] != 'e' || this.sbuf[5] != 'c' || this.sbuf[6] != 't' || this.sbuf[7] != 'e' || this.sbuf[8] != 'd') break;
                        return 290;
                    }
                    case 't': {
                        if (this.sbuf[1] != 'r' || this.sbuf[2] != 'a' || this.sbuf[3] != 'n' || this.sbuf[4] != 's' || this.sbuf[5] != 'i' || this.sbuf[6] != 'e' || this.sbuf[7] != 'n' || this.sbuf[8] != 't') break;
                        return 302;
                    }
                }
                break;
            }
            case 10: {
                if (this.sbuf[0] != 'i') break;
                if (this.sbuf[1] == 'm' && this.sbuf[2] == 'p' && this.sbuf[3] == 'l' && this.sbuf[4] == 'e' && this.sbuf[5] == 'm' && this.sbuf[6] == 'e' && this.sbuf[7] == 'n' && this.sbuf[8] == 't' && this.sbuf[9] == 's') {
                    return 280;
                }
                if (this.sbuf[1] != 'n' || this.sbuf[2] != 's' || this.sbuf[3] != 't' || this.sbuf[4] != 'a' || this.sbuf[5] != 'n' || this.sbuf[6] != 'c' || this.sbuf[7] != 'e' || this.sbuf[8] != 'o' || this.sbuf[9] != 'f') break;
                return 282;
            }
            case 12: {
                if (this.sbuf[0] != 's' || this.sbuf[1] != 'y' || this.sbuf[2] != 'n' || this.sbuf[3] != 'c' || this.sbuf[4] != 'h' || this.sbuf[5] != 'r' || this.sbuf[6] != 'o' || this.sbuf[7] != 'n' || this.sbuf[8] != 'i' || this.sbuf[9] != 'z' || this.sbuf[10] != 'e' || this.sbuf[11] != 'd') break;
                return 298;
            }
        }
        return 361;
    }

    private void scanDocComment() {
        block5: while (this.bp < this.buflen) {
            while (this.bp < this.buflen && (this.ch == ' ' || this.ch == '\t' || this.ch == '\f')) {
                this.scanCommentChar();
            }
            while (this.bp < this.buflen && this.ch == '*') {
                this.scanCommentChar();
                if (this.ch != '/') continue;
                return;
            }
            while (this.bp < this.buflen && (this.ch == ' ' || this.ch == '\t' || this.ch == '\f')) {
                this.scanCommentChar();
            }
            if (this.bp < this.buflen && this.ch == '@' && !this.deprecatedFlag) {
                this.scanCommentChar();
                if (this.bp < this.buflen && this.ch == 'd') {
                    this.scanCommentChar();
                    if (this.bp < this.buflen && this.ch == 'e') {
                        this.scanCommentChar();
                        if (this.bp < this.buflen && this.ch == 'p') {
                            this.scanCommentChar();
                            if (this.bp < this.buflen && this.ch == 'r') {
                                this.scanCommentChar();
                                if (this.bp < this.buflen && this.ch == 'e') {
                                    this.scanCommentChar();
                                    if (this.bp < this.buflen && this.ch == 'c') {
                                        this.scanCommentChar();
                                        if (this.bp < this.buflen && this.ch == 'a') {
                                            this.scanCommentChar();
                                            if (this.bp < this.buflen && this.ch == 't') {
                                                this.scanCommentChar();
                                                if (this.bp < this.buflen && this.ch == 'e') {
                                                    this.scanCommentChar();
                                                    if (this.bp < this.buflen && this.ch == 'd') {
                                                        this.deprecatedFlag = true;
                                                        this.scanCommentChar();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            block9: while (this.bp < this.buflen) {
                switch (this.ch) {
                    case '*': {
                        this.scanCommentChar();
                        if (this.ch != '/') continue block9;
                        return;
                    }
                    case '\r': {
                        this.scanCommentChar();
                        if (this.ch != '\n') continue block5;
                    }
                    case '\n': {
                        this.scanCommentChar();
                        continue block5;
                    }
                }
                this.scanCommentChar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int yylex() throws IOException {
        if (this.token == 367) {
            return 0;
        }
        try {
            this.sp = 0;
            block67: while (true) {
                this.pos = this.bp;
                switch (this.ch) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        this.scanChar();
                        continue block67;
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        int n = this.token = this.scanIdent();
                        return n;
                    }
                    case '0': {
                        this.scanChar();
                        if (this.ch == 'x' || this.ch == 'X') {
                            this.scanChar();
                            if (this.ch == '.') {
                                this.scanHexFractionAndSuffix(false);
                            } else if (this.digit(16) >= 0) {
                                this.scanNumber(16);
                            }
                        } else {
                            this.scanNumber(8);
                        }
                        int n = this.token;
                        return n;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.scanNumber(10);
                        int n = this.token;
                        return n;
                    }
                    case '.': {
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '9') {
                            this.scanFractionAndSuffix();
                        } else if (this.ch == '.') {
                            this.scanChar();
                            if (this.ch == '.') {
                                this.scanChar();
                                this.token = 317;
                            } else {
                                this.token = 368;
                            }
                        } else {
                            this.token = 315;
                        }
                        int n = this.token;
                        return n;
                    }
                    case ',': {
                        this.scanChar();
                        int n = this.token = 314;
                        return n;
                    }
                    case ';': {
                        this.scanChar();
                        int n = this.token = 313;
                        return n;
                    }
                    case ':': {
                        this.scanChar();
                        int n = this.token = 324;
                        return n;
                    }
                    case '(': {
                        this.scanChar();
                        int n = this.token = 307;
                        return n;
                    }
                    case ')': {
                        this.scanChar();
                        int n = this.token = 308;
                        return n;
                    }
                    case '[': {
                        this.scanChar();
                        int n = this.token = 311;
                        return n;
                    }
                    case ']': {
                        this.scanChar();
                        int n = this.token = 312;
                        return n;
                    }
                    case '{': {
                        this.scanChar();
                        int n = this.token = 309;
                        return n;
                    }
                    case '}': {
                        this.scanChar();
                        int n = this.token = 310;
                        return n;
                    }
                    case '?': {
                        this.scanChar();
                        int n = this.token = 323;
                        return n;
                    }
                    case '@': {
                        this.scanChar();
                        int n = this.token = 316;
                        return n;
                    }
                    case '~': {
                        this.scanChar();
                        int n = this.token = 322;
                        return n;
                    }
                    case '*': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 346;
                        } else {
                            this.token = 335;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '=': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 325;
                        } else {
                            this.token = 318;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '!': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 328;
                        } else {
                            this.token = 321;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '%': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 351;
                        } else {
                            this.token = 340;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '^': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 350;
                        } else {
                            this.token = 339;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '&': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 348;
                        } else if (this.ch == '&') {
                            this.scanChar();
                            this.token = 329;
                        } else {
                            this.token = 337;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '|': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 349;
                        } else if (this.ch == '|') {
                            this.scanChar();
                            this.token = 330;
                        } else {
                            this.token = 338;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '+': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 344;
                        } else if (this.ch == '+') {
                            this.scanChar();
                            this.token = 331;
                        } else {
                            this.token = 333;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '-': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 345;
                        } else if (this.ch == '-') {
                            this.scanChar();
                            this.token = 332;
                        } else {
                            this.token = 334;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '<': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 326;
                        } else if (this.ch == '<') {
                            this.scanChar();
                            if (this.ch == '=') {
                                this.scanChar();
                                this.token = 352;
                            } else {
                                this.token = 341;
                            }
                        } else {
                            this.token = 320;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '>': {
                        this.scanChar();
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 327;
                        } else if (this.ch == '>') {
                            this.scanChar();
                            if (this.ch == '=') {
                                this.scanChar();
                                this.token = 353;
                            } else if (this.ch == '>') {
                                this.scanChar();
                                if (this.ch == '=') {
                                    this.scanChar();
                                    this.token = 354;
                                } else {
                                    this.token = 343;
                                }
                            } else {
                                this.token = 342;
                            }
                        } else {
                            this.token = 319;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '/': {
                        this.scanChar();
                        if (this.ch == '/') {
                            do {
                                this.scanCommentChar();
                            } while (this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen);
                            continue block67;
                        }
                        if (this.ch == '*') {
                            this.scanChar();
                            if (this.ch == '*') {
                                this.scanDocComment();
                            } else {
                                while (this.bp < this.buflen) {
                                    if (this.ch == '*') {
                                        this.scanChar();
                                        if (this.ch != '/') continue;
                                        break;
                                    }
                                    this.scanCommentChar();
                                }
                            }
                            if (this.ch == '/') {
                                this.scanChar();
                                continue block67;
                            }
                            int n = this.token = 368;
                            return n;
                        }
                        if (this.ch == '=') {
                            this.scanChar();
                            this.token = 347;
                        } else {
                            this.token = 336;
                        }
                        int n = this.token;
                        return n;
                    }
                    case '\'': {
                        this.scanChar();
                        if (this.ch == '\'') {
                            this.token = 368;
                        } else {
                            if (this.ch == '\r' || this.ch == '\n') {
                                // empty if block
                            }
                            this.scanLitChar();
                            if (this.ch == '\'') {
                                this.scanChar();
                                this.token = 358;
                            } else {
                                this.token = 368;
                            }
                        }
                        int n = this.token;
                        return n;
                    }
                    case '\"': {
                        this.scanChar();
                        while (this.ch != '\"' && this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen) {
                            this.scanLitChar();
                        }
                        if (this.ch == '\"') {
                            this.scanChar();
                            this.token = 359;
                        } else {
                            this.token = 368;
                        }
                        int n = this.token;
                        return n;
                    }
                }
                break;
            }
            if (Character.isJavaIdentifierStart(this.ch)) {
                this.token = this.scanIdent();
            } else if (this.bp == this.buflen || this.ch == '\u001a' && this.bp + 1 == this.buflen) {
                this.token = 367;
            } else {
                this.scanChar();
                this.token = 368;
            }
            int n = this.token;
            return n;
        }
        finally {
            if (scannerDebug) {
                System.out.println("yylex=" + this.token + "(" + this.pos + "," + this.bp + ")=|" + new String(this.getRawCharacters(this.pos, this.bp)) + "|");
            }
        }
    }

    public boolean isDeprecated() {
        return this.deprecatedFlag;
    }

    public void resetDeprecatedFlag() {
        this.deprecatedFlag = false;
    }

    private char[] getRawCharacters(int beginIndex, int endIndex) {
        int length = endIndex - beginIndex;
        char[] chars = new char[length];
        System.arraycopy(this.buf, beginIndex, chars, 0, length);
        return chars;
    }

    static {
        $assertionsDisabled = !Scanner.class.desiredAssertionStatus();
        scannerDebug = false;
        byteBufferCache = new ByteBufferCache();
        encodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    }

    private static class ByteBufferCache {
        private ByteBuffer cached;

        private ByteBufferCache() {
        }

        ByteBuffer get(int capacity) {
            if (capacity < 20480) {
                capacity = 20480;
            }
            ByteBuffer result = this.cached != null && this.cached.capacity() >= capacity ? (ByteBuffer)this.cached.clear() : ByteBuffer.allocate(capacity + capacity >> 1);
            this.cached = null;
            return result;
        }

        void put(ByteBuffer x) {
            this.cached = x;
        }
    }
}

