/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import javax.swing.JComponent;
import org.netbeans.editor.Coloring;
import org.netbeans.modules.editor.options.ColoringBean;
import org.netbeans.modules.editor.options.ColoringEditorPanel;
import org.openide.util.HelpCtx;

public class ColoringEditor
extends PropertyEditorSupport {
    private ColoringEditorPanel editor;
    private static final String HELP_ID = "editing.fontsandcolors";

    protected HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String text) {
        throw new IllegalArgumentException();
    }

    public void setValue(Object value) {
        super.setValue(value);
        if (this.editor != null) {
            this.editor.setValue((ColoringBean)this.getValue());
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new ColoringEditorPanel();
            this.editor.setValue((ColoringBean)this.getValue());
            this.editor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "value") {
                        ColoringEditor.this.superSetValue(ColoringEditor.this.editor.getValue());
                    }
                }
            });
            HelpCtx.setHelpIDString((JComponent)this.editor, (String)this.getHelpCtx().getHelpID());
        }
        return this.editor;
    }

    void superSetValue(Object value) {
        super.setValue(value);
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics g, Rectangle box) {
        Coloring c = this.getAppliedColoring();
        if (c != null) {
            g.setColor(c.getBackColor());
            g.fillRect(box.x, box.y, box.width - 1, box.height - 1);
            g.setColor(c.getForeColor());
            g.setFont(c.getFont());
            String text = ((ColoringBean)this.getValue()).example;
            FontMetrics fm = g.getFontMetrics();
            int x = Math.max((box.width - fm.stringWidth(text)) / 2, 0);
            int y = Math.max((box.height - fm.getHeight()) / 2 + fm.getAscent(), 0);
            g.drawString(text, x, y);
        }
    }

    private Coloring getAppliedColoring() {
        ColoringBean value = (ColoringBean)this.getValue();
        if (value == null) {
            return null;
        }
        Coloring dc = value.defaultColoring;
        Coloring c = value.coloring;
        Coloring ret = null;
        if (dc != null && c != null) {
            ret = c.apply(dc);
        }
        return ret;
    }
}

