/*
 * Decompiled with CFR 0.152.
 */
package mx4j.log;

import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import mx4j.log.Logger;

public class MBeanLogger
extends Logger {
    private MBeanServer m_server;
    private ObjectName m_name;

    public MBeanLogger(MBeanServer server, ObjectName objectName) throws MBeanException {
        boolean found;
        block6: {
            if (server == null) {
                throw new MBeanException(new IllegalArgumentException("MBeanServer cannot be null"));
            }
            if (objectName == null) {
                throw new MBeanException(new IllegalArgumentException("ObjectName cannot be null"));
            }
            this.m_server = server;
            this.m_name = objectName;
            found = false;
            try {
                MBeanInfo info = this.m_server.getMBeanInfo(this.m_name);
                MBeanOperationInfo[] opers = info.getOperations();
                if (opers == null) break block6;
                for (int i = 0; i < opers.length; ++i) {
                    MBeanParameterInfo[] params;
                    MBeanOperationInfo oper = opers[i];
                    if (!oper.getName().equals("log") || (params = oper.getSignature()).length != 3 || !params[0].getType().equals("int") || !params[1].getType().equals("java.lang.Object") || !params[2].getType().equals("java.lang.Throwable")) continue;
                    found = true;
                    break;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if (!found) {
            throw new MBeanException(new ServiceNotFoundException("MBean does not have an operation log(int,Object,Throwable)"));
        }
    }

    protected void log(int priority, Object message, Throwable t) {
        try {
            this.m_server.invoke(this.m_name, "log", new Object[]{new Integer(priority), message, t}, new String[]{"int", "java.lang.Object", "java.lang.Throwable"});
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

