/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerTarget;
import org.netbeans.modules.j2ee.deployment.impl.ui.FilterXNode;
import org.netbeans.modules.j2ee.deployment.impl.ui.InstanceNode;
import org.netbeans.modules.j2ee.deployment.impl.ui.InstanceNodeDecorator;
import org.netbeans.modules.j2ee.deployment.impl.ui.InstanceTargetXNode;
import org.netbeans.modules.j2ee.deployment.impl.ui.TargetBaseNode;
import org.netbeans.modules.j2ee.deployment.plugins.api.RegistryNodeFactory;
import org.openide.ErrorManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class RegistryNodeProvider {
    RegistryNodeFactory factory;

    public RegistryNodeProvider(RegistryNodeFactory factory) {
        this.factory = factory;
    }

    public Node createInstanceNode(ServerInstance instance) {
        return new InstanceNodeDecorator(this.createInstanceNodeImpl(instance, true), instance);
    }

    public Node createTargetNode(ServerTarget target) {
        Node original;
        if (this.factory != null && (original = this.factory.getTargetNode(RegistryNodeProvider.createLookup(target))) != null) {
            TargetBaseNode xnode = new TargetBaseNode(Children.LEAF, target);
            return new FilterXNode(original, (Node)xnode, true);
        }
        return new TargetBaseNode(Children.LEAF, target);
    }

    public Node createInstanceTargetNode(ServerInstance instance) {
        Node original = this.createInstanceNodeImpl(instance, false);
        return new InstanceNodeDecorator((Node)new InstanceTargetXNode(original, instance), instance);
    }

    private Node createInstanceNodeImpl(ServerInstance instance, boolean addStateListener) {
        Node original;
        InstanceNode xnode = new InstanceNode(instance, addStateListener);
        if (this.factory != null && (original = this.factory.getManagerNode(RegistryNodeProvider.createLookup(instance))) != null) {
            return new FilterXNode(original, (Node)xnode, true, new FilterXNode.XChildren((Node)xnode));
        }
        return xnode;
    }

    static Lookup createLookup(final Server server) {
        return new Lookup(){

            public Object lookup(Class clazz) {
                if (DeploymentFactory.class.isAssignableFrom(clazz)) {
                    return server.getDeploymentFactory();
                }
                if (DeploymentManager.class.isAssignableFrom(clazz)) {
                    try {
                        return server.getDisconnectedDeploymentManager();
                    }
                    catch (DeploymentManagerCreationException dmce) {
                        ErrorManager.getDefault().notify((Throwable)dmce);
                    }
                }
                return null;
            }

            public Lookup.Result lookup(Lookup.Template template) {
                return null;
            }
        };
    }

    static Lookup createLookup(final ServerInstance instance) {
        return new Lookup(){

            public Object lookup(Class clazz) {
                if (DeploymentFactory.class.isAssignableFrom(clazz)) {
                    return instance.getServer().getDeploymentFactory();
                }
                if (DeploymentManager.class.isAssignableFrom(clazz)) {
                    try {
                        return instance.isConnected() ? instance.getDeploymentManager() : instance.getDisconnectedDeploymentManager();
                    }
                    catch (DeploymentManagerCreationException dmce) {
                        ErrorManager.getDefault().notify((Throwable)dmce);
                    }
                }
                return null;
            }

            public Lookup.Result lookup(Lookup.Template template) {
                return null;
            }
        };
    }

    static Lookup createLookup(final ServerTarget target) {
        return new Lookup(){

            public Object lookup(Class clazz) {
                if (DeploymentFactory.class.isAssignableFrom(clazz)) {
                    return target.getInstance().getServer().getDeploymentFactory();
                }
                if (DeploymentManager.class.isAssignableFrom(clazz)) {
                    ServerInstance instance = target.getInstance();
                    try {
                        return instance.isConnected() ? instance.getDeploymentManager() : instance.getDisconnectedDeploymentManager();
                    }
                    catch (DeploymentManagerCreationException dmce) {
                        ErrorManager.getDefault().notify((Throwable)dmce);
                    }
                }
                if (Target.class.isAssignableFrom(clazz)) {
                    return target.getTarget();
                }
                return null;
            }

            public Lookup.Result lookup(Lookup.Template template) {
                return null;
            }
        };
    }
}

