/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.modules.j2ee.deployment.config.Utils;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.DebugAction;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

public class RefreshAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(DebugAction.class, (String)"LBL_Refresh");
    }

    protected void performAction(Node[] nodes) {
        RefreshAction.performActionImpl(nodes);
    }

    protected boolean enable(Node[] nodes) {
        return RefreshAction.enableImpl(nodes);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void performActionImpl(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ServerInstance si = (ServerInstance)nodes[i].getCookie(ServerInstance.class);
            if (si == null) continue;
            si.refresh();
        }
    }

    private static boolean enableImpl(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            ServerInstance si = (ServerInstance)nodes[i].getCookie(ServerInstance.class);
            if (si != null && si.getServerState() != 1) continue;
            return false;
        }
        return true;
    }

    public static class OutputAction
    extends AbstractAction
    implements ServerInstance.StateListener {
        private static final String ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/refresh.png";
        private static final String PROP_ENABLED = "enabled";
        private Node node;

        public OutputAction(Node node) {
            super(NbBundle.getMessage(DebugAction.class, (String)"LBL_RefreshOutput"), new ImageIcon(Utilities.loadImage((String)ICON)));
            this.putValue("ShortDescription", NbBundle.getMessage(DebugAction.class, (String)"LBL_RefreshOutputDesc"));
            this.node = node;
            ServerInstance si = (ServerInstance)node.getCookie(ServerInstance.class);
            si.addStateListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            RefreshAction.performActionImpl(new Node[]{this.node});
        }

        public boolean isEnabled() {
            return RefreshAction.enableImpl(new Node[]{this.node});
        }

        public void stateChanged(int oldState, int newState) {
            Utils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    OutputAction.this.firePropertyChange(OutputAction.PROP_ENABLED, null, OutputAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
    }
}

