/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeChildren;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.Utils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openidex.search.SearchType;

final class ResultView
extends TopComponent
implements ExplorerManager.Provider {
    private volatile boolean hasResults = false;
    private volatile boolean hasDetails = false;
    private volatile boolean searchInProgress = false;
    private static final String ID = "search-results";
    private static WeakReference instance;
    private final ExplorerManager explorerManager;
    private final BeanTreeView treeView;
    private ResultModel resultModel = null;
    private final RootNode root;
    private ResultTreeChildren children;
    private Node[] lastSearchNodes;
    private List lastEnabledSearchTypes;
    private MessageFormat nodeCountFormat;
    private final JButton btnModifySearch = new JButton();
    private final JButton btnShowDetails = new JButton();
    private final JButton btnStop = new JButton();
    private JPanel buttonsPanel;
    private JPanel mainPanel;
    private final JRadioButton sortButton = new JRadioButton();
    private final JRadioButton unsortButton = new JRadioButton();
    static final /* synthetic */ boolean $assertionsDisabled;

    static synchronized ResultView getInstance() {
        ResultView view = (ResultView)WindowManager.getDefault().findTopComponent(ID);
        if (view == null) {
            view = ResultView.getDefault();
        }
        return view;
    }

    public static synchronized ResultView getDefault() {
        ResultView view;
        if (instance == null) {
            view = new ResultView();
            instance = new WeakReference<ResultView>(view);
        } else {
            view = (ResultView)((Object)instance.get());
            if (view == null) {
                view = new ResultView();
                instance = new WeakReference<ResultView>(view);
            }
        }
        return view;
    }

    private ResultView() {
        this.initComponents();
        this.setName("Search Results");
        this.setDisplayName(NbBundle.getMessage((Class)ResultView.class, (String)"TITLE_SEARCH_RESULTS"));
        this.setToolTipText(NbBundle.getMessage((Class)ResultView.class, (String)"TOOLTIP_SEARCH_RESULTS"));
        this.setIcon(Utilities.loadImage((String)"org/netbeans/modules/search/res/find.gif"));
        this.mainPanel.setOpaque(true);
        this.buttonsPanel.add(Box.createHorizontalGlue(), 2);
        this.buttonsPanel.add(Box.createHorizontalStrut(5), 4);
        this.buttonsPanel.add(Box.createHorizontalStrut(5), 6);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.sortButton);
        buttonGroup.add(this.unsortButton);
        this.root = this.createTreeViewRoot();
        this.explorerManager = new ExplorerManager();
        this.explorerManager.setRootContext((Node)this.root);
        this.selectAndActivateNode((Node)this.root);
        this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    ResultView.this.nodeSelectionChanged();
                }
            }
        });
        this.setupActions();
        this.treeView = new BeanTreeView();
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ResultView.class, (String)"ACS_TREEVIEW"));
        this.treeView.setBorder(BorderFactory.createEmptyBorder());
        this.mainPanel.add((Component)this.treeView, "Center");
        ButtonListener buttonListener = new ButtonListener();
        this.sortButton.addActionListener(buttonListener);
        this.unsortButton.addActionListener(buttonListener);
        this.btnShowDetails.addActionListener(buttonListener);
        this.btnModifySearch.addActionListener(buttonListener);
        this.btnStop.addActionListener(buttonListener);
        this.initAccessibility();
    }

    private final RootNode createTreeViewRoot() {
        RootNode root = new RootNode();
        root.setName(this.getInitialRootNodeText());
        root.setIconBase("org/netbeans/modules/search/res/find");
        return root;
    }

    private String getInitialRootNodeText() {
        return NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_Search_in_filesystems");
    }

    private void setupActions() {
        String copyActionKey = "copy-to-clipboard";
        String cutActionKey = "cut-to-clipboard";
        String pasteActionKey = "paste-from-clipboard";
        String deleteActionKey = "delete";
        ActionMap map = this.getActionMap();
        map.put(copyActionKey, ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
        map.put(cutActionKey, ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
        map.put(pasteActionKey, ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
        map.put(deleteActionKey, ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)true));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)map));
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
        this.treeView.requestFocusInWindow();
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
    }

    private final void selectAndActivateNode(Node node) {
        Node[] nodeArray = new Node[]{node};
        try {
            this.explorerManager.setSelectedNodes(nodeArray);
            this.setActivatedNodes(nodeArray);
        }
        catch (PropertyVetoException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            nodeArray = new Node[]{};
            try {
                this.explorerManager.setSelectedNodes(nodeArray);
                this.setActivatedNodes(nodeArray);
            }
            catch (PropertyVetoException ex2) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex2);
            }
        }
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultView.getDefault();
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle((Class)ResultView.class);
        this.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_ResultViewTopComponent"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ResultViewTopComponent"));
        AccessibleContext accessCtx = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("ACSN_HorizontalScrollbar"));
        accessCtx = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("ACSN_VerticalScrollbar"));
        accessCtx = this.treeView.getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("ACSN_ResultTree"));
        accessCtx.setAccessibleDescription(bundle.getString("ACSD_ResultTree"));
        this.sortButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_SORT"));
        this.unsortButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_UNSORT"));
        this.btnModifySearch.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_CUSTOMIZE"));
        this.btnShowDetails.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_FILL"));
        this.btnStop.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_STOP"));
    }

    void closeResults() {
        this.close();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(0, 0, 2, 0)));
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 0));
        this.buttonsPanel.setBorder(new EmptyBorder(new Insets(5, 0, 0, 0)));
        Mnemonics.setLocalizedText((AbstractButton)this.sortButton, (String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_BUTTON_SORT"));
        this.sortButton.setEnabled(false);
        this.buttonsPanel.add(this.sortButton);
        this.unsortButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.unsortButton, (String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_BUTTON_UNSORT"));
        this.unsortButton.setEnabled(false);
        this.buttonsPanel.add(this.unsortButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowDetails, (String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_BUTTON_FILL"));
        this.btnShowDetails.setEnabled(false);
        this.buttonsPanel.add(this.btnShowDetails);
        Mnemonics.setLocalizedText((AbstractButton)this.btnModifySearch, (String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_BUTTON_CUSTOMIZE"));
        this.buttonsPanel.add(this.btnModifySearch);
        Mnemonics.setLocalizedText((AbstractButton)this.btnStop, (String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_BUTTON_STOP"));
        this.btnStop.setEnabled(false);
        this.buttonsPanel.add(this.btnStop);
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.add(this.mainPanel, "Center");
    }

    public void fillOutput() {
        this.btnShowDetails.setEnabled(false);
        Manager.getInstance().schedulePrintingDetails(this.children, this.resultModel.getSearchGroup());
    }

    protected void componentOpened() {
        Manager.getInstance().searchWindowOpened();
        this.root.setDisplayName(this.getInitialRootNodeText());
        this.explorerManager.setRootContext((Node)this.root);
        this.selectAndActivateNode((Node)this.root);
        if (this.lastSearchNodes == null) {
            this.btnModifySearch.setEnabled(false);
        }
    }

    protected void componentClosed() {
        this.rememberInput(null, null);
        Manager.getInstance().searchWindowClosed();
        Node empty = Node.EMPTY;
        this.explorerManager.setRootContext(empty);
        this.selectAndActivateNode(empty);
    }

    void notifySearchPending(int blockingTask) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        String msgKey = null;
        switch (blockingTask) {
            case 1: {
                msgKey = "TEXT_FINISHING_PREV_SEARCH";
                break;
            }
            case 2: {
                msgKey = "TEXT_CLEANING_RESULT";
                break;
            }
            case 4: {
                msgKey = "TEXT_PRINTING_DETAILS";
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        this.root.setDisplayName(NbBundle.getMessage((Class)ResultView.class, (String)msgKey));
        this.btnStop.setEnabled(true);
        this.sortButton.setEnabled(false);
        this.unsortButton.setEnabled(false);
    }

    void searchTaskStateChanged(int changeType) {
        switch (changeType) {
            case 1: {
                this.searchStarted();
                break;
            }
            case 2: {
                this.searchFinished();
                break;
            }
            case 3: {
                this.searchInterrupted();
                break;
            }
            case 4: {
                this.searchCancelled();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    void showAllDetailsFinished() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.updateShowAllDetailsBtn();
    }

    private void searchStarted() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.root.setDisplayName(NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_SEARCHING___"));
        this.nodeCountFormat = new MessageFormat(NbBundle.getMessage((Class)ResultView.class, (String)"TXT_RootSearchedNodes"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.updateSortUnsortBtns();
        this.btnModifySearch.setEnabled(true);
        this.btnStop.setEnabled(true);
    }

    private void searchFinished() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.setFinalRootNodeText();
        this.searchInProgress = false;
        this.hasDetails = this.children != null ? this.children.hasDetails() : false;
        this.updateShowAllDetailsBtn();
        this.updateSortUnsortBtns();
        this.btnStop.setEnabled(false);
    }

    private void searchInterrupted() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.searchFinished();
    }

    private void searchCancelled() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.root.setDisplayName(NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_TASK_CANCELLED"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.updateSortUnsortBtns();
        this.btnStop.setEnabled(false);
    }

    private void setFinalRootNodeText() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        int resultSize = this.resultModel.size();
        if (this.resultModel.wasLimitReached()) {
            this.root.setDisplayName(NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_MSG_FOUND_X_NODES_LIMIT", (Object)new Integer(resultSize)));
            return;
        }
        String baseMsg = resultSize == 0 ? NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_MSG_NO_NODE_FOUND") : (resultSize == 1 ? NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_MSG_FOUND_A_NODE") : NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_MSG_FOUND_X_NODES", (Object)new Integer(resultSize)));
        String exMsg = this.resultModel.getExceptionMsg();
        String msg = exMsg == null ? baseMsg : baseMsg + " (" + exMsg + ")";
        this.root.setDisplayName(msg);
    }

    private void updateShowAllDetailsBtn() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.btnShowDetails.setEnabled(this.hasResults && !this.searchInProgress && this.hasDetails);
    }

    private void updateSortUnsortBtns() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        boolean enabled = this.hasResults && !this.searchInProgress;
        this.sortButton.setEnabled(enabled);
        this.unsortButton.setEnabled(enabled);
    }

    void setResultModel(ResultModel resultModel) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.resultModel == null && resultModel == null) {
            return;
        }
        if (this.resultModel != null) {
            if (this.children != null) {
                this.children.clear();
            }
            this.children = null;
        }
        this.resultModel = resultModel;
        if (resultModel != null) {
            this.children = new ResultTreeChildren(resultModel);
            this.setChildren((Children)this.children);
            this.hasResults = !this.children.isEmpty();
            this.hasDetails = this.hasResults && this.children.hasDetails();
            this.children.setObserver(this);
        } else {
            this.hasResults = false;
            this.hasDetails = false;
            this.setChildren(Children.LEAF);
        }
        this.selectAndActivateNode((Node)this.root);
        this.updateShowAllDetailsBtn();
        this.updateSortUnsortBtns();
        if (this.children != null) {
            if (this.children.isSorted()) {
                this.sortButton.setSelected(true);
            } else {
                this.unsortButton.setSelected(true);
            }
        }
    }

    public void objectFound(Object foundObject) {
        this.hasResults = true;
        this.updateRootDisplayName();
    }

    private void updateRootDisplayName() {
        if (!$assertionsDisabled && EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        final String display = this.nodeCountFormat.format(new Object[]{new Integer(this.children.getSize())});
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    ResultView.this.root.setDisplayName(display);
                }
            });
        }
        catch (InvocationTargetException ex1) {
            ErrorManager.getDefault().notify((Throwable)ex1);
        }
        catch (Exception ex2) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex2);
        }
    }

    private void setChildren(Children children) {
        this.root.changeChildren(children);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private void nodeSelectionChanged() {
        Node[] nodes = this.explorerManager.getSelectedNodes();
        this.setActivatedNodes(nodes);
    }

    void rememberInput(Node[] nodes, List enabledSearchTypes) {
        this.lastSearchNodes = nodes;
        this.lastEnabledSearchTypes = enabledSearchTypes;
    }

    private void customizeCriteria() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.lastSearchNodes == null) {
            throw new AssertionError();
        }
        Node[] nodesToSearch = this.lastSearchNodes;
        List searchTypes = this.lastEnabledSearchTypes;
        ArrayList<Object> searchTypesClone = new ArrayList<Object>(searchTypes.size());
        Iterator it = searchTypes.iterator();
        while (it.hasNext()) {
            searchTypesClone.add(((SearchType)it.next()).clone());
        }
        this.lastEnabledSearchTypes = searchTypesClone;
        SearchPanel searchPanel = new SearchPanel(searchTypesClone, true);
        searchPanel.showDialog();
        if (searchPanel.getReturnStatus() != 1) {
            return;
        }
        this.rememberInput(nodesToSearch, Utils.cloneSearchTypes(searchTypesClone));
        Manager.getInstance().scheduleSearchTask(new SearchTask(nodesToSearch, searchTypesClone, searchPanel.getCustomizedSearchTypes()));
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void setNodesSorted(boolean sorted) {
        if (!$assertionsDisabled && this.children == null) {
            throw new AssertionError();
        }
        Node[] selectedNodes = this.explorerManager.getSelectedNodes();
        this.children.sort(sorted);
        try {
            this.explorerManager.setSelectedNodes(selectedNodes);
            this.setActivatedNodes(selectedNodes);
        }
        catch (PropertyVetoException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            this.selectAndActivateNode((Node)this.root);
        }
    }

    static {
        $assertionsDisabled = !ResultView.class.desiredAssertionStatus();
        instance = null;
    }

    private class RootNode
    extends AbstractNode {
        RootNode() {
            super(Children.LEAF);
        }

        void changeChildren(Children children) {
            super.setChildren(children);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == ResultView.this.btnStop) {
                Manager.getInstance().stopSearching();
            } else if (source == ResultView.this.btnModifySearch) {
                ResultView.this.customizeCriteria();
            } else if (source == ResultView.this.btnShowDetails) {
                ResultView.this.fillOutput();
            } else if (source == ResultView.this.sortButton) {
                ResultView.this.setNodesSorted(true);
            } else if (source == ResultView.this.unsortButton) {
                ResultView.this.setNodesSorted(false);
            }
        }
    }

    public static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7398708142639457544L;

        public Object readResolve() {
            return ResultView.getDefault();
        }
    }
}

