/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

final class SearchTask
implements Runnable,
Cancellable {
    private final Node[] nodes;
    private final SearchType[] customizedSearchTypes;
    private final List searchTypeList;
    private ResultModel resultModel;
    private SearchGroup searchGroup;
    private PropertyChangeListener searchGroupListener;
    private boolean notifyWhenFinished = true;
    private volatile boolean interrupted = false;
    private volatile boolean finished = false;

    public SearchTask(Node[] nodes, List searchTypeList, SearchType[] customizedSearchTypes) {
        this.nodes = nodes;
        this.searchTypeList = searchTypeList;
        this.customizedSearchTypes = customizedSearchTypes;
    }

    public void run() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)ResultView.class, (String)"TEXT_SEARCHING___"), (Cancellable)this);
        progressHandle.start();
        this.ensureResultModelExists();
        if (this.searchGroup == null) {
            return;
        }
        this.searchGroupListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("org.openidex.search.found".equals(evt.getPropertyName())) {
                    SearchTask.this.matchingObjectFound(evt.getNewValue());
                }
            }
        };
        this.searchGroup.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.searchGroupListener, (Object)this.searchGroup));
        this.searchGroup.setSearchRootNodes(this.nodes);
        try {
            this.searchGroup.search();
        }
        catch (RuntimeException ex) {
            this.resultModel.searchException(ex);
        }
        this.finished = true;
        progressHandle.finish();
    }

    ResultModel getResultModel() {
        this.ensureResultModelExists();
        return this.resultModel;
    }

    private void ensureResultModelExists() {
        if (this.resultModel == null) {
            SearchGroup[] groups = SearchGroup.createSearchGroups((SearchType[])this.customizedSearchTypes);
            this.searchGroup = groups.length != 0 ? groups[0] : null;
            this.resultModel = new ResultModel(this.searchTypeList, this.searchGroup);
        }
    }

    private void matchingObjectFound(Object object) {
        boolean canContinue = this.resultModel.objectFound(object);
        if (!canContinue) {
            this.searchGroup.stopSearch();
        }
    }

    void stop(boolean notifyWhenFinished) {
        if (!notifyWhenFinished) {
            this.notifyWhenFinished = notifyWhenFinished;
        }
        this.stop();
    }

    void stop() {
        if (!this.finished) {
            this.interrupted = true;
        }
        if (this.searchGroup != null) {
            this.searchGroup.stopSearch();
        }
    }

    public boolean cancel() {
        this.stop();
        return true;
    }

    boolean notifyWhenFinished() {
        return this.notifyWhenFinished;
    }

    boolean wasInterrupted() {
        return this.interrupted;
    }
}

