/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.TypeMismatchException;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldGroup;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.modules.javacore.jmiimpl.javamodel.FieldGroupImpl;

public class FeaturesList
implements List {
    private ClassDefinition javaClass;

    public FeaturesList(ClassDefinition javaClass) {
        this.javaClass = javaClass;
    }

    private void lock() {
        this.lock(false);
    }

    private void lock(boolean readWrite) {
        ((BaseObjectHandler)this.javaClass).repository().beginTrans(readWrite);
    }

    private void unlock() {
        this.unlock(false);
    }

    private void unlock(boolean fail) {
        ((BaseObjectHandler)this.javaClass).repository().endTrans(fail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock();
        try {
            int size = 0;
            Object[] features = this.javaClass.getContents().toArray();
            for (int i = 0; i < features.length; ++i) {
                Object temp = features[i];
                if (temp instanceof FieldGroup) {
                    size += ((FieldGroup)temp).getFields().size();
                    continue;
                }
                ++size;
            }
            int n = size;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock();
        try {
            boolean bl = this.javaClass.getContents().isEmpty();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        this.lock();
        try {
            if (o instanceof FieldGroup) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.javaClass.equals(((RefObject)o).refImmediateComposite());
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.lock();
        try {
            Object[] features = this.javaClass.getContents().toArray();
            ArrayList<Object> result = new ArrayList<Object>(100);
            boolean hasFieldGroup = false;
            for (int i = 0; i < features.length; ++i) {
                Object feature = features[i];
                if (feature instanceof FieldGroup) {
                    FieldGroup group = (FieldGroup)feature;
                    hasFieldGroup = true;
                    result.addAll(Arrays.asList(group.getFields().toArray()));
                    continue;
                }
                result.add(feature);
            }
            if (hasFieldGroup) {
                Object[] objectArray = result.toArray();
                return objectArray;
            }
            Object[] objectArray = features;
            return objectArray;
        }
        finally {
            this.unlock();
        }
    }

    public Object[] toArray(Object[] a) {
        Object[] arr = this.toArray();
        int size = arr.length;
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        System.arraycopy(arr, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        if (o instanceof FieldGroup) {
            throw new TypeMismatchException(Feature.class, o, null);
        }
        boolean fail = true;
        this.lock(true);
        try {
            boolean result = this.javaClass.getContents().add(o);
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        if (!(o instanceof Feature)) {
            return false;
        }
        boolean fail = true;
        this.lock(true);
        try {
            boolean result = false;
            RefFeatured parent = ((Feature)o).refImmediateComposite();
            if (this.javaClass.equals(parent)) {
                result = this.javaClass.getContents().remove(o);
            } else if (parent instanceof FieldGroup && this.javaClass.equals(((FieldGroup)parent).refImmediateComposite())) {
                result = ((FieldGroup)parent).getFields().remove(o);
                this.separate((Field)o, (FieldGroup)parent);
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    private void separate(Field field, FieldGroup fg) {
        field.setModifiers(((FieldGroupImpl)fg).getSourceModifiers());
        field.setTypeName((TypeReference)fg.getTypeName().duplicate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        this.lock();
        try {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                if (this.contains(it.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        boolean fail = true;
        this.lock(true);
        try {
            boolean result = false;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                result |= this.add(it.next());
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        boolean fail = true;
        this.lock(true);
        try {
            ListIterator cm = this.listIterator(index);
            Iterator it = c.iterator();
            while (it.hasNext()) {
                cm.add(it.next());
            }
            fail = false;
            boolean bl = !c.isEmpty();
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        boolean fail = true;
        this.lock(true);
        try {
            boolean result = false;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                result |= this.remove(it.next());
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        boolean fail = true;
        this.lock(true);
        try {
            boolean result = false;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                result = true;
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean fail = true;
        this.lock(true);
        try {
            this.javaClass.getContents().clear();
            fail = false;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        this.lock();
        try {
            Object e = this.listIterator(index).next();
            return e;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        boolean fail = true;
        this.lock(true);
        try {
            ListIterator it = this.listIterator(index);
            Object result = it.next();
            it.set(element);
            fail = false;
            Object e = result;
            return e;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        boolean fail = true;
        this.lock(true);
        try {
            this.listIterator(index).add(element);
            fail = false;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        boolean fail = true;
        this.lock(true);
        try {
            ListIterator it = this.listIterator(index);
            Object result = it.next();
            it.remove();
            fail = false;
            Object e = result;
            return e;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        this.lock();
        try {
            ListIterator it = this.listIterator();
            while (it.hasNext()) {
                if (!it.next().equals(o)) continue;
                int n = it.previousIndex();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        this.lock();
        try {
            int result = -1;
            ListIterator it = this.listIterator();
            while (it.hasNext()) {
                if (!it.next().equals(o)) continue;
                result = it.previousIndex();
            }
            int n = result;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator() {
        this.lock();
        try {
            FeatureListIterator featureListIterator = new FeatureListIterator(this.javaClass.getContents().listIterator());
            return featureListIterator;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator(int index) {
        this.lock();
        try {
            ListIterator result = this.listIterator();
            while (result.nextIndex() < index) {
                result.next();
            }
            ListIterator listIterator = result;
            return listIterator;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        this.lock();
        try {
            if (o == this) {
                boolean bl = true;
                return bl;
            }
            if (!(o instanceof List)) {
                boolean bl = false;
                return bl;
            }
            ListIterator e1 = this.listIterator();
            ListIterator e2 = ((List)o).listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Object o2;
                Object o1 = e1.next();
                if (o1 == (o2 = e2.next()) || o1.equals(o2)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = !e1.hasNext() && !e2.hasNext();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock();
        try {
            int hashCode = 1;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                hashCode = 31 * hashCode + it.next().hashCode();
            }
            int n = hashCode;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock();
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("[");
            Iterator i = this.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Object o = i.next();
                buf.append(o == this ? "(this Collection)" : String.valueOf(o));
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("]");
            String string = buf.toString();
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private class FeatureListIterator
    implements ListIterator {
        private final ListIterator contents;
        private ListIterator fieldGroup = null;
        private int index = 0;
        private boolean forward = true;
        private boolean lastForward = true;
        private FieldGroup parentGroup = null;
        private Field currentField = null;

        public FeatureListIterator(ListIterator contents) {
            this.contents = contents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            FeaturesList.this.lock();
            try {
                if (!this.forward) {
                    this.contents.next();
                    this.forward = true;
                }
                boolean bl = this.contents.hasNext() || this.fieldGroup != null && this.fieldGroup.hasNext();
                return bl;
            }
            finally {
                FeaturesList.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            FeaturesList.this.lock();
            try {
                Object next;
                if (this.fieldGroup != null) {
                    if (this.fieldGroup.hasNext()) {
                        ++this.index;
                        this.lastForward = true;
                        Field field = this.currentField = (Field)this.fieldGroup.next();
                        return field;
                    }
                    this.fieldGroup = null;
                    this.parentGroup = null;
                    if (!this.forward) {
                        this.contents.next();
                    }
                }
                if ((next = this.contents.next()) instanceof FieldGroup) {
                    Field result;
                    ListIterator it = ((FieldGroup)next).getFields().listIterator();
                    ListIterator temp = this.fieldGroup;
                    FieldGroup tmpGroup = this.parentGroup;
                    this.fieldGroup = it;
                    this.parentGroup = (FieldGroup)next;
                    this.forward = true;
                    try {
                        result = this.currentField = (Field)this.next();
                    }
                    catch (RuntimeException e) {
                        this.fieldGroup = temp;
                        this.parentGroup = tmpGroup;
                        throw e;
                    }
                    ++this.index;
                    this.lastForward = true;
                    Field field = result;
                    return field;
                }
                ++this.index;
                this.lastForward = true;
                Object e = next;
                return e;
            }
            finally {
                FeaturesList.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPrevious() {
            FeaturesList.this.lock();
            try {
                if (this.forward) {
                    this.contents.previous();
                    this.forward = false;
                }
                boolean bl = this.contents.hasPrevious() || this.fieldGroup != null && this.fieldGroup.hasPrevious();
                return bl;
            }
            finally {
                FeaturesList.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object previous() {
            FeaturesList.this.lock();
            try {
                Object prev;
                if (this.fieldGroup != null) {
                    if (this.fieldGroup.hasPrevious()) {
                        --this.index;
                        this.lastForward = false;
                        Field field = this.currentField = (Field)this.fieldGroup.previous();
                        return field;
                    }
                    this.fieldGroup = null;
                    this.parentGroup = null;
                    if (this.forward) {
                        this.contents.previous();
                    }
                }
                if ((prev = this.contents.previous()) instanceof FieldGroup) {
                    Field result;
                    ListIterator it = ((FieldGroup)prev).getFields().listIterator();
                    while (it.hasNext()) {
                        it.next();
                    }
                    this.forward = false;
                    ListIterator temp = this.fieldGroup;
                    FieldGroup tmpGroup = this.parentGroup;
                    this.fieldGroup = it;
                    this.parentGroup = (FieldGroup)prev;
                    try {
                        result = this.currentField = (Field)this.previous();
                    }
                    catch (RuntimeException e) {
                        this.fieldGroup = temp;
                        this.parentGroup = tmpGroup;
                        throw e;
                    }
                    --this.index;
                    this.lastForward = false;
                    Field field = result;
                    return field;
                }
                --this.index;
                this.lastForward = false;
                Object e = prev;
                return e;
            }
            finally {
                FeaturesList.this.unlock();
            }
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            boolean fail = true;
            FeaturesList.this.lock(true);
            try {
                if (this.fieldGroup != null) {
                    this.fieldGroup.remove();
                    FeaturesList.this.separate(this.currentField, this.parentGroup);
                    if (!this.fieldGroup.hasNext() && !this.fieldGroup.hasPrevious()) {
                        this.contents.remove();
                        this.fieldGroup = null;
                    }
                } else {
                    this.contents.remove();
                }
                if (this.lastForward) {
                    --this.index;
                }
                fail = false;
            }
            finally {
                FeaturesList.this.unlock(fail);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object o) {
            boolean fail = true;
            FeaturesList.this.lock(true);
            try {
                this.remove();
                this.add(o);
                fail = false;
            }
            finally {
                FeaturesList.this.unlock(fail);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Object o) {
            if (o instanceof FieldGroup) {
                throw new TypeMismatchException(class$org$netbeans$jmi$javamodel$Feature == null ? (class$org$netbeans$jmi$javamodel$Feature = FeaturesList.class$("org.netbeans.jmi.javamodel.Feature")) : class$org$netbeans$jmi$javamodel$Feature, o, null);
            }
            boolean fail = true;
            FeaturesList.this.lock(fail);
            try {
                if (this.fieldGroup == null || !this.fieldGroup.hasNext()) {
                    this.contents.add(o);
                } else if (!this.fieldGroup.hasPrevious()) {
                    this.contents.previous();
                    this.contents.add(o);
                    this.contents.next();
                } else {
                    FieldGroup fg = this.forward ? (FieldGroup)this.contents.previous() : (FieldGroup)this.contents.next();
                    this.forward = !this.forward;
                    JavaModelPackage pkg = (JavaModelPackage)FeaturesList.this.javaClass.refImmediatePackage();
                    FieldGroup newGroup = pkg.getFieldGroup().createFieldGroup(null, null, ((FieldGroupImpl)fg).getSourceModifiers(), null, null, null, null);
                    newGroup.setType(fg.getType());
                    while (this.fieldGroup.hasNext()) {
                        Object field = this.fieldGroup.next();
                        this.fieldGroup.remove();
                        newGroup.getFields().add(field);
                    }
                    if (!this.forward) {
                        this.contents.next();
                    }
                    this.contents.add(o);
                    this.contents.add(newGroup);
                    this.fieldGroup = newGroup.getFields().listIterator();
                    this.forward = true;
                    ++this.index;
                }
                fail = false;
            }
            finally {
                FeaturesList.this.unlock(fail);
            }
        }
    }
}

