/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.classfile.Annotation;
import org.netbeans.modules.classfile.AnnotationComponent;
import org.netbeans.modules.classfile.ArrayElementValue;
import org.netbeans.modules.classfile.CPClassInfo;
import org.netbeans.modules.classfile.ClassElementValue;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.ElementValue;
import org.netbeans.modules.classfile.EnumElementValue;
import org.netbeans.modules.classfile.InnerClass;
import org.netbeans.modules.classfile.Method;
import org.netbeans.modules.classfile.NestedElementValue;
import org.netbeans.modules.classfile.Parameter;
import org.netbeans.modules.classfile.PrimitiveElementValue;
import org.netbeans.modules.classfile.Variable;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.parser.AnnotationInfo;
import org.netbeans.modules.javacore.parser.AnnotationTypeInfo;
import org.netbeans.modules.javacore.parser.AnnotationValueInfo;
import org.netbeans.modules.javacore.parser.ArrayRef;
import org.netbeans.modules.javacore.parser.AttributeInfo;
import org.netbeans.modules.javacore.parser.ClassInfo;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.EnumInfo;
import org.netbeans.modules.javacore.parser.FeatureInfo;
import org.netbeans.modules.javacore.parser.FieldInfo;
import org.netbeans.modules.javacore.parser.MethodInfo;
import org.netbeans.modules.javacore.parser.NameRef;
import org.netbeans.modules.javacore.parser.ParameterInfo;
import org.netbeans.modules.javacore.parser.PrimitiveTypeRef;
import org.netbeans.modules.javacore.parser.TypeParamInfo;
import org.netbeans.modules.javacore.parser.TypeParamRef;
import org.netbeans.modules.javacore.parser.TypeRef;
import org.netbeans.modules.javacore.parser.WildCardRef;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public final class ClassFileInfoUtil {
    private static final String NAME_CLASS_INIT = "<clinit>";
    private static final String NAME_INIT = "<init>";
    private static long javadocTT = 0L;
    private static long lastPrinted = 0L;
    private Map signature2parnames = null;
    private static Pattern pattern = Pattern.compile("\\<A NAME\\=\"([^\\)\"]+\\))");

    public ClassInfo createClassInfo(FileObject folder, String partName, int mods) {
        FileObject file = null;
        try {
            file = folder.getFileObject(partName.replace('.', '$'), "class");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (file == null) {
            return null;
        }
        return this.createClassInfo(folder, file, mods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInfo createClassInfo(FileObject folder, FileObject file, int mods) {
        NameRef[] interfaces;
        NameRef superName;
        ClassFile clsFile;
        try {
            InputStream is = file.getInputStream();
            try {
                clsFile = new ClassFile(is, true);
            }
            finally {
                is.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Inconsistent storage: class file for " + file.getNameExt() + " not created", ex);
        }
        String name = clsFile.getName().getExternalName();
        if (mods < 0) {
            mods = clsFile.getAccess() & 0xFFFFFFDF | (clsFile.isDeprecated() ? Integer.MIN_VALUE : 0);
        }
        boolean isInterface = (mods & 0x200) > 0;
        String typeSignature = clsFile.getTypeSignature();
        boolean isGeneric = typeSignature != null;
        TypeParamInfo[] tpi = null;
        if (isGeneric) {
            char[] sigChars = typeSignature.toCharArray();
            int[] pos = new int[]{0};
            tpi = ClassFileInfoUtil.parseTypeParams(sigChars, pos);
            superName = (NameRef)ClassFileInfoUtil.sigToTypeRef(sigChars, pos);
            ArrayList<TypeRef> list = new ArrayList<TypeRef>(6);
            while (pos[0] < sigChars.length) {
                list.add(ClassFileInfoUtil.sigToTypeRef(sigChars, pos));
            }
            interfaces = new NameRef[list.size()];
            list.toArray(interfaces);
        } else {
            ClassName className = clsFile.getSuperClass();
            superName = null;
            if (className != null) {
                superName = new NameRef(className.getExternalName(), null, null);
            }
            Collection coll = clsFile.getInterfaces();
            int size = coll.size();
            interfaces = new NameRef[size];
            Iterator iter = coll.iterator();
            int x = 0;
            while (iter.hasNext()) {
                interfaces[x] = new NameRef(((ClassName)iter.next()).getExternalName(), null, null);
                ++x;
            }
        }
        boolean isAnnotation = clsFile.isAnnotation();
        int methodCount = clsFile.getMethodCount();
        int fieldCount = clsFile.getVariableCount();
        Collection innerClasses = clsFile.getInnerClasses();
        ClassName clsName = clsFile.getName();
        ArrayList<FeatureInfo> featuresList = new ArrayList<FeatureInfo>(innerClasses.size() + methodCount + fieldCount);
        Iterator it = innerClasses.iterator();
        while (it.hasNext()) {
            FileObject fo;
            String fn;
            int index;
            InnerClass innerClass = (InnerClass)it.next();
            ClassName outerName = innerClass.getOuterClassName();
            if (!clsName.equals((Object)outerName) || (index = (fn = innerClass.getName().getSimpleName()).lastIndexOf(46) + 1) > 0 && fn.length() > index && Character.isDigit(fn.charAt(index)) || (fo = folder.getFileObject(fn = fn.replace('.', '$'), "class")) == null) continue;
            featuresList.add(this.createClassInfo(folder, fo, -1));
        }
        Iterator iter = clsFile.getMethods().iterator();
        for (int x = 0; x < methodCount; ++x) {
            Method method = (Method)iter.next();
            if (method.isSynthetic()) continue;
            if (isAnnotation) {
                featuresList.add(ClassFileInfoUtil.createAttributeInfo(method));
                continue;
            }
            featuresList.add(this.createMethodInfo(name, method, file));
        }
        ArrayList<Variable> enumConstants = new ArrayList<Variable>();
        iter = clsFile.getVariables().iterator();
        for (int x = 0; x < fieldCount; ++x) {
            Variable variable = (Variable)iter.next();
            if (variable.isSynthetic()) continue;
            if (variable.isEnumConstant()) {
                enumConstants.add(variable);
                continue;
            }
            featuresList.add(ClassFileInfoUtil.createFieldInfo(variable));
        }
        FeatureInfo[] features = new FeatureInfo[featuresList.size()];
        featuresList.toArray(features);
        AnnotationInfo[] annos = ClassFileInfoUtil.createAnnotations(clsFile.getAnnotations());
        if (clsFile.isEnum()) {
            ElementInfo[] constants = new ElementInfo[enumConstants.size()];
            Iterator it2 = enumConstants.iterator();
            int x = 0;
            while (it2.hasNext()) {
                Variable c = (Variable)it2.next();
                constants[x] = new FeatureInfo(null, 82, c.getName(), 0, null);
                ++x;
            }
            return new EnumInfo(null, 84, name, mods, features, interfaces, constants, annos);
        }
        if (isAnnotation) {
            return new AnnotationTypeInfo(null, 89, name, mods, features, annos);
        }
        return new ClassInfo(null, isInterface ? 37 : 13, name, mods, features, superName, interfaces, tpi, annos);
    }

    public FeatureInfo createMethodInfo(String className, Method method, FileObject file) {
        TypeRef type;
        int infoType;
        ParameterInfo[] params;
        String name = method.getName();
        int mods = method.getAccess() | (method.isDeprecated() ? Integer.MIN_VALUE : 0);
        AnnotationInfo[] annos = ClassFileInfoUtil.createAnnotations(method.getAnnotations());
        if (NAME_CLASS_INIT.equals(name)) {
            int infoType2 = (mods & 8) > 0 ? 56 : 36;
            return new FeatureInfo(null, infoType2, name, mods, annos);
        }
        char[] sig = method.getDescriptor().toCharArray();
        String typeSignature = method.getTypeSignature();
        char[] typeSig = typeSignature == null ? null : typeSignature.toCharArray();
        int[] pos = new int[]{1};
        TypeParamInfo[] tpi = null;
        if (typeSignature == null) {
            params = this.createParamsInfo(method, sig, pos, file);
        } else {
            pos[0] = 0;
            tpi = ClassFileInfoUtil.parseTypeParams(typeSig, pos);
            List list = ClassFileInfoUtil.getParamTypes(typeSig, pos);
            Iterator paramsIter = method.getParameters().iterator();
            Iterator iter = list.iterator();
            params = new ParameterInfo[list.size()];
            int x = 0;
            while (iter.hasNext()) {
                AnnotationInfo[] anns;
                String paramName;
                Parameter par;
                TypeRef type2 = (TypeRef)iter.next();
                boolean isVarArgs = !iter.hasNext() && method.isVarArgs();
                Parameter parameter = par = paramsIter.hasNext() ? (Parameter)paramsIter.next() : null;
                if (par == null) {
                    paramName = "";
                    anns = null;
                } else {
                    paramName = par.getName();
                    anns = ClassFileInfoUtil.createAnnotations(par.getAnnotations());
                }
                params[x] = new ParameterInfo(null, 30, paramName, false, type2, isVarArgs, anns);
                ++x;
            }
        }
        if (NAME_INIT.equals(name)) {
            infoType = 18;
            type = new NameRef(className, null, null);
            if (typeSignature == null) {
                ClassFileInfoUtil.sigToTypeRef(sig, pos);
            } else {
                pos[0] = pos[0] + 1;
                ClassFileInfoUtil.sigToTypeRef(typeSig, pos);
            }
        } else {
            infoType = 41;
            if (typeSignature == null) {
                type = ClassFileInfoUtil.sigToTypeRef(sig, pos);
            } else {
                pos[0] = pos[0] + 1;
                type = ClassFileInfoUtil.sigToTypeRef(typeSig, pos);
            }
        }
        TypeParamRef[] excNames = new TypeParamRef[]{};
        CPClassInfo[] exceptions = method.getExceptionClasses();
        if (exceptions.length > 0) {
            if (typeSignature != null) {
                ArrayList<TypeRef> list = new ArrayList<TypeRef>();
                while (pos[0] < typeSig.length) {
                    if (typeSig[pos[0]] == '^') {
                        pos[0] = pos[0] + 1;
                    }
                    list.add(ClassFileInfoUtil.sigToTypeRef(typeSig, pos));
                }
                excNames = list.toArray(excNames);
            }
            if (excNames.length == 0) {
                excNames = new TypeParamRef[exceptions.length];
                for (int x = 0; x < exceptions.length; ++x) {
                    excNames[x] = new NameRef(exceptions[x].getClassName().getExternalName(), null, null);
                }
            }
        }
        return new MethodInfo(null, infoType, name, mods, type, params, excNames, tpi, annos);
    }

    public static FieldInfo createFieldInfo(Variable field) {
        int mods = field.getAccess() | (field.isDeprecated() ? Integer.MIN_VALUE : 0);
        String name = field.getName();
        AnnotationInfo[] annos = ClassFileInfoUtil.createAnnotations(field.getAnnotations());
        String typeSignature = field.getTypeSignature();
        char[] signature = typeSignature != null ? typeSignature.toCharArray() : field.getDescriptor().toCharArray();
        int[] pos = new int[]{0};
        TypeRef type = ClassFileInfoUtil.sigToTypeRef(signature, pos);
        return new FieldInfo(null, 28, name, mods, type, -1, annos);
    }

    public static AttributeInfo createAttributeInfo(Method method) {
        int mods = method.getAccess() | (method.isDeprecated() ? Integer.MIN_VALUE : 0);
        String name = method.getName();
        AnnotationInfo[] annos = ClassFileInfoUtil.createAnnotations(method.getAnnotations());
        String desc = method.getDescriptor();
        int index = desc.indexOf(41);
        TypeRef type = ClassFileInfoUtil.sigToTypeRef(desc.substring(index + 1).toCharArray(), new int[]{0});
        ElementValue defValue = method.getAnnotationDefault();
        AnnotationValueInfo defaultValueInfo = defValue == null ? null : new AnnotationValueInfo(null, ClassFileInfoUtil.getElementValueType(defValue), name, ClassFileInfoUtil.resolveElementValue(defValue));
        return new AttributeInfo(null, 87, name, mods, type, defaultValueInfo, annos);
    }

    public static AnnotationInfo[] createAnnotations(Collection annos) {
        if (annos == null || annos.size() == 0) {
            return ElementInfo.EMPTY_ANNOTATIONS;
        }
        AnnotationInfo[] result = new AnnotationInfo[annos.size()];
        Iterator iter = annos.iterator();
        int x = 0;
        while (iter.hasNext()) {
            result[x] = ClassFileInfoUtil.annotationToInfo((Annotation)iter.next());
            ++x;
        }
        return result;
    }

    public static AnnotationInfo annotationToInfo(Annotation anno) {
        NameRef name = new NameRef(anno.getType().getExternalName(), null, null);
        AnnotationComponent[] comps = anno.getComponents();
        AnnotationValueInfo[] values = new AnnotationValueInfo[comps.length];
        for (int x = 0; x < comps.length; ++x) {
            values[x] = ClassFileInfoUtil.annotationComponentToInfo(comps[x]);
        }
        return new AnnotationInfo(null, 86, name, values);
    }

    public static AnnotationValueInfo annotationComponentToInfo(AnnotationComponent comp) {
        int infoType = ClassFileInfoUtil.getElementValueType(comp.getValue());
        return new AnnotationValueInfo(null, infoType, comp.getName(), ClassFileInfoUtil.resolveElementValue(comp.getValue()));
    }

    public static int getElementValueType(ElementValue elemValue) {
        int infoType = elemValue instanceof ArrayElementValue ? 4098 : (elemValue instanceof PrimitiveElementValue ? 4097 : (elemValue instanceof ClassElementValue ? 4097 : (elemValue instanceof EnumElementValue ? 4097 : 4096)));
        return infoType;
    }

    public static Object resolveElementValue(ElementValue elem) {
        if (elem instanceof ArrayElementValue) {
            ElementValue[] arrayValues = ((ArrayElementValue)elem).getValues();
            Object[] value = new Object[arrayValues.length];
            for (int x = 0; x < arrayValues.length; ++x) {
                value[x] = ClassFileInfoUtil.resolveElementValue(arrayValues[x]);
            }
            return value;
        }
        if (elem instanceof PrimitiveElementValue) {
            return ((PrimitiveElementValue)elem).getValue().getValue().toString();
        }
        if (elem instanceof ClassElementValue) {
            return ((ClassElementValue)elem).getClassName().getExternalName();
        }
        if (elem instanceof EnumElementValue) {
            return ((EnumElementValue)elem).getEnumName();
        }
        return ClassFileInfoUtil.annotationToInfo(((NestedElementValue)elem).getNestedValue());
    }

    public static NameRef sigToNameRef(char[] signature, int[] i, NameRef parent) {
        StringBuffer name = new StringBuffer();
        while (signature[i[0]] != ';' && signature[i[0]] != '<') {
            char ch = signature[i[0]];
            if (ch == '/' || ch == '$') {
                ch = '.';
            }
            if (name.length() > 0 || ch != '.') {
                name.append(ch);
            }
            i[0] = i[0] + 1;
        }
        if (signature[i[0]] == ';') {
            return new NameRef(name.toString(), (TypeParamRef)parent, null);
        }
        i[0] = i[0] + 1;
        ArrayList<TypeRef> typeParams = new ArrayList<TypeRef>(5);
        while (signature[i[0]] != '>') {
            char ch = signature[i[0]];
            if (ch == '*') {
                typeParams.add(new WildCardRef(false, null));
                i[0] = i[0] + 1;
                continue;
            }
            if (ch == '+' || ch == '-') {
                i[0] = i[0] + 1;
                TypeRef tr = ClassFileInfoUtil.sigToTypeRef(signature, i);
                typeParams.add(new WildCardRef(ch == '-', tr));
                continue;
            }
            typeParams.add(ClassFileInfoUtil.sigToTypeRef(signature, i));
        }
        i[0] = i[0] + 1;
        TypeRef[] typeRefs = new TypeRef[typeParams.size()];
        typeParams.toArray(typeRefs);
        return new NameRef(name.toString(), (TypeParamRef)parent, typeRefs);
    }

    public static TypeRef sigToTypeRef(char[] signature, int[] i) {
        char c = signature[i[0]];
        switch (c) {
            case 'B': {
                i[0] = i[0] + 1;
                return PrimitiveTypeRef.BYTE;
            }
            case 'C': {
                i[0] = i[0] + 1;
                return PrimitiveTypeRef.CHAR;
            }
            case 'D': {
                i[0] = i[0] + 1;
                return PrimitiveTypeRef.DOUBLE;
            }
            case 'F': {
                i[0] = i[0] + 1;
                return PrimitiveTypeRef.FLOAT;
            }
            case 'I': {
                i[0] = i[0] + 1;
                return PrimitiveTypeRef.INT;
            }
            case 'J': {
                i[0] = i[0] + 1;
                return PrimitiveTypeRef.LONG;
            }
            case 'T': {
                int pos;
                i[0] = i[0] + 1;
                StringBuffer buf = new StringBuffer(40);
                for (pos = i[0]; pos < signature.length && signature[pos] != ';'; ++pos) {
                    char ch = signature[pos];
                    if (ch == '/' || ch == '$') {
                        ch = '.';
                    }
                    buf.append(ch);
                }
                i[0] = pos + 1;
                return new TypeParamRef(buf.toString());
            }
            case 'L': {
                i[0] = i[0] + 1;
                NameRef nameRef = null;
                while (signature[i[0]] != ';') {
                    nameRef = ClassFileInfoUtil.sigToNameRef(signature, i, nameRef);
                }
                i[0] = i[0] + 1;
                return nameRef;
            }
            case 'S': {
                i[0] = i[0] + 1;
                return PrimitiveTypeRef.SHORT;
            }
            case 'V': {
                i[0] = i[0] + 1;
                return PrimitiveTypeRef.VOID;
            }
            case 'Z': {
                i[0] = i[0] + 1;
                return PrimitiveTypeRef.BOOLEAN;
            }
            case '[': {
                int dimCount = 0;
                while (signature[i[0]] == '[') {
                    ++dimCount;
                    i[0] = i[0] + 1;
                }
                return new ArrayRef((PrimitiveTypeRef)ClassFileInfoUtil.sigToTypeRef(signature, i), dimCount);
            }
            case ')': {
                i[0] = i[0] + 1;
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown signature: " + new String(signature) + ' ' + i[0]);
    }

    public static TypeParamInfo[] parseTypeParams(char[] sig, int[] i) {
        Iterator iter;
        ArrayList<TypeParamInfo> infos = new ArrayList<TypeParamInfo>();
        if (sig[0] == '<') {
            i[0] = 1;
            while (sig[i[0]] != '>') {
                StringBuffer id = new StringBuffer();
                while (sig[i[0]] != ':') {
                    id.append(sig[i[0]]);
                    i[0] = i[0] + 1;
                }
                if (sig[i[0] + 1] == ':') {
                    i[0] = i[0] + 1;
                }
                ArrayList<TypeRef> bounds = new ArrayList<TypeRef>();
                while (sig[i[0]] == ':') {
                    i[0] = i[0] + 1;
                    bounds.add(ClassFileInfoUtil.sigToTypeRef(sig, i));
                }
                TypeParamRef[] bds = new TypeParamRef[bounds.size()];
                iter = bounds.iterator();
                int x = 0;
                while (iter.hasNext()) {
                    bds[x] = (TypeParamRef)iter.next();
                    ++x;
                }
                infos.add(new TypeParamInfo(null, 77, id.toString(), bds));
            }
            i[0] = i[0] + 1;
        }
        TypeParamInfo[] tpi = new TypeParamInfo[infos.size()];
        iter = infos.iterator();
        int x = 0;
        while (iter.hasNext()) {
            tpi[x] = (TypeParamInfo)iter.next();
            ++x;
        }
        return tpi;
    }

    public static List getParamTypes(char[] signature, int[] pos) {
        ArrayList<TypeRef> params = new ArrayList<TypeRef>();
        pos[0] = pos[0] + 1;
        while (signature[pos[0]] != ')') {
            params.add(ClassFileInfoUtil.sigToTypeRef(signature, pos));
        }
        return params;
    }

    public ParameterInfo[] createParamsInfo(Method method, char[] signature, int[] pos, FileObject file) {
        TypeRef parType;
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        Iterator paramsIter = method.getParameters().iterator();
        int notKnownNames = 0;
        while ((parType = ClassFileInfoUtil.sigToTypeRef(signature, pos)) != null) {
            AnnotationInfo[] parameterAnnons;
            String parameterName;
            if (paramsIter.hasNext()) {
                Parameter par = (Parameter)paramsIter.next();
                parameterName = par.getName();
                parameterAnnons = ClassFileInfoUtil.createAnnotations(par.getAnnotations());
                if (parameterName.length() == 0) {
                    ++notKnownNames;
                }
            } else {
                parameterName = "";
                parameterAnnons = null;
            }
            ParameterInfo info = new ParameterInfo(null, 30, parameterName, false, parType, false, parameterAnnons);
            params.add(info);
        }
        ParameterInfo[] parInfos = params.toArray(new ParameterInfo[params.size()]);
        if (method.isVarArgs()) {
            parInfos[parInfos.length - 1] = new ParameterInfo(null, 30, parInfos[parInfos.length - 1].name, false, parInfos[parInfos.length - 1].type, true, parInfos[parInfos.length - 1].annotations);
        }
        if (notKnownNames > 0 && !this.getNamesFromJavaDoc(method, parInfos, file)) {
            this.computeArtificalNames(parInfos);
        }
        return parInfos;
    }

    private boolean getNamesFromJavaDoc(Method method, ParameterInfo[] parInfos, FileObject file) {
        long startT = 0L;
        if (JMManager.PERF_DEBUG) {
            startT = System.currentTimeMillis();
        }
        try {
            if (file.getFileSystem().getDisplayName().endsWith("rt.jar")) {
                if (JMManager.PERF_DEBUG && (javadocTT += System.currentTimeMillis() - startT) / 100L > lastPrinted) {
                    System.err.println("DEBUG: createParamsInfo()#javadoc-names " + javadocTT + " ms.");
                    ++lastPrinted;
                }
                return false;
            }
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().log(1, e.getMessage());
            return false;
        }
        if (this.signature2parnames == null) {
            this.signature2parnames = ClassFileInfoUtil.fillParametersMap(file);
        }
        if (this.signature2parnames != null) {
            String patternStr = ClassFileInfoUtil.getSignatureKey(method.getName(), parInfos);
            String[] names = (String[])this.signature2parnames.get(patternStr);
            if (names != null) {
                for (int i = 0; i < parInfos.length && i < names.length; ++i) {
                    parInfos[i] = new ParameterInfo(null, 30, new String(names[i]), parInfos[i].isFinal, parInfos[i].type, parInfos[i].isVarArg, parInfos[i].annotations);
                }
            }
            if (JMManager.PERF_DEBUG) {
                long deltaT = System.currentTimeMillis() - startT;
                System.err.println("PERF: createParamsInfo()#javadoc-names '" + method.getName() + "' took " + deltaT + " ms.");
                if ((javadocTT += deltaT) / 100L > lastPrinted) {
                    System.err.println("PERF: createParamsInfo()#javadoc-names " + javadocTT + " ms.");
                    ++lastPrinted;
                }
            }
            return true;
        }
        return false;
    }

    private void computeArtificalNames(ParameterInfo[] parInfos) {
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        Integer zero = new Integer(0);
        for (int i = 0; i < parInfos.length; ++i) {
            String name;
            Integer count;
            TypeRef pType = parInfos[i].type;
            if (pType == null) {
                pType = NameRef.java_lang_Object;
            }
            if ((count = (Integer)names.get(name = ClassFileInfoUtil.getName(pType))) != null) {
                names.put(name, new Integer(count + 1));
                name = name.concat(count.toString());
            } else {
                names.put(name, zero);
            }
            parInfos[i] = new ParameterInfo(null, 30, name, parInfos[i].isFinal, parInfos[i].type, parInfos[i].isVarArg, parInfos[i].annotations);
        }
    }

    private static String getName(TypeRef pType) {
        if (pType instanceof ArrayRef) {
            return ClassFileInfoUtil.getName(((ArrayRef)pType).parent);
        }
        if (pType instanceof TypeParamRef) {
            String loweredName;
            String name = pType.getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(index + 1);
            }
            return Utilities.isJavaIdentifier((String)(loweredName = name.substring(0, 1).toLowerCase().concat(name.substring(1)))) ? loweredName : 'a' + name;
        }
        if (pType instanceof PrimitiveTypeRef) {
            return pType.getName().substring(0, 1);
        }
        if (pType instanceof WildCardRef) {
            return ClassFileInfoUtil.getName(((WildCardRef)pType).bound);
        }
        throw new IllegalArgumentException("Uknow type " + pType.getClass());
    }

    private static String getSignatureKey(String methodName, ParameterInfo[] parInfo) {
        StringBuffer result = new StringBuffer();
        result.append(methodName).append("(");
        for (int i = 0; i < parInfo.length; ++i) {
            String typeName = parInfo[i].type.getName();
            result.append(typeName);
            if (i + 1 < parInfo.length) {
                result.append(", ");
                continue;
            }
            result.append(")");
        }
        return result.toString();
    }

    private static String[] obtainNames(int offset, String htmlContent) {
        int startOffset = htmlContent.indexOf("<PRE>", offset) + 5;
        if (startOffset < 5) {
            return new String[0];
        }
        int endOffset = htmlContent.indexOf(")", startOffset) + 1;
        if (endOffset <= 0) {
            return new String[0];
        }
        String preSection = htmlContent.substring(startOffset, endOffset);
        startOffset = 0;
        endOffset = preSection.length() - 1;
        startOffset = preSection.indexOf("&nbsp;", 0);
        ArrayList<String> names = new ArrayList<String>(3);
        int mark = startOffset;
        while (startOffset != -1 && startOffset < endOffset) {
            mark = startOffset + 6;
            if ((startOffset = preSection.indexOf(",", mark)) == -1 || startOffset >= endOffset) {
                startOffset = endOffset;
            }
            names.add(preSection.substring(mark, startOffset));
            startOffset = preSection.indexOf("&nbsp;", startOffset);
        }
        return names.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(FileObject aFile) throws FileNotFoundException, IOException {
        int size = (int)aFile.getSize();
        byte[] b = new byte[size];
        InputStream is = null;
        try {
            is = aFile.getInputStream();
            is.read(b);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {}
        }
        return new String(b);
    }

    private static FileObject getJavadocFile(FileObject file) {
        JavadocForBinaryQuery.Result res;
        ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/execute");
        if (cp == null) {
            return null;
        }
        try {
            FileObject cpRoot = cp.findOwnerRoot(file);
            if (cpRoot == null) {
                return null;
            }
            res = JavadocForBinaryQuery.findJavadoc((URL)cpRoot.getURL());
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().log(1, e.getMessage());
            return null;
        }
        URL[] url = res.getRoots();
        if (url.length > 0) {
            for (int i = 0; i < url.length; ++i) {
                FileObject rootDoc = URLMapper.findFileObject((URL)url[i]);
                if (rootDoc == null) continue;
                String html = cp.getResourceName(file);
                html = html.substring(0, html.length() - 5).replace('$', '.') + "html";
                return rootDoc.getFileObject(html);
            }
        }
        return null;
    }

    public static Map fillParametersMap(FileObject file) {
        long startT = 0L;
        if (JMManager.PERF_DEBUG) {
            startT = System.currentTimeMillis();
        }
        HashMap<String, String[]> pars = null;
        try {
            FileObject htmlFile = ClassFileInfoUtil.getJavadocFile(file);
            if (htmlFile == null) {
                return null;
            }
            pars = new HashMap<String, String[]>();
            String htmlContent = ClassFileInfoUtil.getContents(htmlFile);
            Matcher m = pattern.matcher(htmlContent);
            while (m.find()) {
                int start = m.start(1);
                int end = m.end(1);
                String[] names = ClassFileInfoUtil.obtainNames(start, htmlContent);
                pars.put(htmlContent.substring(start, end), names);
            }
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
        if (JMManager.PERF_DEBUG) {
            long deltaT = System.currentTimeMillis() - startT;
            System.err.println("Map for file '" + file.getName() + "' was filled in " + deltaT + " ms.");
        }
        return pars;
    }
}

