/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.jmi.javamodel.Codebase;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.ExclusiveMutex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.ProgressDisplayer;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.scanning.ClassUpdater;
import org.netbeans.modules.javacore.scanning.FileEntry;
import org.netbeans.modules.javacore.scanning.FileInfo;
import org.netbeans.modules.javacore.scanning.JavaUpdater;
import org.netbeans.modules.javacore.scanning.ZipArchiveInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class FileScanner {
    private ClassUpdater classUpdater;
    private JavaUpdater javaUpdater;
    private File root;
    private String offset;
    private Codebase codebase;
    private JavaModelPackage mofPackage;
    private Collection resources;
    private Collection resourcesToScan;
    private boolean zipFile;
    private final ExclusiveMutex mutex;
    private static HashSet ignoredDirectories;
    private static HashSet ignoredPackages;
    private static HashSet eagerlyParse;
    private final boolean isRescan;
    private static final boolean DEBUG = false;
    private static ProgressDisplayer progress;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileScanner(URL _root, String sourceLevel, Codebase cb) throws IllegalArgumentException {
        this(_root, sourceLevel, cb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileScanner(URL _root, String sourceLevel, Codebase cb, boolean isRescan) throws IllegalArgumentException {
        Class clazz = FileScanner.class;
        synchronized (clazz) {
            if (ignoredPackages == null) {
                ignoredPackages = FileScanner.parseSet("org.netbeans.javacore.ignorePackages", "sun sunw");
                ignoredDirectories = FileScanner.parseSet("org.netbeans.javacore.ignoreDirectories", "SCCS CVS");
                eagerlyParse = FileScanner.parseSet("org.netbeans.javacore.eagerlyParse", "javax/swing/JFrame.java");
            }
        }
        this.isRescan = isRescan;
        if ("jar".equals(_root.getProtocol())) {
            String strUrl = _root.toExternalForm();
            int index = strUrl.lastIndexOf("!/") + 2;
            if (!($assertionsDisabled || index > 0 && index <= strUrl.length())) {
                throw new AssertionError((Object)"Invalid jar protocol URL");
            }
            this.offset = index == strUrl.length() ? null : strUrl.substring(index);
            _root = FileUtil.getArchiveFile((URL)_root);
            this.zipFile = true;
        }
        if (!"file".equals(_root.getProtocol())) {
            throw new IllegalArgumentException("The URL: " + _root.toExternalForm() + " has no file protocol.");
        }
        URI uri = URI.create(_root.toExternalForm());
        this.root = new File(uri);
        this.codebase = cb;
        this.mofPackage = (JavaModelPackage)this.codebase.refImmediatePackage();
        this.mutex = JMManager.getTransactionMutex();
        if (!isRescan) {
            this.javaUpdater = new JavaUpdater(this.mofPackage, sourceLevel, this);
        }
        this.classUpdater = new ClassUpdater(this.mofPackage);
    }

    private static HashSet parseSet(String propertyName, String defaultValue) {
        StringTokenizer st = new StringTokenizer(System.getProperty(propertyName, defaultValue), " \t\n\r\f,-:+!");
        HashSet<String> result = new HashSet<String>();
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    void checkParseEagerly(Resource resource) {
        if (eagerlyParse.contains(resource.getName())) {
            if (this.resourcesToScan == null) {
                this.resourcesToScan = new ArrayList(eagerlyParse.size());
            }
            this.resourcesToScan.add(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource[] scan() {
        NBMDRepositoryImpl repository = (NBMDRepositoryImpl)JavaMetamodel.getDefaultRepository();
        if (!this.isRescan) {
            repository.disableEvents();
        }
        this.resourcesToScan = null;
        ZipArchiveInfo zipInfo = null;
        try {
            FileInfo rootInfo;
            ClassIndex index = null;
            if (this.zipFile) {
                long jarTime;
                long oldTime = this.codebase.getTimestamp();
                index = ClassIndex.getIndex(this.mofPackage);
                if (oldTime != 0L && oldTime == (jarTime = this.root.lastModified()) && index.getTimestamp() >= jarTime) {
                    Resource[] resourceArray = new Resource[]{};
                    return resourceArray;
                }
                try {
                    zipInfo = new ZipArchiveInfo(this.root, this.offset);
                    rootInfo = zipInfo.getRootFileInfo();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                    Resource[] resourceArray = null;
                    try {
                        if (zipInfo != null) {
                            zipInfo.close();
                        }
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    return resourceArray;
                }
            }
            rootInfo = new FileEntry(this.root, "");
            this.resources = new HashSet(this.mofPackage.getResource().refAllOfClass());
            this.scanPackage(rootInfo, "", new HashSet());
            if (this.zipFile) {
                if (index != null) {
                    index.setTimestamp();
                }
                this.codebase.setTimestamp(this.root.lastModified());
                this.codebase.setLibrary(true);
            }
            this.removeFromRepository();
            Resource[] resourceArray = this.resourcesToScan == null ? new Resource[]{} : this.resourcesToScan.toArray(new Resource[this.resourcesToScan.size()]);
            return resourceArray;
        }
        finally {
            try {
                if (zipInfo != null) {
                    zipInfo.close();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private void removeFromRepository() {
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            ((Resource)i.next()).refDelete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanPackage(FileInfo directory, String pack, Set visited) {
        if (ignoredPackages.contains(pack)) {
            return;
        }
        String canonicalName = directory.getCanonicalName();
        if (canonicalName != null && !visited.add(canonicalName)) {
            return;
        }
        FileInfo[] files = directory.listFiles();
        HashMap<String, FileInfo> javaFiles = new HashMap<String, FileInfo>();
        HashMap<String, FileInfo> classFiles = new HashMap<String, FileInfo>();
        for (int i = 0; i < files.length; ++i) {
            FileInfo fo = files[i];
            String name = fo.getName();
            if (fo.isDirectory()) {
                if (ignoredDirectories.contains(name) || !Utilities.isJavaIdentifier((String)name)) continue;
                if (this.mutex.isSwingWaiting()) {
                    NBMDRepositoryImpl rep = (NBMDRepositoryImpl)JMManager.getDefaultRepository();
                    try {
                        rep.endTrans();
                        while (this.mutex.isSwingWaiting()) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    finally {
                        rep.beginTrans(true);
                        if (!this.isRescan) {
                            rep.disableEvents();
                        }
                    }
                }
                String newpack = pack;
                if (pack.length() != 0) {
                    newpack = pack.concat(".");
                }
                newpack = newpack.concat(name);
                this.scanPackage(fo, newpack, visited);
                continue;
            }
            if (name == null) continue;
            if (name.endsWith(".java")) {
                javaFiles.put(name, fo);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            classFiles.put(name, fo);
        }
        if (!javaFiles.isEmpty() || !classFiles.isEmpty()) {
            if (this.isRescan) {
                Iterator resIt = javaFiles.values().iterator();
                ArrayList resList = new ArrayList();
                while (resIt.hasNext()) {
                    FileInfo file = (FileInfo)resIt.next();
                    try {
                        String name = file.getPath();
                        long timestamp = file.lastModified();
                        ResourceImpl resource = (ResourceImpl)((ResourceClassImpl)this.mofPackage.getResource()).resolveResource(name, true, false);
                        if (resource.getTimestamp() != timestamp) {
                            FileObject fobj = JavaMetamodel.getManager().getFileObject(resource);
                            if (fobj == null || !fobj.isValid()) continue;
                            this.resources.remove((Object)resource);
                            resource.updateFromFileObject(fobj, true);
                            continue;
                        }
                        this.resources.remove((Object)resource);
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            } else {
                progress = ProgressDisplayer.getVisibleProgressDisplayer();
                if (progress != null) {
                    progress.updatePackage(pack);
                }
                this.resources.removeAll(this.javaUpdater.updateResources(javaFiles));
            }
            this.resources.removeAll(this.classUpdater.updateResources(javaFiles, classFiles));
        }
    }

    static {
        $assertionsDisabled = !FileScanner.class.desiredAssertionStatus();
    }
}

