/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.ejb;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.impl.ejb.EjbBuilderUtil;
import org.netbeans.modules.j2ee.metadata.NNModelBuilder;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbAnnotationListener
extends NNModelBuilder {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance(EjbAnnotationListener.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(1);
    private static final String PATH_TO_SESSION = "EnterpriseBeans/Session#EjbClass=$JAVACLASS";
    private static final String PATH_TO_MESSAGE_DRIVEN = "EnterpriseBeans/MessageDriven#EjbClass=$JAVACLASS";
    private static final String ENV_ENTRY = "/EnvEntry#EnvEntryName=$MEMBER;!name=EnvEntryName;!type=EnvEntryType";
    private static final String RES_REF_ENTRY = "/ResourceRef#ResRefName=$MEMBER;ResType=$MEMBERCLASS;!name=ResRefName;!type=ResType";
    private static final String SERVICE_REF_ENTRY = "/ServiceRef#ServiceRefName=$JAVA_CLASS-MEMBER;!name=ServiceRefName";
    private static final String RES_ENV_REF_ENTRY = "/ResourceEnvRef#ResourceEnvRefName=$MEMBER!;name=ResourceEnvRefName;!type=ResourceEnvRefType";
    private static final String MSG_DEST_ENTRY = "/MessageDestinationRef#MessageDestinationRefName=$MEMBER;!name=MessageDestinationRefName";
    private static final String RES_KEY_PART = "javax.annotation.Resource#$MEMBERCLASS=";
    private static final Collection<String> primaryAnnotations = Arrays.asList("javax.ejb.Stateful", "javax.ejb.Stateless", "javax.ejb.MessageDriven");
    private Map<String, String> nn2ModelMapping;
    private EjbBuilderUtil util;
    private ClassPath cp;

    public EjbAnnotationListener(EjbJar ejbJar, ClassPath cp) {
        super((BaseBean)ejbJar);
        this.util = new EjbBuilderUtil(ejbJar);
        this.cp = cp;
        this.initNN2ModelMapping();
        if (LOG) {
            this.dumpMappings();
        }
    }

    public ClassPath getClassPath() {
        return this.cp;
    }

    public Collection<String> getPrimaryAnnotations() {
        return primaryAnnotations;
    }

    public Map<String, String> getAnnotation2ModelMapping() {
        return this.nn2ModelMapping;
    }

    public void classRemoved(String fqn) {
        Ejb ejb = this.util.getSession(fqn);
        if (ejb == null) {
            ejb = this.util.getMessageDriven(fqn);
        }
        if (ejb != null) {
            this.util.getEnterpriseBeans().removeEjb(ejb);
        }
        this.handleEJBInterfaceRemove(fqn);
    }

    private void handleEJBInterfaceRemove(String fqn) {
        for (Session sessionBean : this.util.getEnterpriseBeans().getSession()) {
            if (fqn.equals(sessionBean.getLocal())) {
                sessionBean.setLocal(null);
            }
            if (fqn.equals(sessionBean.getRemote())) {
                sessionBean.setRemote(null);
            }
            try {
                for (String businessLocal : sessionBean.getBusinessLocal()) {
                    if (!fqn.equals(businessLocal)) continue;
                    sessionBean.removeBusinessLocal(businessLocal);
                }
                for (String remote : sessionBean.getBusinessRemote()) {
                    if (!fqn.equals(remote)) continue;
                    sessionBean.removeBusinessRemote(remote);
                }
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    public void addClassAnnotation(JavaClass javaClass, Annotation annotation, AnnotationType t) {
        super.addClassAnnotation(javaClass, annotation, t);
        String annotationClass = t.getName();
        if ("javax.ejb.Stateless".equals(annotationClass)) {
            try {
                this.util.handleInterfaces(javaClass);
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        } else if ("javax.ejb.Stateful".equals(annotationClass)) {
            try {
                this.util.handleInterfaces(javaClass);
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        } else if ("javax.ejb.MessageDriven".equals(annotationClass)) {
            this.util.handleMessageDriven(javaClass, annotation);
        } else if ("javax.ejb.Local".equals(annotationClass)) {
            this.util.updateLocal(javaClass);
        } else if ("javax.ejb.Remote".equals(annotationClass)) {
            this.util.updateRemote(javaClass);
        }
    }

    public void addMemberAnnotation(boolean field, JavaClass javaClass, Element member, Annotation annotation, AnnotationType t) {
        Session session;
        String annotationClass = t.getName();
        if ("javax.ejb.EJB".equals(annotationClass) && (session = EjbBuilderUtil.findReferencedSessionBean((TypedElement)member, annotation)) != null) {
            HashMap<String, String> imaps = new HashMap<String, String>();
            if (EjbBuilderUtil.exposesLocalInterface(session, ((TypedElement)member).getType().getName())) {
                imaps.put("javax.ejb.EJB", "/EjbLocalRef#EjbRefName=$JAVA_CLASS-MEMBER;!name=EjbRefName");
            } else {
                imaps.put("javax.ejb.EJB", "/EjbRef#EjbRefName=$JAVA_CLASS-MEMBER;!name=EjbRefName");
            }
            this.generateItemsMappings(PATH_TO_SESSION, PATH_TO_SESSION, this.nn2ModelMapping, imaps);
            this.generateItemsMappings(PATH_TO_MESSAGE_DRIVEN, PATH_TO_MESSAGE_DRIVEN, this.nn2ModelMapping, imaps);
        }
        super.addMemberAnnotation(field, javaClass, member, annotation, t);
        if ("javax.xml.ws.WebServiceRef".equals(annotationClass)) {
            this.util.webServiceRefNNAdded(javaClass, member, annotation);
        }
    }

    private void initNN2ModelMapping() {
        this.nn2ModelMapping = new HashMap<String, String>();
        HashMap<String, String> imaps = new HashMap<String, String>();
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=java.lang.String", ENV_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=java.lang.Character", ENV_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=java.lang.Integer", ENV_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=java.lang.Boolean", ENV_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=java.lang.Double", ENV_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=java.lang.Byte", ENV_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=java.lang.Short", ENV_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=java.lang.Long", ENV_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=java.lang.Float", ENV_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.xml.rpc.Service", SERVICE_REF_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.sql.DataSource", RES_REF_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.jms.ConnectionFactory", RES_REF_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.jms.QueueConnectionFactory", RES_REF_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.jms.TopicConnectionFactory", RES_REF_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.mail.Session", RES_REF_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.net.URL", RES_REF_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.resource.cci.ConnectionFactory", RES_REF_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=org.omg.CORBA_2_3.ORB", RES_REF_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.jms.Queue", MSG_DEST_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.jms.Topic", MSG_DEST_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.resource.cci.InteractionSpec", RES_ENV_REF_ENTRY);
        imaps.put("javax.annotation.Resource#$MEMBERCLASS=javax.transaction.UserTransaction", RES_ENV_REF_ENTRY);
        imaps.put("javax.ejb.EJB", "");
        imaps.put("javax.xml.ws.WebServiceRef", "/ServiceRef#ServiceRefName=$JAVA_CLASS-MEMBER;!name=ServiceRefName;!wsdlLocation=<CUSTOM>;!value=<CUSTOM>;!type=<CUSTOM>");
        this.generateItemsMappings(PATH_TO_SESSION, PATH_TO_SESSION, this.nn2ModelMapping, imaps);
        this.generateItemsMappings(PATH_TO_MESSAGE_DRIVEN, PATH_TO_MESSAGE_DRIVEN, this.nn2ModelMapping, imaps);
        this.nn2ModelMapping.put("javax.ejb.Stateless", "EnterpriseBeans/Session#EjbClass=$JAVACLASS;!name=ejbName;SessionType=Stateless");
        this.nn2ModelMapping.put("javax.ejb.Stateful", "EnterpriseBeans/Session#EjbClass=$JAVACLASS;!name=ejbName;SessionType=Stateful");
        this.nn2ModelMapping.put("javax.ejb.MessageDriven", "EnterpriseBeans/MessageDriven#EjbClass=$JAVACLASS;!name=ejbName");
        this.nn2ModelMapping.put("javax.ejb.Remote", "");
        this.nn2ModelMapping.put("javax.ejb.Local", "");
    }

    private void generateItemsMappings(String condition, String mappingPrefix, Map<String, String> mappings, Map<String, String> items) {
        for (String key : items.keySet()) {
            String value = items.get(key);
            mappings.put(key + "?" + condition, mappingPrefix + value);
        }
    }

    private void dumpMappings() {
        LOGGER.log(1, "EJB NN model builder mappings:\n==============================\n");
        for (String key : this.getAnnotation2ModelMapping().keySet()) {
            String val = this.getAnnotation2ModelMapping().get(key);
            LOGGER.log(1, key + " -> " + val);
        }
    }
}

