/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.visitor.ChildVisitor;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNamespaceVisitor
extends ChildVisitor {
    private Map<Integer, String> namespaceMap = new HashMap<Integer, String>();
    private Document root = null;
    private List<Map<String, String>> ancestorNamespaceMaps = new ArrayList<Map<String, String>>();
    int nodeCtr;

    public FindNamespaceVisitor(Document root) {
        this.root = root;
    }

    public String findNamespace(Node target) {
        if (!(target instanceof Element) && !(target instanceof Attribute)) {
            return null;
        }
        return this.getNamespaceMap().get(target.getId());
    }

    public Map<Integer, String> getNamespaceMap() {
        if (this.namespaceMap.isEmpty()) {
            this.nodeCtr = 0;
            this.visit(this.root);
        }
        return this.namespaceMap;
    }

    @Override
    protected void visitNode(Node node) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        if (node instanceof Element || node instanceof Attribute) {
            ++this.nodeCtr;
            boolean found = false;
            String prefix = node.getPrefix();
            if (prefix == null) {
                if (node instanceof Attribute) {
                    return;
                }
                prefix = "";
            }
            if (node instanceof Element && node.hasAttributes()) {
                NamedNodeMap attrMap = node.getAttributes();
                for (int i = 0; i < attrMap.getLength(); ++i) {
                    Attribute attribute = (Attribute)attrMap.item(i);
                    if (!"xmlns".equals(attribute.getPrefix()) && !"xmlns".equals(attribute.getName())) continue;
                    String key = attribute.getPrefix() == null ? "" : attribute.getLocalName();
                    String value = attribute.getValue();
                    namespaces.put(key, value);
                    if (!key.equals(prefix)) continue;
                    this.namespaceMap.put(node.getId(), value);
                    found = true;
                }
            }
            if (!found) {
                for (Map<String, String> map : this.ancestorNamespaceMaps) {
                    if (!map.containsKey(prefix)) continue;
                    this.namespaceMap.put(node.getId(), map.get(prefix));
                    break;
                }
            }
        }
        if (!namespaces.isEmpty()) {
            this.ancestorNamespaceMaps.add(0, namespaces);
        }
        super.visitNode(node);
        this.ancestorNamespaceMaps.remove(namespaces);
    }
}

