/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.ChildVisitor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class FlushVisitor
extends ChildVisitor {
    private StringBuilder buffer;

    public String flushModel(Document root) {
        this.buffer = new StringBuilder();
        root.accept(this);
        return this.buffer.toString();
    }

    public String flush(NodeList children) {
        this.buffer = new StringBuilder();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = (Node)children.item(i);
            child.accept(this);
        }
        return this.buffer.toString();
    }

    public void visit(Element e) {
        Node l;
        int i;
        Token token;
        ListIterator<Token> tokensIter = e.getTokens().listIterator();
        while (tokensIter.hasNext()) {
            token = tokensIter.next();
            this.buffer.append(token.getValue());
            if (token.getType() != TokenType.TOKEN_ELEMENT_START_TAG) continue;
            break;
        }
        if (e.hasAttributes()) {
            NamedNodeMap attributes = e.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                l = (Node)attributes.item(i);
                l.accept(this);
            }
        }
        while (tokensIter.hasNext()) {
            token = tokensIter.next();
            this.buffer.append(token.getValue());
            if (token.getType() != TokenType.TOKEN_ELEMENT_END_TAG) continue;
            break;
        }
        if (e.hasChildNodes()) {
            NodeList children = e.getChildNodes();
            for (i = 0; i < children.getLength(); ++i) {
                l = (Node)children.item(i);
                if (l instanceof Attribute) continue;
                l.accept(this);
            }
        }
        while (tokensIter.hasNext()) {
            this.buffer.append(tokensIter.next().getValue());
        }
    }

    protected void visitNode(Node node) {
        List<Token> tokens = ((NodeImpl)node).getTokens();
        for (Token token : tokens) {
            this.buffer.append(token.getValue());
        }
        super.visitNode(node);
    }
}

