/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.options.ui.ListModel;
import org.netbeans.modules.options.ui.TabbedPanel;

public class TabbedListPanel
extends TabbedPanel {
    public TabbedListPanel(ListModel model, int expansionPolicy) {
        super(model, expansionPolicy, true);
        this.addActionListener(new Listener());
    }

    public JList getSelectedList() {
        JComponent c = this.getSelectedComponent();
        if (c == null) {
            return null;
        }
        if (c instanceof JList) {
            return (JList)c;
        }
        return (JList)((JScrollPane)c).getViewport().getView();
    }

    public int getSelectedListIndex() {
        JList l = this.getSelectedList();
        if (l == null) {
            return -1;
        }
        return l.getSelectedIndex();
    }

    public void refreshPanels() {
        super.refreshPanels();
    }

    public void setSelectedListIndex(int index) {
        JList l = this.getSelectedList();
        if (l == null) {
            return;
        }
        l.setSelectedIndex(index);
    }

    public Object getSelectedListItem() {
        JList l = this.getSelectedList();
        if (l == null) {
            return null;
        }
        return l.getSelectedValue();
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener {
        private JList currentList;

        Listener() {
            this.currentList = TabbedListPanel.this.getSelectedList();
            if (this.currentList != null) {
                this.currentList.addListSelectionListener(this);
            }
        }

        public void actionPerformed(ActionEvent e) {
            JList l = TabbedListPanel.this.getSelectedList();
            if (l == this.currentList) {
                return;
            }
            if (this.currentList != null) {
                this.currentList.removeListSelectionListener(this);
            }
            this.currentList = l;
            if (this.currentList != null) {
                this.currentList.addListSelectionListener(this);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            TabbedListPanel.this.fireActionPerformed(new ActionEvent(TabbedListPanel.this, 0, "selectedIndex"));
        }
    }
}

