/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.Map;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.javahelp.AbstractHelp;
import org.netbeans.modules.javahelp.HelpAction;
import org.netbeans.modules.javahelp.Installer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class JavaHelp
extends AbstractHelp
implements AWTEventListener {
    private HelpSet master = null;
    private Map availableJHelps = new HashMap();
    private JFrame frameViewer = null;
    private JDialog dialogViewer = null;
    private boolean reparentToFrameLater = false;
    private Stack currentModalDialogs = new Stack();
    private boolean currentModalDialogsReady = false;
    private JHelp lastJH = null;
    private static final BoundedRangeModel mergeModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
    private ProgressHandle progressHandle = null;
    private static RequestProcessor helpLoader = null;
    private static int modalExcludedSupported = -1;

    public JavaHelp() {
        Installer.err.log("JavaHelp created");
        if (!JavaHelp.isModalExcludedSupported()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    void deactivate() {
        if (!JavaHelp.isModalExcludedSupported()) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
    }

    private synchronized HelpSet getMaster() {
        if (this.master == null) {
            ClassLoader loader = JavaHelp.class.getClassLoader();
            try {
                HelpSet hs;
                this.master = new HelpSet(loader, new URL("nbresloc:/org/netbeans/modules/javahelp/resources/masterHelpSet.xml"));
                Collection sets = this.getHelpSets();
                ArrayList<HelpSet> toMerge = new ArrayList<HelpSet>(Math.min(1, sets.size()));
                Iterator it = sets.iterator();
                while (it.hasNext()) {
                    hs = (HelpSet)it.next();
                    if (!this.shouldMerge(hs)) continue;
                    toMerge.add(hs);
                }
                mergeModel.setValue(0);
                mergeModel.setMaximum(toMerge.size());
                it = toMerge.iterator();
                while (it.hasNext()) {
                    hs = (HelpSet)it.next();
                    this.master.add(hs);
                    mergeModel.setValue(mergeModel.getValue() + 1);
                }
            }
            catch (HelpSetException hse) {
                Installer.err.notify((Throwable)hse);
                this.master = new HelpSet();
            }
            catch (MalformedURLException mfue) {
                mfue.printStackTrace();
                throw new IllegalStateException();
            }
        }
        return this.master;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void helpSetsChanged() {
        JavaHelp javaHelp = this;
        synchronized (javaHelp) {
            this.master = null;
        }
        mergeModel.setValue(0);
        mergeModel.setMaximum(0);
        super.helpSetsChanged();
    }

    private Dialog currentModalDialog() {
        if (this.currentModalDialogs.empty()) {
            Window w = HelpAction.WindowActivatedDetector.getCurrentActivatedWindow();
            if (!this.currentModalDialogsReady && w instanceof Dialog && !(w instanceof ProgressDialog) && w != this.dialogViewer && ((Dialog)w).isModal()) {
                Installer.err.log("Early-opened modal dialog: " + w.getName() + " [" + ((Dialog)w).getTitle() + "]");
                return (Dialog)w;
            }
            return null;
        }
        return (Dialog)this.currentModalDialogs.peek();
    }

    private void ensureFrameViewer() {
        Installer.err.log("ensureFrameViewer");
        if (this.frameViewer == null) {
            Installer.err.log("\tcreating new");
            this.frameViewer = new JFrame();
            this.frameViewer.setIconImage(Utilities.loadImage((String)"org/netbeans/modules/javahelp/resources/help.gif"));
            this.frameViewer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)JavaHelp.class, (String)"ACSD_JavaHelp_viewer"));
            if (JavaHelp.isModalExcludedSupported()) {
                JavaHelp.setModalExcluded(this.frameViewer);
                this.frameViewer.getRootPane().putClientProperty("netbeans.helpframe", Boolean.TRUE);
            }
        }
    }

    private void ensureDialogViewer() {
        Installer.err.log("ensureDialogViewer");
        Dialog parent = this.currentModalDialog();
        if (this.dialogViewer != null && this.dialogViewer.getOwner() != parent) {
            Installer.err.log("\tdisposing old");
            this.dialogViewer.setVisible(false);
            this.dialogViewer.dispose();
            this.dialogViewer = null;
        }
        if (this.dialogViewer == null) {
            Installer.err.log("\tcreating new");
            this.dialogViewer = new JDialog(parent);
            this.dialogViewer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)JavaHelp.class, (String)"ACSD_JavaHelp_viewer"));
        }
    }

    private void displayHelpInFrame(JHelp jh) {
        Installer.err.log("displayHelpInFrame");
        if (jh == null) {
            jh = this.lastJH;
        }
        if (jh == null) {
            throw new IllegalStateException();
        }
        boolean newFrameViewer = this.frameViewer == null;
        this.ensureFrameViewer();
        if (this.dialogViewer != null) {
            Installer.err.log("\tdisposing old dialog");
            this.dialogViewer.setVisible(false);
            this.dialogViewer.getContentPane().removeAll();
            this.dialogViewer.dispose();
            this.dialogViewer = null;
        }
        if (this.frameViewer.getContentPane().getComponentCount() > 0 && this.frameViewer.getContentPane().getComponent(0) != jh) {
            Installer.err.log("\treplacing content");
            this.frameViewer.getContentPane().removeAll();
        }
        if (this.frameViewer.getContentPane().getComponentCount() == 0) {
            Installer.err.log("\tadding content");
            this.frameViewer.getContentPane().add((Component)jh, "Center");
            this.frameViewer.setTitle(jh.getModel().getHelpSet().getTitle());
            this.frameViewer.pack();
        }
        if (newFrameViewer) {
            Dimension screenSize = Utilities.getUsableScreenBounds().getSize();
            Dimension frameSize = this.frameViewer.getSize();
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
                this.frameViewer.setSize(frameSize);
            }
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
                this.frameViewer.setSize(frameSize);
            }
            this.frameViewer.setLocation(new Point(screenSize.width - this.frameViewer.getSize().width, 0));
        }
        this.frameViewer.setState(0);
        if (this.frameViewer.isVisible()) {
            this.frameViewer.repaint();
            this.frameViewer.toFront();
            Installer.err.log("\talready visible, just repainting");
        } else {
            this.frameViewer.setVisible(true);
        }
        this.lastJH = jh;
    }

    private void displayHelpInDialog(JHelp jh) {
        Installer.err.log("displayHelpInDialog");
        if (jh == null) {
            jh = this.lastJH;
        }
        if (jh == null) {
            throw new IllegalStateException();
        }
        this.ensureDialogViewer();
        Rectangle bounds = null;
        if (this.frameViewer != null) {
            Installer.err.log("\thiding old frame viewer");
            if (this.frameViewer.isVisible()) {
                bounds = this.frameViewer.getBounds();
                this.frameViewer.setVisible(false);
            }
            this.frameViewer.getContentPane().removeAll();
        }
        if (this.dialogViewer.getContentPane().getComponentCount() > 0 && this.dialogViewer.getContentPane().getComponent(0) != jh) {
            Installer.err.log("\tchanging content");
            this.dialogViewer.getContentPane().removeAll();
        }
        if (this.dialogViewer.getContentPane().getComponentCount() == 0) {
            Installer.err.log("\tadding content");
            this.dialogViewer.getContentPane().add((Component)jh, "Center");
            this.dialogViewer.setTitle(jh.getModel().getHelpSet().getTitle());
            this.dialogViewer.pack();
        }
        if (bounds != null) {
            Installer.err.log("\tcopying bounds from frame viewer: " + bounds);
            this.dialogViewer.setBounds(bounds);
        }
        this.rearrange(this.currentModalDialog());
        if (this.dialogViewer.isVisible()) {
            Installer.err.log("\talready visible, just repainting");
            this.dialogViewer.repaint();
        } else {
            this.dialogViewer.show();
        }
        this.lastJH = jh;
    }

    public void showHelp(HelpCtx ctx, final boolean showmaster) {
        HelpCtx ctx2;
        HelpCtx helpCtx = ctx2 = ctx != null ? ctx : HelpCtx.DEFAULT_HELP;
        if (!SwingUtilities.isEventDispatchThread()) {
            Installer.err.log("showHelp later...");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JavaHelp.this.showHelp(ctx2, showmaster);
                }
            });
            return;
        }
        Installer.err.log("showing help: " + ctx2);
        final HelpSet[] hs_ = new HelpSet[1];
        Runnable run = new Runnable(){

            public void run() {
                String id = ctx2.getHelpID();
                if (showmaster || ctx2.equals((Object)HelpCtx.DEFAULT_HELP) || id == null) {
                    Installer.err.log("getting master...");
                    hs_[0] = JavaHelp.this.getMaster();
                    Installer.err.log("getting master...done");
                }
                if (hs_[0] == null || id != null && !hs_[0].getCombinedMap().isValidID(id, hs_[0])) {
                    Installer.err.log("finding help set for " + id + "...");
                    hs_[0] = JavaHelp.this.findHelpSetForID(id);
                    Installer.err.log("finding help set for " + id + "...done");
                }
            }
        };
        if (this.master == null) {
            Installer.err.log("showing progress dialog...");
            this.progressHandle = ProgressHandleFactory.createHandle((String)"");
            this.createProgressDialog(run, this.currentModalDialog()).show();
            this.progressHandle.finish();
            Installer.err.log("dialog done.");
        } else {
            run.run();
        }
        HelpSet hs = hs_[0];
        if (hs == null) {
            return;
        }
        JHelp jh = this.createJHelp(hs);
        if (jh == null) {
            throw new IllegalStateException();
        }
        if (JavaHelp.isModalExcludedSupported()) {
            this.displayHelpInFrame(jh);
        } else if (this.currentModalDialog() == null) {
            Installer.err.log("showing as non-dialog");
            this.displayHelpInFrame(jh);
        } else {
            Installer.err.log("showing as dialog");
            this.displayHelpInDialog(jh);
        }
        this.displayInJHelp(jh, ctx2.getHelpID(), ctx2.getHelp());
    }

    public void eventDispatched(AWTEvent awtev) {
        WindowEvent ev = (WindowEvent)awtev;
        int type = ev.getID();
        Window w = ev.getWindow();
        if (type == 201 && w == this.dialogViewer) {
            Installer.err.log("7. Dialog viewer open. Viewer closed. rTFL = false.");
            this.reparentToFrameLater = false;
        }
        if (type != 202 && type != 200) {
            return;
        }
        if (w instanceof Dialog) {
            Dialog d = (Dialog)w;
            String dlgClass = d.getClass().getName();
            if (d.isModal() && !(d instanceof ProgressDialog) || d == this.dialogViewer) {
                if ("sun.awt.windows.WPageDialog".equals(dlgClass) || "sun.awt.windows.WPrintDialog".equals(dlgClass) || "sun.print.ServiceDialog".equals(dlgClass) || "apple.awt.CPrinterJobDialog".equals(dlgClass) || "apple.awt.CPrinterPageDialog".equals(dlgClass)) {
                    return;
                }
                if (d instanceof JDialog && "true".equals(((JDialog)d).getRootPane().getClientProperty("javahelp.ignore.modality"))) {
                    return;
                }
                if (Installer.err.isLoggable(1)) {
                    Installer.err.log("modal (or viewer) dialog event: " + ev + " [" + d.getTitle() + "]");
                }
                if (type == 202) {
                    if (d != this.dialogViewer) {
                        if (d == this.currentModalDialog()) {
                            if (!this.currentModalDialogs.isEmpty()) {
                                this.currentModalDialogs.pop();
                                this.currentModalDialogsReady = true;
                            } else {
                                Installer.err.notify(1, (Throwable)new IllegalStateException("Please see IZ #24993"));
                            }
                            this.showDialogStack();
                            if (!(this.frameViewer != null && this.frameViewer.isVisible() && this.frameViewer.getState() != 1 || this.dialogViewer != null && this.dialogViewer.isVisible())) {
                                if (!this.reparentToFrameLater) {
                                    Installer.err.log("2. No viewer open, !rTFL. Top dialog closed. Pop it.");
                                } else if (this.currentModalDialog() == null) {
                                    Installer.err.log("3. No viewer open, rTFL. Only top dialog closed. Pop it. Create frame viewer.");
                                    if (this.frameViewer != null) {
                                        this.frameViewer.dispose();
                                        this.frameViewer = null;
                                    }
                                    this.displayHelpInFrame(null);
                                } else {
                                    Installer.err.log("4. No viewer open, rTFL. Some top dialog closed. Pop it. Create dialog viewer.");
                                    this.displayHelpInDialog(null);
                                }
                            } else if (this.dialogViewer != null && this.dialogViewer.isVisible()) {
                                Installer.err.log(16, "WARNING - dialogViewer should not still be open");
                            } else {
                                Installer.err.log(16, "WARNING - frameViewer visible when a dialog was closing");
                            }
                        } else {
                            Installer.err.log("some random modal dialog closed: " + d.getName() + " [" + d.getTitle() + "]");
                        }
                    }
                } else if (d != this.dialogViewer) {
                    this.currentModalDialogs.push(d);
                    this.showDialogStack();
                    if (!(this.frameViewer != null && this.frameViewer.isVisible() && this.frameViewer.getState() != 1 || this.dialogViewer != null && this.dialogViewer.isVisible())) {
                        Installer.err.log("1. No viewer open. Dialog opened. Push it on stack. rTFL = false.");
                        this.reparentToFrameLater = false;
                    } else if (this.frameViewer != null && this.frameViewer.isVisible()) {
                        Installer.err.log("5. Frame viewer open. Dialog opened. Push it. Close frame viewer. Create dialog viewer. rTFL = true.");
                        this.displayHelpInDialog(null);
                        this.reparentToFrameLater = true;
                    } else if (this.dialogViewer != null && this.dialogViewer.isVisible()) {
                        Installer.err.log("6. Dialog viewer open. Dialog opened. Push it. Reparent dialog viewer.");
                        this.displayHelpInDialog(null);
                    } else {
                        Installer.err.log(16, "WARNING - logic error");
                    }
                }
            }
        }
    }

    private void showDialogStack() {
        if (Installer.err.isLoggable(1)) {
            StringBuffer buf = new StringBuffer("new modal dialog stack: [");
            boolean first = true;
            Iterator it = this.currentModalDialogs.iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(((Dialog)it.next()).getTitle());
            }
            buf.append("]");
            Installer.err.log(buf.toString());
        }
    }

    private void rearrange(Dialog dlg) {
        Rectangle r2;
        Rectangle r1 = dlg.getBounds();
        if (r1.intersects(r2 = this.dialogViewer.getBounds())) {
            Installer.err.log("modal dialog and dialog viewer overlap");
            Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
            int xExtra = s.width - r1.width - r2.width;
            int yExtra = s.height - r1.height - r2.height;
            if (xExtra >= yExtra) {
                int r1Yaxis = r1.x + r1.width / 2;
                int r2Yaxis = r2.x + r2.width / 2;
                if (r1Yaxis <= r2Yaxis) {
                    Installer.err.log(" send help to the right");
                    if (r1.x + r1.width + r2.width <= s.width) {
                        Installer.err.log("there is enough place fo help");
                        r2.x = r1.x + r1.width;
                    } else {
                        Installer.err.log("there is not enough place");
                        if (r1.width + r2.width < s.width) {
                            Installer.err.log("relocate both");
                            r2.x = s.width - r2.width;
                            r1.x = r2.x - r1.width;
                        } else {
                            Installer.err.log("relocate both and resize help");
                            r1.x = 0;
                            r2.x = r1.width;
                            r2.width = s.width - r1.width;
                        }
                    }
                } else {
                    Installer.err.log("send help to the left");
                    if (r1.x - r2.width > 0) {
                        Installer.err.log("there is enough place for help");
                        r2.x = r1.x - r2.width;
                    } else {
                        Installer.err.log("there is not enough place");
                        if (r1.width + r2.width < s.width) {
                            Installer.err.log("relocate both");
                            r2.x = 0;
                            r1.x = r2.width;
                        } else {
                            Installer.err.log("relocate both and resize help");
                            r1.x = s.width - r1.width;
                            r2.x = 0;
                            r2.width = r1.x;
                        }
                    }
                }
            } else {
                int r1Xaxis = r1.y + r1.height / 2;
                int r2Xaxis = r2.y + r2.height / 2;
                if (r1Xaxis <= r2Xaxis) {
                    Installer.err.log(" send help to the bottom");
                    if (r1.y + r1.height + r2.height <= s.height) {
                        Installer.err.log("there is enough place fo help");
                        r2.y = r1.y + r1.height;
                    } else {
                        Installer.err.log("there is not enough place");
                        if (r1.height + r2.height < s.height) {
                            Installer.err.log("relocate both");
                            r2.y = s.height - r2.height;
                            r1.y = r2.y - r1.height;
                        } else {
                            Installer.err.log("relocate both and resize help");
                            r1.y = 0;
                            r2.y = r1.height;
                            r2.height = s.height - r1.height;
                        }
                    }
                } else {
                    Installer.err.log("send help to the top");
                    if (r1.y - r2.height > 0) {
                        Installer.err.log("there is enough place for help");
                        r2.y = r1.y - r2.height;
                    } else {
                        Installer.err.log("there is not enough place");
                        if (r1.height + r2.height < s.height) {
                            Installer.err.log("relocate both");
                            r2.y = 0;
                            r1.y = r2.height;
                        } else {
                            Installer.err.log("relocate both and resize help");
                            r1.y = s.height - r1.height;
                            r2.y = 0;
                            r2.height = r1.y;
                        }
                    }
                }
            }
            dlg.setBounds(r1);
            this.dialogViewer.setBounds(r2);
        }
    }

    private JDialog createProgressDialog(Runnable run, Dialog parent) {
        return parent == null ? new ProgressDialog(run, WindowManager.getDefault().getMainWindow()) : new ProgressDialog(run, parent);
    }

    private static RequestProcessor getHelpLoader() {
        if (helpLoader == null) {
            helpLoader = new RequestProcessor("org.netbeans.modules.javahelp.JavaHelp");
        }
        return helpLoader;
    }

    private HelpSet findHelpSetForID(String id) {
        if (id != null) {
            Iterator it = this.getHelpSets().iterator();
            while (it.hasNext()) {
                HelpSet hs = (HelpSet)it.next();
                if (!hs.getCombinedMap().isValidID(id, hs)) continue;
                return hs;
            }
            JavaHelp.warnBadID(id);
        }
        return this.getMaster();
    }

    public Boolean isValidID(String id, boolean force) {
        if (force || this.helpSetsReady()) {
            Iterator it = this.getHelpSets().iterator();
            if ("org.netbeans.api.javahelp.MASTER_ID".equals(id)) {
                if (it.hasNext()) {
                    Installer.err.log("master id, and >=1 help set");
                    return Boolean.TRUE;
                }
                Installer.err.log("master id, and 0 help sets");
                return Boolean.FALSE;
            }
            while (it.hasNext()) {
                HelpSet hs = (HelpSet)it.next();
                if (!hs.getCombinedMap().isValidID(id, hs)) continue;
                Installer.err.log("found normal valid id " + id + " in " + hs.getTitle());
                return Boolean.TRUE;
            }
            Installer.err.log("did not find id " + id);
            return Boolean.FALSE;
        }
        Installer.err.log("not checking " + id + " specifically");
        return null;
    }

    private static void warnBadID(String id) {
        Installer.err.log(16, NbBundle.getMessage((Class)JavaHelp.class, (String)"MSG_jh_id_not_found", (Object)id));
    }

    private synchronized void displayInJHelp(JHelp jh, String helpID, URL url) {
        if (jh == null) {
            throw new NullPointerException();
        }
        if (jh.getModel() == null) {
            throw new IllegalArgumentException();
        }
        Installer.err.log("displayInJHelp: " + helpID + " " + url);
        try {
            if (helpID != null && !helpID.equals("org.netbeans.api.javahelp.MASTER_ID")) {
                HelpSet hs = jh.getModel().getHelpSet();
                if (hs.getCombinedMap().isValidID(helpID, hs)) {
                    jh.setCurrentID(helpID);
                } else {
                    JavaHelp.warnBadID(helpID);
                }
            } else if (url != null) {
                jh.setCurrentURL(url);
            }
        }
        catch (RuntimeException e) {
            Installer.err.notify((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JHelp createJHelp(HelpSet hs) {
        JHelp jh;
        if (hs == null) {
            throw new NullPointerException();
        }
        Map map = this.availableJHelps;
        synchronized (map) {
            Reference r = (Reference)this.availableJHelps.get(hs);
            if (r != null && (jh = (JHelp)r.get()) != null) {
                return jh;
            }
        }
        String title = null;
        try {
            title = hs.getTitle();
            jh = new JHelp(hs);
        }
        catch (RuntimeException e) {
            if (title != null) {
                Installer.err.annotate((Throwable)e, 0, "While trying to display: " + title, null, null, null);
            }
            Installer.err.notify((Throwable)e);
            return new JHelp();
        }
        Map e = this.availableJHelps;
        synchronized (e) {
            this.availableJHelps.put(hs, new SoftReference<JHelp>(jh));
        }
        try {
            Map.ID home = hs.getHomeID();
            if (home != null) {
                jh.setCurrentID(home);
            }
        }
        catch (Exception e2) {
            Installer.err.notify(1, (Throwable)e2);
        }
        return jh;
    }

    private static boolean isModalExcludedSupported() {
        if (modalExcludedSupported == -1) {
            modalExcludedSupported = 0;
            try {
                Class<?> clazz = Class.forName("sun.awt.SunToolkit");
                Method m = clazz.getMethod("isModalExcludedSupported", null);
                Boolean b = (Boolean)m.invoke(null, null);
                modalExcludedSupported = b != false ? 1 : 0;
                Installer.err.log("isModalExcludedSupported = " + modalExcludedSupported);
            }
            catch (ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable ex) {
                Installer.err.log("isModalExcludedSupported() failed  " + ex);
            }
        }
        return modalExcludedSupported == 1;
    }

    private static void setModalExcluded(Window window) {
        if (modalExcludedSupported == 0) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("sun.awt.SunToolkit");
            Method m = clazz.getMethod("setModalExcluded", Window.class);
            m.invoke(null, window);
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Installer.err.log("setModalExcluded(Window) failed  " + ex);
            modalExcludedSupported = 0;
        }
    }

    private final class ProgressDialog
    extends JDialog
    implements TaskListener,
    Runnable {
        private Runnable run;

        public ProgressDialog(Runnable run, Dialog parent) {
            super(parent, NbBundle.getMessage((Class)(class$org$netbeans$modules$javahelp$JavaHelp == null ? (class$org$netbeans$modules$javahelp$JavaHelp = JavaHelp.class$("org.netbeans.modules.javahelp.JavaHelp")) : class$org$netbeans$modules$javahelp$JavaHelp), (String)"TITLE_loading_help_sets"), true);
            this.init(run);
        }

        public ProgressDialog(Runnable run, Frame parent) {
            super(parent, NbBundle.getMessage((Class)(class$org$netbeans$modules$javahelp$JavaHelp == null ? (class$org$netbeans$modules$javahelp$JavaHelp = JavaHelp.class$("org.netbeans.modules.javahelp.JavaHelp")) : class$org$netbeans$modules$javahelp$JavaHelp), (String)"TITLE_loading_help_sets"), true);
            this.init(run);
        }

        private void init(Runnable run) {
            this.run = run;
            JComponent c = ProgressHandleFactory.createProgressComponent((ProgressHandle)JavaHelp.this.progressHandle);
            c.setPreferredSize(new Dimension(3 * c.getPreferredSize().width, 3 * c.getPreferredSize().height));
            c.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add(c);
            JavaHelp.this.progressHandle.start();
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$javahelp$JavaHelp == null ? (class$org$netbeans$modules$javahelp$JavaHelp = JavaHelp.class$("org.netbeans.modules.javahelp.JavaHelp")) : class$org$netbeans$modules$javahelp$JavaHelp), (String)"ACSD_Loading_Dialog"));
            this.pack();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension me = this.getSize();
            this.setLocation((screen.width - me.width) / 2, (screen.height - me.height) / 2);
        }

        public void show() {
            if (this.run != null) {
                Installer.err.log("posting request from progress dialog...");
                JavaHelp.getHelpLoader().post(this.run).addTaskListener((TaskListener)this);
                this.run = null;
            }
            super.show();
        }

        public void taskFinished(Task task) {
            Installer.err.log("posting request from progress dialog...request finished.");
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            this.hide();
            this.dispose();
        }
    }
}

