/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.users;

import java.net.URLDecoder;
import javax.management.MBeanServer;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.users.BaseForm;
import org.apache.webapp.admin.users.UserUtils;

public final class GroupForm
extends BaseForm {
    private MBeanServer mserver = null;
    private String description = null;
    private String groupname = null;
    private String[] roles = new String[0];

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String groupname) {
        this.groupname = groupname;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        if (roles == null) {
            roles = new String[]{};
        }
        this.roles = roles;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.description = null;
        this.groupname = null;
        this.roles = new String[0];
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        try {
            if (this.mserver == null) {
                this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
            }
            String databaseName = URLDecoder.decode(request.getParameter("databaseName"), "UTF-8");
            request.setAttribute("rolesForm", (Object)UserUtils.getRolesForm(this.mserver, databaseName));
        }
        catch (Exception e) {
            // empty catch block
        }
        ActionErrors errors = new ActionErrors();
        String submit = request.getParameter("submit");
        if (this.groupname == null || this.groupname.length() < 1) {
            errors.add("groupname", new ActionError("users.error.groupname.required"));
        }
        if (this.groupname != null && this.groupname.indexOf(34) >= 0) {
            errors.add("groupname", new ActionError("users.error.quotes"));
        }
        if (this.description != null && this.description.indexOf(34) > 0) {
            errors.add("description", new ActionError("users.error.quotes"));
        }
        return errors;
    }
}

