/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

class MetalEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final MetalTabPainter metalborder = new MetalTabPainter();
    private static final MetalRightClippedTabPainter rightBorder = new MetalRightClippedTabPainter();
    private static final MetalLeftClippedTabPainter leftBorder = new MetalLeftClippedTabPainter();
    static final Color ATTENTION_COLOR = new Color(255, 238, 120);

    public MetalEditorTabCellRenderer() {
        super(leftBorder, metalborder, rightBorder, new Dimension(34, 29));
        this.setBorder(metalborder);
    }

    protected int getCaptionYAdjustment() {
        return 0;
    }

    public Dimension getPadding() {
        Dimension d = super.getPadding();
        d.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 34 : 24;
        return d;
    }

    private static class MetalRightClippedTabPainter
    implements TabPainter {
        private MetalRightClippedTabPainter() {
        }

        public Insets getBorderInsets(Component c) {
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            return new Insets(mtr.isSelected() ? 3 : 5, mtr.isSelected() ? 10 : 9, 1, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Polygon getInteriorPolygon(Component c) {
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = mtr.isLeftmost() ? 1 : 0;
            int y = 0;
            int width = c.getWidth() + 2;
            int height = mtr.isSelected() ? c.getHeight() + 3 : c.getHeight();
            p.addPoint(x, y + ins.top + 6);
            p.addPoint(x + 6, y + ins.top);
            p.addPoint(x + width, y + ins.top);
            p.addPoint(x + width, y + height);
            p.addPoint(x, y + height);
            return p;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            Polygon p = this.getInteriorPolygon(c);
            g.setColor(UIManager.getColor("controlHighlight"));
            g.drawPolygon(p);
            p.translate(-1, 0);
            Insets ins = this.getBorderInsets(c);
            g.drawLine(x + 6, y + ins.top + 1, x + width - 1, y + ins.top + 1);
            if (mtr.isSelected()) {
                g.drawLine(4, ins.top + 6, 4, ins.top + 6);
                g.drawLine(2, ins.top + 8, 2, ins.top + 8);
                g.drawLine(4, ins.top + 10, 4, ins.top + 10);
                g.drawLine(2, ins.top + 12, 2, ins.top + 12);
                g.drawLine(4, ins.top + 14, 4, ins.top + 14);
                g.drawLine(2, ins.top + 16, 2, ins.top + 16);
            }
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawPolygon(p);
            if (mtr.isSelected()) {
                g.drawLine(5, ins.top + 7, 5, ins.top + 7);
                g.drawLine(3, ins.top + 9, 3, ins.top + 9);
                g.drawLine(5, ins.top + 11, 5, ins.top + 11);
                g.drawLine(3, ins.top + 13, 3, ins.top + 13);
                g.drawLine(5, ins.top + 15, 5, ins.top + 15);
                g.drawLine(3, ins.top + 17, 3, ins.top + 17);
            }
            if (!mtr.isSelected()) {
                g.setColor(UIManager.getColor("controlDkShadow"));
                g.drawLine(x, c.getHeight() - 1, c.getWidth() - 1, c.getHeight() - 1);
            }
        }

        public void paintInterior(Graphics g, Component c) {
            Polygon p = this.getInteriorPolygon(c);
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            if (mtr.isAttention()) {
                g.setColor(ATTENTION_COLOR);
            }
            g.fillPolygon(p);
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            bounds.setBounds(-20, -20, 0, 0);
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return false;
        }
    }

    private static class MetalLeftClippedTabPainter
    implements TabPainter {
        private MetalLeftClippedTabPainter() {
        }

        public Insets getBorderInsets(Component c) {
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            return new Insets(mtr.isSelected() ? 3 : 5, mtr.isSelected() ? 10 : 9, 1, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Polygon getInteriorPolygon(Component c) {
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = -1;
            int y = ins.top;
            int width = c.getWidth();
            int height = mtr.isSelected() ? c.getHeight() + 3 : c.getHeight();
            p.addPoint(x, y);
            p.addPoint(x + width, y);
            p.addPoint(x + width, y + height);
            p.addPoint(x, y + height);
            return p;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            g.setColor(UIManager.getColor("controlHighlight"));
            Polygon p = this.getInteriorPolygon(c);
            p.translate(0, 1);
            g.drawPolygon(p);
            p.translate(0, -1);
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawPolygon(p);
            if (!mtr.isSelected()) {
                g.drawLine(x, y + height - 1, x + width, y + height - 1);
            }
        }

        public void paintInterior(Graphics g, Component c) {
            Polygon p = this.getInteriorPolygon(c);
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            if (mtr.isAttention()) {
                g.setColor(ATTENTION_COLOR);
            }
            g.fillPolygon(p);
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            bounds.setBounds(-20, -20, 0, 0);
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return false;
        }
    }

    private static class MetalTabPainter
    implements TabPainter {
        private MetalTabPainter() {
        }

        public Insets getBorderInsets(Component c) {
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            return new Insets(mtr.isSelected() ? 3 : 5, mtr.isSelected() ? 10 : 9, 1, 0);
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return ((AbstractTabCellRenderer)renderer).isShowCloseButton();
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            Polygon p = this.getInteriorPolygon(c);
            g.setColor(UIManager.getColor("controlHighlight"));
            g.drawPolygon(p);
            p.translate(-1, 0);
            Insets ins = this.getBorderInsets(c);
            g.drawLine(x + 6, y + ins.top + 1, x + width - 1, y + ins.top + 1);
            if (mtr.isSelected()) {
                g.drawLine(4, ins.top + 6, 4, ins.top + 6);
                g.drawLine(2, ins.top + 8, 2, ins.top + 8);
                g.drawLine(4, ins.top + 10, 4, ins.top + 10);
                g.drawLine(2, ins.top + 12, 2, ins.top + 12);
                g.drawLine(4, ins.top + 14, 4, ins.top + 14);
                g.drawLine(2, ins.top + 16, 2, ins.top + 16);
            }
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawPolygon(p);
            if (mtr.isSelected()) {
                g.drawLine(5, ins.top + 7, 5, ins.top + 7);
                g.drawLine(3, ins.top + 9, 3, ins.top + 9);
                g.drawLine(5, ins.top + 11, 5, ins.top + 11);
                g.drawLine(3, ins.top + 13, 3, ins.top + 13);
                g.drawLine(5, ins.top + 15, 5, ins.top + 15);
                g.drawLine(3, ins.top + 17, 3, ins.top + 17);
            }
            if (!mtr.isSelected()) {
                g.setColor(UIManager.getColor("controlDkShadow"));
                g.drawLine(x, mtr.getHeight() - 1, mtr.getWidth() - 1, mtr.getHeight() - 1);
            }
        }

        public Polygon getInteriorPolygon(Component c) {
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = mtr.isLeftmost() ? 1 : 0;
            int y = 0;
            int width = mtr.isLeftmost() ? c.getWidth() - 1 : c.getWidth();
            int height = mtr.isSelected() ? c.getHeight() + 3 : c.getHeight();
            p.addPoint(x, y + ins.top + 6);
            p.addPoint(x + 6, y + ins.top);
            p.addPoint(x + width, y + ins.top);
            p.addPoint(x + width, y + height);
            p.addPoint(x, y + height);
            return p;
        }

        public void paintInterior(Graphics g, Component c) {
            Color col;
            MetalEditorTabCellRenderer mtr = (MetalEditorTabCellRenderer)c;
            if (mtr.isAttention()) {
                g.setColor(ATTENTION_COLOR);
            }
            Polygon p = this.getInteriorPolygon(c);
            g.fillPolygon(p);
            Rectangle r = new Rectangle();
            this.getCloseButtonRectangle(mtr, r, new Rectangle(0, 0, mtr.getWidth(), mtr.getHeight()));
            r.x += 2;
            r.y += 2;
            r.width -= 4;
            r.height -= 4;
            if (mtr.inCloseButton() && mtr.isPressed()) {
                col = ColorUtil.getMiddle(mtr.getBackground(), mtr.getBackground().darker());
                g.setColor(col);
                g.fillRect(r.x - 2, r.y - 2, r.width + 3, r.height + 3);
            }
            if (mtr.isSelected()) {
                g.setColor(UIManager.getColor("controlHighlight"));
                r.translate(1, 1);
                g.drawLine(r.x, r.y, r.x + r.width - 1, r.y + r.height - 1);
                g.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y);
                r.translate(-1, -1);
            }
            g.setColor(mtr.getForeground());
            g.drawLine(r.x, r.y, r.x + r.width - 1, r.y + r.height - 1);
            g.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y);
            if (mtr.inCloseButton()) {
                col = mtr.getBackground().darker();
                if (mtr.isPressed()) {
                    col = col.darker();
                }
                g.setColor(col);
                g.drawRect(r.x - 2, r.y - 2, r.width + 3, r.height + 3);
            }
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            if (!((AbstractTabCellRenderer)jc).isShowCloseButton()) {
                rect.x = -100;
                rect.y = -100;
                rect.width = 0;
                rect.height = 0;
                return;
            }
            Insets ins = this.getBorderInsets(jc);
            rect.y = bounds.y + ins.top;
            rect.height = bounds.height - rect.y;
            rect.x = bounds.x + bounds.width - 10;
            rect.width = 5;
            rect.y += rect.height / 2 - 2;
            rect.height = 5;
            rect.width += 4;
            rect.height += 4;
            rect.x -= 2;
            rect.y -= 2;
        }
    }
}

