/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.jaxrpc;

import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.websvc.registry.util.Util;

public class WrapperClientWriter
extends PrintWriter {
    private String serviceName;
    private String serviceVariable;
    private String className;
    private String superClassName;
    private Set interfaces = new HashSet();
    private String packageName;
    private Set imports = new HashSet();
    private Set ports = new HashSet();
    private Set constructorStatements = new HashSet();
    int indent = 0;

    public WrapperClientWriter(Writer writer) {
        super(writer);
    }

    public void setContainedClassInfo(String serviceName) {
        this.serviceName = serviceName;
        this.serviceVariable = serviceName.substring(serviceName.lastIndexOf(46) + 1, serviceName.length());
        this.serviceVariable = this.serviceVariable.toLowerCase() + "1";
    }

    public void setPackage(String pkgName) {
        this.packageName = pkgName;
    }

    public void addImport(String importLine) {
        this.imports.add(importLine);
    }

    public void setName(String name) {
        this.className = name;
    }

    public void setSuperClass(String superClass) {
        this.superClassName = superClass;
    }

    public void addInterface(String interfaceName) {
        this.interfaces.add(interfaceName);
    }

    public void addConstructorStatements(String statement) {
        this.constructorStatements.add(statement);
    }

    public void addPort(Port inPort) {
        this.ports.add(inPort);
    }

    public void writeClass() {
        Iterator iter;
        this.println("package " + this.packageName + ";");
        this.println();
        if (!this.imports.isEmpty()) {
            iter = this.imports.iterator();
            while (iter.hasNext()) {
                this.println("import " + iter.next() + ";");
            }
            this.println();
        }
        this.println("import java.rmi.RemoteException;");
        this.println("import javax.xml.rpc.ServiceException;");
        this.println("import javax.xml.rpc.Stub;");
        this.println();
        this.print("public class " + this.className);
        if (this.superClassName != null) {
            this.print("extends " + this.superClassName + " ");
        }
        if (!this.interfaces.isEmpty()) {
            this.println("implements ");
            iter = this.interfaces.iterator();
            while (iter.hasNext()) {
                this.print((String)iter.next());
                if (!iter.hasNext()) continue;
                this.print(",");
            }
        }
        this.println(" {");
        this.println();
        this.println("  private " + this.serviceName + " " + this.serviceVariable + " = " + "new " + this.serviceName + "_Impl();");
        if (!this.ports.isEmpty()) {
            Iterator portIterator = this.ports.iterator();
            Port currentPort = null;
            while (portIterator.hasNext()) {
                currentPort = (Port)portIterator.next();
                String portImplName = Util.getProperPortName(currentPort.getName().getLocalPart());
                String portInterfaceName = currentPort.getJavaInterface().getName();
                portInterfaceName = portInterfaceName.substring(portInterfaceName.lastIndexOf(46) + 1, portInterfaceName.length());
                String portInterfaceVariable = portInterfaceName.substring(portInterfaceName.lastIndexOf(46) + 1, portInterfaceName.length());
                String portInterfacePrefix = portInterfaceVariable.toLowerCase();
                portInterfaceVariable = portInterfaceVariable.toLowerCase() + "1";
                String modifiedPortName = Util.upperCaseFirstChar(portInterfaceName);
                this.println("  private " + portInterfaceName + " " + portInterfaceVariable + ";");
                this.addConstructorStatements(portInterfaceVariable + " = " + this.serviceVariable + ".get" + portImplName + "()");
                this.println("  private Stub " + portInterfacePrefix + "Stub;");
                this.addConstructorStatements(portInterfacePrefix + "Stub = (Stub)" + portInterfaceVariable);
            }
            this.println();
            this.println("  public " + this.className + "() throws ServiceException {");
            if (!this.constructorStatements.isEmpty()) {
                Iterator iter2 = this.constructorStatements.iterator();
                while (iter2.hasNext()) {
                    this.println("    " + (String)iter2.next() + ";");
                }
            }
            this.println("  }");
            this.println();
            this.printOperations(this.ports);
            this.println("}");
        }
    }

    private void printOperations(Set inPorts) {
        Iterator portIterator = inPorts.iterator();
        Port currentPort = null;
        while (portIterator.hasNext()) {
            currentPort = (Port)portIterator.next();
            String lowercasePortName = Util.getProperPortName(currentPort.getName().getLocalPart()).toLowerCase();
            String portInterfaceName = currentPort.getJavaInterface().getName();
            portInterfaceName = portInterfaceName.substring(portInterfaceName.lastIndexOf(46) + 1, portInterfaceName.length());
            String portInterfaceVariable = portInterfaceName.substring(portInterfaceName.lastIndexOf(46) + 1, portInterfaceName.length());
            String portInterfacePrefix = portInterfaceVariable.toLowerCase();
            portInterfaceVariable = portInterfaceVariable.toLowerCase() + "1";
            Iterator operationsIterator = currentPort.getOperations();
            Operation currentOperation = null;
            while (operationsIterator.hasNext()) {
                currentOperation = (Operation)operationsIterator.next();
                if (null == currentOperation) continue;
                JavaMethod method = currentOperation.getJavaMethod();
                String modifiedMethodName = Util.upperCaseFirstChar(method.getName());
                this.println();
                this.print("  public " + method.getReturnType().getRealName() + " ");
                this.print(lowercasePortName + modifiedMethodName + "(");
                Iterator params = method.getParameters();
                String parameterType = "";
                while (params.hasNext()) {
                    JavaParameter param = (JavaParameter)params.next();
                    parameterType = Util.getParameterType(currentPort, param);
                    this.print(parameterType + " " + param.getName());
                    if (!params.hasNext()) continue;
                    this.write(", ");
                }
                this.print(") ");
                Iterator exceptions = method.getExceptions();
                this.print(" throws ");
                while (exceptions.hasNext()) {
                    Object currentException = exceptions.next();
                    if (null == currentException || !(currentException instanceof String) || ((String)currentException).length() <= 0) continue;
                    this.print((String)currentException);
                    this.print(", ");
                }
                this.println(" RemoteException { ");
                if (!"void".equals(method.getReturnType().getRealName())) {
                    this.print("       return " + portInterfaceVariable + "." + method.getName() + "(");
                } else {
                    this.print("       " + portInterfaceVariable + "." + method.getName() + "(");
                }
                params = method.getParameters();
                while (params.hasNext()) {
                    JavaParameter param = (JavaParameter)params.next();
                    this.print(param.getName());
                    if (!params.hasNext()) continue;
                    this.write(", ");
                }
                this.println(");");
                this.println("  }");
            }
            this.println("public void " + lowercasePortName + "SetUsername(String inUserName) {");
            this.println("        " + portInterfacePrefix + "Stub._setProperty(Stub.USERNAME_PROPERTY, inUserName);");
            this.println("}");
            this.println();
            this.println("public void " + lowercasePortName + "SetPassword(String inPassword) {");
            this.println("        " + portInterfacePrefix + "Stub._setProperty(Stub.PASSWORD_PROPERTY, inPassword);");
            this.println("}");
            this.println();
            this.println("public void " + lowercasePortName + "SetAddress(String inAddress) {");
            this.println("        " + portInterfacePrefix + "Stub._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY, inAddress);");
            this.println("}");
            this.println();
        }
    }

    public static void main(String[] args) {
    }

    public class Method {
        Set methodStatement = new HashSet();

        public Method(JavaMethod method) {
        }

        public void addStatement(String statement) {
            this.methodStatement.add(statement);
        }

        public Set getStatements() {
            return this.methodStatement;
        }
    }
}

