/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.wizards.FileType;
import org.netbeans.modules.web.wizards.TargetChooserPanelGUI;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class TargetChooserPanel
implements WizardDescriptor.Panel {
    private final List listeners = new ArrayList();
    private TargetChooserPanelGUI gui;
    private Project project;
    private SourceGroup[] folders;
    private FileType fileType;
    private TemplateWizard templateWizard;
    private String j2eeVersion;
    private static final Pattern INVALID_FILENAME_CHARACTERS = Pattern.compile("[`~!@#$%^&*()=+\\|{};:'\",<>/?]");

    TargetChooserPanel(Project project, SourceGroup[] folders, FileType fileType) {
        this.folders = folders;
        this.project = project;
        this.fileType = fileType;
        if (FileType.TAG.equals(fileType)) {
            WebModule wm;
            this.j2eeVersion = "1.4";
            if (folders != null && folders.length > 0 && (wm = WebModule.getWebModule((FileObject)folders[0].getRootFolder())) != null) {
                this.j2eeVersion = wm.getJ2eePlatformVersion();
            }
        }
    }

    TemplateWizard getTemplateWizard() {
        return this.templateWizard;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new TargetChooserPanelGUI(this, this.project, this.folders, this.fileType);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        boolean valid;
        String errorMessage;
        String tldName;
        String filename;
        boolean ok;
        if (FileType.TAG.equals(this.fileType) && "1.3".equals(this.j2eeVersion)) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_13notSupported"));
            return false;
        }
        boolean bl = ok = this.gui != null && this.gui.getTargetName() != null;
        if (!ok) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", null);
            return false;
        }
        if (FileType.TAG.equals(this.fileType) && this.gui.isTldCheckBoxSelected()) {
            String mes = null;
            FileObject tldFo = this.gui.getTldFileObject();
            String tagName = this.gui.getTagName();
            if (tldFo == null) {
                mes = NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_noTldSelectedForTagFile");
            } else if (!this.gui.isValidTagName(tagName)) {
                mes = NbBundle.getMessage(TargetChooserPanel.class, (String)"TXT_wrongTagName", (Object)tagName);
            } else if (this.gui.tagNameExists(tagName)) {
                mes = NbBundle.getMessage(TargetChooserPanel.class, (String)"TXT_tagNameExists", (Object)tagName);
            }
            if (mes != null) {
                this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)mes);
                return false;
            }
        }
        if (INVALID_FILENAME_CHARACTERS.matcher(filename = this.gui.getTargetName()).find()) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_invalid_filename", (Object)filename));
            return false;
        }
        if (FileType.TAGLIBRARY.equals(this.fileType) && ((tldName = this.gui.getTargetName()).indexOf(32) >= 0 || tldName.indexOf(44) >= 0)) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TXT_wrongTagLibName", (Object)tldName));
            return false;
        }
        String targetName = this.gui.getTargetName();
        File file = this.gui.getTargetFile();
        FileObject template = Templates.getTemplate((WizardDescriptor)this.templateWizard);
        String ext = template.getExt();
        if (FileType.JSP.equals(this.fileType) || FileType.TAG.equals(this.fileType)) {
            if (this.isSegment()) {
                ext = ext + "f";
            } else if (this.isXml()) {
                ext = ext + "x";
            }
        }
        if ((errorMessage = Utilities.canUseFileName(file, this.gui.getRelativeTargetFolder(), targetName, ext)) != null) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
        } else {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)this.gui.getErrorMessage());
        }
        boolean bl2 = valid = this.gui.isPanelValid() && errorMessage == null;
        if (valid && targetName.indexOf(".") >= 0) {
            this.templateWizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"MSG_dotsInName", (Object)(targetName + "." + ext)));
        }
        return valid;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    protected void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }

    public void readSettings(Object settings) {
        this.templateWizard = (TemplateWizard)settings;
        if (this.gui != null) {
            Project project = Templates.getProject((WizardDescriptor)this.templateWizard);
            FileObject preselectedTarget = Templates.getTargetFolder((WizardDescriptor)this.templateWizard);
            this.gui.initValues(project, Templates.getTemplate((WizardDescriptor)this.templateWizard), preselectedTarget);
            if (FileType.JSP.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_JspFile"));
            } else if (FileType.TAG.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_TagFile"));
            } else if (FileType.TAGLIBRARY.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_TLD"));
            } else if (FileType.HTML.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_HTML"));
            } else if (FileType.XHTML.equals(this.fileType)) {
                this.templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(TargetChooserPanel.class, (String)"TITLE_XHTML"));
            }
        }
    }

    public void storeSettings(Object settings) {
        if (WizardDescriptor.PREVIOUS_OPTION.equals(((WizardDescriptor)settings).getValue())) {
            return;
        }
        if (WizardDescriptor.CANCEL_OPTION.equals(((WizardDescriptor)settings).getValue())) {
            return;
        }
        if (this.isValid()) {
            File f = new File(this.gui.getCreatedFilePath());
            File ff = new File(f.getParentFile().getPath());
            if (!ff.exists()) {
                ff.mkdir();
            }
            FileObject folder = FileUtil.toFileObject((File)ff);
            Templates.setTargetFolder((WizardDescriptor)((WizardDescriptor)settings), (FileObject)folder);
            Templates.setTargetName((WizardDescriptor)((WizardDescriptor)settings), (String)this.gui.getTargetName());
        }
        ((WizardDescriptor)settings).putProperty("NewFileWizard_Title", null);
    }

    boolean isXml() {
        return this.gui.isXml();
    }

    boolean isSegment() {
        return this.gui.isSegment();
    }

    String getUri() {
        return this.gui.getUri();
    }

    String getPrefix() {
        return this.gui.getPrefix();
    }

    boolean isTldCheckBoxSelected() {
        return this.gui.isTldCheckBoxSelected();
    }

    String getTagName() {
        return this.gui.getTagName();
    }

    FileObject getTldFileObject() {
        return this.gui.getTldFileObject();
    }
}

